/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluatorAbstractBase;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.ContentPropertyName;
import org.alfresco.repo.action.evaluator.compare.PropertyValueComparator;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComparePropertyValueEvaluator
extends ActionConditionEvaluatorAbstractBase {
    private static Log logger = LogFactory.getLog(ComparePropertyValueEvaluator.class);
    public static final String NAME = "compare-property-value";
    public static final String PARAM_PROPERTY = "property";
    public static final String PARAM_CONTENT_PROPERTY = "content-property";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_OPERATION = "operation";
    private static final QName DEFAULT_PROPERTY = ContentModel.PROP_NAME;
    private static final String MSGID_INVALID_OPERATION = "compare_property_value_evaluator.invalid_operation";
    private static final String MSGID_NO_CONTENT_PROPERTY = "compare_property_value_evaluator.no_content_property";
    private Map<QName, PropertyValueComparator> comparators = new HashMap<QName, PropertyValueComparator>();
    protected NodeService nodeService;
    protected ContentService contentService;
    protected DictionaryService dictionaryService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPropertyValueComparators(List<PropertyValueComparator> comparators) {
        for (PropertyValueComparator comparator : comparators) {
            comparator.registerComparator(this);
        }
    }

    public void registerComparator(QName dataType, PropertyValueComparator comparator) {
        this.comparators.put(dataType, comparator);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_PROPERTY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CONTENT_PROPERTY, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_CONTENT_PROPERTY), false, "ac-content-properties"));
        paramList.add(new ParameterDefinitionImpl(PARAM_VALUE, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_VALUE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_OPERATION, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_OPERATION), false, "ac-compare-operations"));
    }

    @Override
    public boolean evaluateImpl(ActionCondition ruleCondition, NodeRef actionedUponNodeRef) {
        boolean result = false;
        if (this.nodeService.exists(actionedUponNodeRef)) {
            QName propertyQName = (QName)ruleCondition.getParameterValue(PARAM_PROPERTY);
            if (propertyQName == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("ComparePropertyValue - Property is NULL.  Setting to " + DEFAULT_PROPERTY));
                }
                propertyQName = DEFAULT_PROPERTY;
            }
            Object propertyValue = this.nodeService.getProperty(actionedUponNodeRef, propertyQName);
            Serializable compareValue = ruleCondition.getParameterValue(PARAM_VALUE);
            ComparePropertyValueOperation operation = null;
            String operationString = (String)((Object)ruleCondition.getParameterValue(PARAM_OPERATION));
            if (operationString != null) {
                operation = ComparePropertyValueOperation.valueOf(operationString);
            }
            QName propertyTypeQName = DataTypeDefinition.ANY;
            PropertyDefinition propertyDefintion = this.dictionaryService.getProperty(propertyQName);
            if (propertyDefintion != null) {
                propertyTypeQName = propertyDefintion.getDataType().getName();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluating Property Parameters, propertyQName - [" + propertyQName + "] getInverted? [" + ruleCondition.getInvertCondition() + "] operation [" + (Object)((Object)operation) + "]"));
                logger.debug((Object)("Compare Value [" + compareValue + "] Actual Value [" + propertyValue + "]"));
            }
            if (DataTypeDefinition.CONTENT.equals((Object)propertyTypeQName)) {
                ContentPropertyName contentProperty = null;
                String contentPropertyString = (String)((Object)ruleCondition.getParameterValue(PARAM_CONTENT_PROPERTY));
                if (contentPropertyString == null) {
                    throw new ActionServiceException(MSGID_NO_CONTENT_PROPERTY);
                }
                contentProperty = ContentPropertyName.valueOf(contentPropertyString);
                if (propertyValue != null) {
                    ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, propertyValue);
                    switch (contentProperty) {
                        case ENCODING: {
                            propertyTypeQName = DataTypeDefinition.TEXT;
                            propertyValue = contentData.getEncoding();
                            break;
                        }
                        case SIZE: {
                            propertyTypeQName = DataTypeDefinition.LONG;
                            propertyValue = contentData.getSize();
                            break;
                        }
                        case MIME_TYPE: {
                            propertyTypeQName = DataTypeDefinition.TEXT;
                            propertyValue = contentData.getMimetype();
                        }
                    }
                }
            }
            if (propertyValue != null) {
                PropertyValueComparator comparator = this.comparators.get(propertyTypeQName);
                if (comparator != null) {
                    result = comparator.compare((Serializable)propertyValue, compareValue, operation);
                } else {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Comparator not found for property type " + propertyTypeQName));
                    }
                    if (operation != null && operation != ComparePropertyValueOperation.EQUALS) {
                        throw new ActionServiceException(MSGID_INVALID_OPERATION, new Object[]{operation.toString(), propertyTypeQName.toString()});
                    }
                    result = compareValue.equals(propertyValue);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Condition Comparator encountered null value for property [" + propertyTypeQName + "]"));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning result " + result));
        }
        return result;
    }
}

