/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.content.metadata.MetadataEmbedder;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentMetadataEmbedder
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(ContentMetadataEmbedder.class);
    public static final String EXECUTOR_NAME = "embed-metadata";
    private NodeService nodeService;
    private ContentService contentService;
    private MetadataExtracterRegistry metadataExtracterRegistry;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) {
            return;
        }
        ContentReader reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null || reader.getMimetype() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no content or mimetype - do nothing");
            }
            return;
        }
        String mimetype = reader.getMimetype();
        MetadataEmbedder embedder = this.metadataExtracterRegistry.getEmbedder(mimetype);
        if (embedder == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no embedder for mimetype:" + mimetype));
            }
            return;
        }
        ContentWriter writer = this.contentService.getWriter(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
        if (writer == null || writer.getMimetype() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no content or mimetype - do nothing");
            }
            return;
        }
        Map nodeProperties = this.nodeService.getProperties(actionedUponNodeRef);
        try {
            embedder.embed(nodeProperties, reader, writer);
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Metadata embedding failed: \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + writer), e);
            }
            logger.warn((Object)("Metadata embedding failed (turn on DEBUG for full error): \n   Extracter: " + this + "\n" + "   Node:      " + actionedUponNodeRef + "\n" + "   Content:   " + writer + "\n" + "   Failure:   " + e.getMessage()));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> arg0) {
    }
}

