/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.AbstractUserNotifier;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.InitializingBean;

public class EmailUserNotifier
extends AbstractUserNotifier
implements InitializingBean {
    private List<String> excludedEmailSuffixes;
    private AuthenticationContext authenticationContext;
    private ActionService actionService;

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public static Log getLogger() {
        return logger;
    }

    public static void setLogger(Log logger) {
        EmailUserNotifier.logger = logger;
    }

    public List<String> getExcludedEmailSuffixes() {
        return this.excludedEmailSuffixes;
    }

    public void setExcludedEmailSuffixes(List<String> excludedEmailSuffixes) {
        this.excludedEmailSuffixes = excludedEmailSuffixes;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        PropertyCheck.mandatory((Object)this, (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
    }

    public void afterPropertiesSet() throws Exception {
        this.checkProperties();
    }

    @Override
    protected boolean skipUser(NodeRef personNodeRef) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        String feedUserId = (String)personProps.get(ContentModel.PROP_USERNAME);
        String emailAddress = (String)personProps.get(ContentModel.PROP_EMAIL);
        Boolean emailFeedDisabled = (Boolean)personProps.get(ContentModel.PROP_EMAIL_FEED_DISABLED);
        if (emailFeedDisabled != null && emailFeedDisabled.booleanValue()) {
            return true;
        }
        if (this.authenticationContext.isSystemUserName(feedUserId) || this.authenticationContext.isGuestUserName(feedUserId)) {
            return true;
        }
        if (emailAddress == null || emailAddress.length() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skip for '" + feedUserId + "' since they have no email address set"));
            }
            return true;
        }
        String lowerEmailAddress = emailAddress.toLowerCase();
        for (String excludedEmailSuffix : this.excludedEmailSuffixes) {
            if (!lowerEmailAddress.endsWith(excludedEmailSuffix.toLowerCase())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skip for '" + feedUserId + "' since email address is excluded (" + emailAddress + ")"));
            }
            return true;
        }
        return false;
    }

    @Override
    protected Long getFeedId(NodeRef personNodeRef) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        Long emailFeedDBID = (Long)personProps.get(ContentModel.PROP_EMAIL_FEED_ID);
        if (emailFeedDBID != null) {
            Long l = emailFeedDBID;
            Long l2 = emailFeedDBID = Long.valueOf(emailFeedDBID + 1L);
        } else {
            emailFeedDBID = -1L;
        }
        return emailFeedDBID;
    }

    @Override
    protected void notifyUser(NodeRef personNodeRef, String subjectText, Object[] subjectParams, Map<String, Object> model, String templateNodeRef) {
        ParameterCheck.mandatory((String)"personNodeRef", (Object)personNodeRef);
        Map personProps = this.nodeService.getProperties(personNodeRef);
        String emailAddress = (String)personProps.get(ContentModel.PROP_EMAIL);
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("to", (Serializable)((Object)emailAddress));
        mail.setParameterValue("subject", (Serializable)((Object)subjectText));
        mail.setParameterValue("subjectParams", (Serializable)subjectParams);
        mail.setParameterValue("template", (Serializable)((Object)templateNodeRef));
        mail.setParameterValue("template_model", (Serializable)((Object)model));
        this.actionService.executeAction(mail, null);
    }
}

