/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.local;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.activities.feed.FeedTaskProcessor;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.domain.activities.FeedControlDAO;
import org.alfresco.repo.domain.activities.FeedControlEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class LocalFeedTaskProcessor
extends FeedTaskProcessor
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(LocalFeedTaskProcessor.class);
    private ActivityPostDAO postDAO;
    private ActivityFeedDAO feedDAO;
    private FeedControlDAO feedControlDAO;
    private SiteService siteService;
    private NodeService nodeService;
    private ContentService contentService;
    private PermissionService permissionService;
    private SubscriptionService subscriptionService;
    private TenantService tenantService;
    private String defaultEncoding;
    private List<String> templateSearchPaths;
    private boolean useRemoteCallbacks;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setFeedControlDAO(FeedControlDAO feedControlDAO) {
        this.feedControlDAO = feedControlDAO;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setSubscriptionService(SubscriptionService subscriptionService) {
        this.subscriptionService = subscriptionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setTemplateSearchPaths(List<String> templateSearchPaths) {
        this.templateSearchPaths = templateSearchPaths;
    }

    public void setUseRemoteCallbacks(boolean useRemoteCallbacks) {
        this.useRemoteCallbacks = useRemoteCallbacks;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    @Override
    public void startTransaction() throws SQLException {
    }

    @Override
    public void commitTransaction() throws SQLException {
    }

    @Override
    public void rollbackTransaction() throws SQLException {
    }

    @Override
    public void endTransaction() throws SQLException {
    }

    @Override
    public List<ActivityPostEntity> selectPosts(ActivityPostEntity selector) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selecting posts with the selector: " + selector.toString()));
        }
        List<ActivityPostEntity> activityPosts = this.postDAO.selectPosts(selector, -1);
        if (logger.isTraceEnabled()) {
            for (ActivityPostEntity activityPost : activityPosts) {
                logger.trace((Object)("Selected post: " + activityPost.toString()));
            }
        }
        return activityPosts;
    }

    @Override
    public long insertFeedEntry(ActivityFeedEntity feed) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inserting feed entry: " + feed.toString()));
        }
        return this.feedDAO.insertFeedEntry(feed);
    }

    @Override
    public int updatePostStatus(long id, ActivityPostEntity.STATUS status) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating post with id: " + id + " , with status: " + status.toString()));
        }
        return this.postDAO.updatePostStatus(id, status);
    }

    @Override
    public List<FeedControlEntity> selectUserFeedControls(String userId) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selecting feed controls for user : " + userId));
        }
        List<FeedControlEntity> userFeedControls = this.feedControlDAO.selectFeedControls(userId);
        if (logger.isTraceEnabled()) {
            for (FeedControlEntity userFeedControl : userFeedControls) {
                logger.trace((Object)("Selected user feed control: " + userFeedControl.toString()));
            }
        }
        return userFeedControls;
    }

    @Override
    protected String getTenantName(String name, String tenantDomain) {
        if (name == null) {
            return name;
        }
        String nameDomain = this.getTenantDomain(name);
        if (nameDomain.equals("")) {
            if (!"".equals(tenantDomain)) {
                name = "@" + tenantDomain + "@" + name;
            }
        } else if (!tenantDomain.equals(nameDomain)) {
            throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
        }
        return name;
    }

    @Override
    protected String getTenantDomain(String name) {
        return this.tenantService.getDomain(name, false);
    }

    @Override
    protected Set<String> getSiteMembers(final RepoCtx ctx, String siteIdIn, String tenantDomain) throws Exception {
        if (this.useRemoteCallbacks) {
            return super.getSiteMembers(ctx, siteIdIn, tenantDomain);
        }
        final String siteId = this.tenantService.getBaseName(siteIdIn, true);
        return (Set)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Set<String>>(){

            public Set<String> doWork() throws Exception {
                Map<String, String> mapResult;
                HashSet<String> members = new HashSet<String>();
                if (siteId != null && siteId.length() != 0 && (mapResult = LocalFeedTaskProcessor.this.siteService.listMembers(siteId, null, null, 0, true)) != null && mapResult.size() != 0) {
                    for (String userName : mapResult.keySet()) {
                        if (!ctx.isUserNamesAreCaseSensitive()) {
                            userName = userName.toLowerCase();
                        }
                        members.add(userName);
                    }
                }
                return members;
            }
        }, (String)tenantDomain);
    }

    @Override
    protected boolean canReadSite(RepoCtx ctx, String siteIdIn, final String connectedUser, String tenantDomain) throws Exception {
        if (this.useRemoteCallbacks) {
            throw new UnsupportedOperationException("Not implemented");
        }
        final String siteId = this.tenantService.getBaseName(siteIdIn, true);
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                boolean canRead = false;
                SiteInfo siteInfo = LocalFeedTaskProcessor.this.siteService.getSite(siteId);
                if (siteInfo != null) {
                    switch (siteInfo.getVisibility()) {
                        case MODERATED: {
                            canRead = LocalFeedTaskProcessor.this.siteService.isMember(siteId, connectedUser);
                            break;
                        }
                        case PUBLIC: 
                        case PRIVATE: {
                            canRead = true;
                            break;
                        }
                    }
                }
                return canRead;
            }
        }, (String)connectedUser);
    }

    @Override
    protected boolean canRead(RepoCtx ctx, final String connectedUser, Map<String, Object> model) throws Exception {
        if (this.useRemoteCallbacks) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (this.permissionService == null) {
            return true;
        }
        String nodeRefStr = (String)model.get("nodeRef");
        if (nodeRefStr == null) {
            nodeRefStr = (String)model.get("parentNodeRef");
        }
        if (nodeRefStr != null) {
            final NodeRef nodeRef = new NodeRef(nodeRefStr);
            String tenantDomain = (String)model.get("tenantDomain");
            if (tenantDomain == null) {
                tenantDomain = "";
            }
            return (Boolean)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return LocalFeedTaskProcessor.this.canReadImpl(connectedUser, nodeRef);
                }
            }, (String)tenantDomain);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canReadImpl(String connectedUser, NodeRef nodeRef) throws Exception {
        long start = System.currentTimeMillis();
        try {
            NodeRef checkNodeRef;
            if (this.nodeService.exists(nodeRef)) {
                checkNodeRef = nodeRef;
            } else {
                NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, nodeRef.getId());
                if (!this.nodeService.exists(archiveNodeRef)) {
                    boolean bl = false;
                    return bl;
                }
                checkNodeRef = archiveNodeRef;
            }
            if (connectedUser.equals("")) {
                Set perms = this.permissionService.getAllSetPermissions(checkNodeRef);
                for (AccessPermission perm : perms) {
                    if (!perm.getAuthority().equals("GROUP_EVERYONE") || !perm.getAuthorityType().equals((Object)AuthorityType.EVERYONE) || !perm.getPermission().equals("ReadPermissions") || !perm.getAccessStatus().equals((Object)AccessStatus.ALLOWED)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return LocalFeedTaskProcessor.this.permissionService.hasPermission(checkNodeRef, "Read") == AccessStatus.ALLOWED;
                }
            }, (String)connectedUser);
            return bl;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("canRead: " + nodeRef + " in " + (System.currentTimeMillis() - start) + " msecs"));
            }
        }
    }

    @Override
    protected Map<String, List<String>> getActivityTypeTemplates(String repoEndPoint, String ticket, String subPath) throws Exception {
        int idx;
        if (this.useRemoteCallbacks) {
            return super.getActivityTypeTemplates(repoEndPoint, ticket, subPath);
        }
        String path = "/";
        String templatePattern = "*.ftl";
        if (subPath != null && subPath.length() > 0 && (idx = (subPath = subPath + "*").lastIndexOf("/")) != -1) {
            path = subPath.substring(0, idx);
            templatePattern = subPath.substring(idx + 1) + ".ftl";
        }
        List<String> allTemplateNames = this.getDocumentPaths(path, false, templatePattern);
        return this.getActivityTemplates(allTemplateNames);
    }

    @Override
    protected Configuration getFreemarkerConfiguration(RepoCtx ctx) {
        if (this.useRemoteCallbacks) {
            return super.getFreemarkerConfiguration(ctx);
        }
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setTemplateLoader((TemplateLoader)new ClassPathRepoTemplateLoader(this.nodeService, this.contentService, this.defaultEncoding));
        cfg.setLocalizedLookup(false);
        return cfg;
    }

    private List<String> getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (documentPattern == null || documentPattern.length() == 0) {
            documentPattern = "*";
        }
        ArrayList<String> documentPaths = new ArrayList<String>(0);
        for (String classPath : this.templateSearchPaths) {
            StringBuilder pattern = new StringBuilder(128);
            pattern.append("classpath*:").append(classPath).append(path).append(includeSubPaths ? "**/" : "").append(documentPattern);
            try {
                documentPaths.addAll(this.getPaths(pattern.toString(), classPath));
            }
            catch (IOException e) {}
        }
        return documentPaths;
    }

    private List<String> getPaths(String pattern, String classPath) throws IOException {
        Resource[] resources = this.resolver.getResources(pattern);
        ArrayList<String> documentPaths = new ArrayList<String>(resources.length);
        for (Resource resource : resources) {
            String resourcePath = resource.getURL().toExternalForm();
            int idx = resourcePath.lastIndexOf(classPath);
            if (idx == -1) continue;
            String documentPath = resourcePath.substring(idx);
            documentPath = documentPath.replace('\\', '/');
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Item resource path: " + resourcePath + " , item path: " + documentPath));
            }
            documentPaths.add(documentPath);
        }
        return documentPaths;
    }

    @Override
    protected Set<String> getFollowers(final String userId, String tenantDomain) throws Exception {
        if (this.useRemoteCallbacks) {
            throw new UnsupportedOperationException("Not implemented");
        }
        final HashSet<String> result = new HashSet<String>();
        if (this.subscriptionService.isActive()) {
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    PagingFollowingResults fr = LocalFeedTaskProcessor.this.subscriptionService.getFollowers(userId, new PagingRequest(1000000, null));
                    if (fr.getPage() != null) {
                        result.addAll(fr.getPage());
                    }
                    return null;
                }
            }, (String)tenantDomain);
        }
        return result;
    }
}

