/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.admin.RepoServerMgmtMBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationService;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoServerMgmt
implements RepoServerMgmtMBean {
    private static final Log log = LogFactory.getLog(RepoServerMgmt.class);
    private TransactionServiceImpl transactionService;
    private AbstractAuthenticationService authenticationService;
    private ClassLoader managedResourceClassLoader = Thread.currentThread().getContextClassLoader();

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationService(AbstractAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Override
    public boolean isReadOnly() {
        return this.transactionService.isReadOnly();
    }

    @Override
    public int getTicketCountNonExpired() {
        return this.useManagedResourceClassloader(new Work<Integer>(){

            @Override
            Integer doWork() {
                return RepoServerMgmt.this.authenticationService.countTickets(true);
            }
        });
    }

    @Override
    public int getTicketCountAll() {
        return this.useManagedResourceClassloader(new Work<Integer>(){

            @Override
            Integer doWork() {
                return RepoServerMgmt.this.authenticationService.countTickets(false);
            }
        });
    }

    @Override
    public int getUserCountNonExpired() {
        return this.useManagedResourceClassloader(new Work<Integer>(){

            @Override
            Integer doWork() {
                return RepoServerMgmt.this.authenticationService.getUsersWithTickets(true).size();
            }
        });
    }

    @Override
    public int getUserCountAll() {
        return this.authenticationService.getUsersWithTickets(false).size();
    }

    @Override
    public String[] listUserNamesNonExpired() {
        return this.useManagedResourceClassloader(new Work<String[]>(){

            @Override
            String[] doWork() {
                Set<String> userSet = RepoServerMgmt.this.authenticationService.getUsersWithTickets(true);
                TreeSet<String> sorted = new TreeSet<String>(userSet);
                return sorted.toArray(new String[0]);
            }
        });
    }

    @Override
    public String[] listUserNamesAll() {
        return this.useManagedResourceClassloader(new Work<String[]>(){

            @Override
            String[] doWork() {
                Set<String> userSet = RepoServerMgmt.this.authenticationService.getUsersWithTickets(false);
                TreeSet<String> sorted = new TreeSet<String>(userSet);
                return sorted.toArray(new String[0]);
            }
        });
    }

    @Override
    public int invalidateTicketsExpired() {
        return this.useManagedResourceClassloader(new Work<Integer>(){

            @Override
            Integer doWork() {
                int count = RepoServerMgmt.this.authenticationService.invalidateTickets(true);
                log.info((Object)("Expired tickets invalidated: " + count));
                return count;
            }
        });
    }

    @Override
    public int invalidateTicketsAll() {
        return this.useManagedResourceClassloader(new Work<Integer>(){

            @Override
            Integer doWork() {
                int count = RepoServerMgmt.this.authenticationService.invalidateTickets(false);
                log.info((Object)("All tickets invalidated: " + count));
                return count;
            }
        });
    }

    @Override
    public void invalidateUser(final String username) {
        this.useManagedResourceClassloader(new Work<Void>(){

            @Override
            Void doWork() {
                RepoServerMgmt.this.authenticationService.invalidateUserSession(username);
                log.info((Object)("User invalidated: " + username));
                return null;
            }
        });
    }

    @Override
    public int getMaxUsers() {
        return this.authenticationService.getMaxUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T useManagedResourceClassloader(Work<T> work) {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.managedResourceClassLoader);
            T t = work.doWork();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private static abstract class Work<T> {
        private Work() {
        }

        abstract T doWork();
    }
}

