/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrPropBackedBeanPatch
extends AbstractPatch
implements ApplicationContextAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ROOT_KEY_PBB = ".PropertyBackedBeans";
    private static final String MSG_SUCCESS = "patch.migrateAttrPropBackedBeans.result";
    private AttributeService attributeService;
    private PatchDAO patchDAO;
    private MBeanServerConnection mbeanServer;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mbeanServer = (MBeanServerConnection)applicationContext.getBean("alfrescoMBeanServer");
    }

    @Override
    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        PBBesultHandler handler = new PBBesultHandler();
        this.patchDAO.migrateOldAttrPropertyBackedBeans(handler);
        handler.setComponent(handler.currentComponentName, handler.attributeMap);
        if (handler.total > 0) {
            this.logger.info((Object)("Processed " + handler.total + " Property-Backed Component attrs (" + handler.totalProps + " props) in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{handler.total, handler.totalProps});
        return msg;
    }

    private class PBBesultHandler
    implements ResultHandler {
        private int total = 0;
        private int totalProps = 0;
        private Map<String, String> attributeMap = new HashMap<String, String>(10);
        private String currentComponentName = "";

        private PBBesultHandler() {
        }

        public void handleResult(ResultContext context) {
            Map result = (Map)context.getResultObject();
            String componentName = (String)result.get("componentName");
            String propName = (String)result.get("propName");
            String propValue = (String)result.get("propValue");
            if (!this.currentComponentName.equals(componentName)) {
                this.setComponent(this.currentComponentName, this.attributeMap);
                this.currentComponentName = componentName;
                this.attributeMap.clear();
            }
            this.attributeMap.put(propName, propValue);
            ++this.totalProps;
            if (MigrateAttrPropBackedBeanPatch.this.logger.isTraceEnabled()) {
                MigrateAttrPropBackedBeanPatch.this.logger.trace((Object)("Read PBB [componentName=" + componentName + ", propName=" + propName + ", propValue=" + propValue + "]"));
            }
        }

        public void setComponent(String componentName, Map<String, String> attributeMap) {
            boolean done;
            block9: {
                if (componentName.equals("") || attributeMap.size() == 0) {
                    return;
                }
                done = false;
                try {
                    String[] components = componentName.split("\\$");
                    StringBuilder nameBuff = new StringBuilder(200).append("Alfresco:Type=Configuration,Category=").append(URLDecoder.decode(components[0], "UTF-8"));
                    for (int i = 1; i < components.length; ++i) {
                        nameBuff.append(",id").append(i).append('=').append(URLDecoder.decode(components[i], "UTF-8"));
                    }
                    ObjectName name = new ObjectName(nameBuff.toString());
                    if (MigrateAttrPropBackedBeanPatch.this.mbeanServer != null && MigrateAttrPropBackedBeanPatch.this.mbeanServer.isRegistered(name)) {
                        AttributeList attributeList = new AttributeList();
                        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
                            attributeList.add(new Attribute(entry.getKey(), entry.getValue()));
                        }
                        MigrateAttrPropBackedBeanPatch.this.mbeanServer.setAttributes(name, attributeList);
                        done = true;
                    }
                }
                catch (Exception e) {
                    if (!MigrateAttrPropBackedBeanPatch.this.logger.isWarnEnabled()) break block9;
                    MigrateAttrPropBackedBeanPatch.this.logger.warn((Object)("Exception migrating attributes of subsystem " + componentName + ". Falling back to repository-only operation. Subsystem may remain out of sync until reboot."), (Throwable)e);
                }
            }
            if (!done) {
                MigrateAttrPropBackedBeanPatch.this.attributeService.setAttribute((Serializable)((Object)attributeMap), new Serializable[]{MigrateAttrPropBackedBeanPatch.ROOT_KEY_PBB, componentName});
            }
            if (MigrateAttrPropBackedBeanPatch.this.logger.isTraceEnabled()) {
                MigrateAttrPropBackedBeanPatch.this.logger.trace((Object)("Set PBB component attr [name=" + componentName + ", attributeMap=" + attributeMap + "]"));
            }
            ++this.total;
            if (MigrateAttrPropBackedBeanPatch.this.logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                MigrateAttrPropBackedBeanPatch.this.logger.debug((Object)("   Handled " + this.total + " Chaining URS attrs"));
            }
        }
    }
}

