/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.impl.GenericBootstrapPatch;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.extensions.surf.util.I18NUtil;

public class SharedFolderPatch
extends GenericBootstrapPatch {
    private JobLockService jobLockService;
    private long LOCK_TIME_TO_LIVE = 10000L;
    private long LOCK_REFRESH_TIME = 5000L;
    private String renamePath;
    private Log logger = LogFactory.getLog(SharedFolderPatch.class);
    private static final String MSG_RENAMED = "patch.sharedFolder.result.renamed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAsync() {
        QName lockQName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"patch.sharedFolder");
        String lockToken = this.jobLockService.getLock(lockQName, this.LOCK_TIME_TO_LIVE, 0L, 1);
        SharedFolderPatchCallback callback = new SharedFolderPatchCallback();
        this.jobLockService.refreshLock(lockToken, lockQName, this.LOCK_REFRESH_TIME, callback);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"SharedFolderPatch: job lock held");
            }
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    SharedFolderPatch.this.applyAsync();
                    return null;
                }
            });
        }
        finally {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"PUSH: job finished");
            }
            callback.isActive = false;
            this.jobLockService.releaseLock(lockToken, lockQName);
        }
    }

    @Override
    protected String applyInternal() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (this.getRenamePath() != null) {
            List results = this.searchService.selectNodes(rootNodeRef, this.getRenamePath(), null, (NamespacePrefixResolver)this.namespaceService, false);
            if (results.size() > 1) {
                throw new PatchException("patch.genericBootstrap.err.multiple_found", this.renamePath);
            }
            if (results.size() == 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("There is an existing node in the way path:" + this.getRenamePath()));
                }
                NodeRef existingNodeRef = (NodeRef)results.get(0);
                LinkedList<String> folderElements = new LinkedList<String>(Arrays.asList(this.getRenamePath().split("/")));
                folderElements.removeLast();
                StringBuffer parentPath = new StringBuffer();
                for (String folder : folderElements) {
                    parentPath.append("/");
                    parentPath.append(folder);
                }
                List parentResults = this.searchService.selectNodes(rootNodeRef, parentPath.toString(), null, (NamespacePrefixResolver)this.namespaceService, false);
                if (parentResults.size() == 1) {
                    NodeRef parentNodeRef = (NodeRef)parentResults.get(0);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found the parent node - doing a move parentNodeRef:" + parentNodeRef));
                    }
                    this.nodeService.moveNode(existingNodeRef, parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"shared"));
                    return I18NUtil.getMessage((String)MSG_RENAMED, (Object[])new Object[]{this.renamePath});
                }
                throw new PatchException("patch.genericBootstrap.err.multiple_found", parentPath.toString());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Node does not already exist, Running the Generic Bootstrap Patch");
        }
        return super.applyInternal();
    }

    public void setRenamePath(String renamePath) {
        this.renamePath = renamePath;
    }

    public String getRenamePath() {
        return this.renamePath;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public JobLockService getJobLockService() {
        return this.jobLockService;
    }

    private class SharedFolderPatchCallback
    implements JobLockService.JobLockRefreshCallback {
        public boolean isActive = true;

        private SharedFolderPatchCallback() {
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void lockReleased() {
            if (SharedFolderPatch.this.logger.isTraceEnabled()) {
                SharedFolderPatch.this.logger.trace((Object)"lock released");
            }
        }
    }

    public static class SharedFolderPatchJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object sharedFolderPatchObj = jobData.get((Object)"sharedFolderPatch");
            if (sharedFolderPatchObj == null || !(sharedFolderPatchObj instanceof SharedFolderPatch)) {
                throw new AlfrescoRuntimeException("'sharedFolderPatch' data must contain valid 'SharedFolderPatch' reference");
            }
            SharedFolderPatch sharedFolderPatch = (SharedFolderPatch)sharedFolderPatchObj;
            sharedFolderPatch.executeAsync();
        }
    }
}

