/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.impl.lucene.AVMLuceneIndexer;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.springframework.extensions.surf.util.I18NUtil;

public class WCMPostPermissionSnapshotPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.wcmPostPermissionSnapshotPatch.result";
    private static final String AVM_SITE_STORE_NAME = "sitestore";
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;
    private AVMService avmService;
    private PatchDAO patchDAO;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    @Override
    protected String applyInternal() throws Exception {
        AVMLuceneIndexer indexer;
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        Thread progressThread = null;
        Long toDo = this.patchDAO.getAVMNodesCountWhereNewInStore();
        ArrayList<AVMLuceneIndexer> indexers = new ArrayList<AVMLuceneIndexer>(stores.size());
        for (AVMStoreDescriptor storeDesc : stores) {
            if (storeDesc.getName().equals(AVM_SITE_STORE_NAME)) continue;
            indexer = this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexer(storeDesc.getName());
            indexers.add(indexer);
        }
        progressThread = new Thread((Runnable)new ProgressWatcher(toDo, indexers), "WCMPactchProgressWatcher");
        progressThread.start();
        for (AVMStoreDescriptor storeDesc : stores) {
            if (storeDesc.getName().equals(AVM_SITE_STORE_NAME) || this.avmService.getStoreRoot(-1, storeDesc.getName()).getLayerID() != -1L) continue;
            this.avmService.createSnapshot(storeDesc.getName(), "PermissionPatch", "Snapshot after 2.2 permission patch");
            indexer = this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexer(storeDesc.getName());
            indexer.flushPending();
        }
        progressThread.interrupt();
        progressThread.join();
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }

    private class ProgressWatcher
    implements Runnable {
        private boolean running = true;
        Long toDo;
        List<AVMLuceneIndexer> indexers;

        ProgressWatcher(Long toDo, List<AVMLuceneIndexer> indexers) {
            this.toDo = toDo;
            this.indexers = indexers;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
                if (!this.running) continue;
                long done = 0L;
                for (AVMLuceneIndexer indexer : this.indexers) {
                    if (indexer == null) continue;
                    done += indexer.getIndexedDocCount();
                }
                WCMPostPermissionSnapshotPatch.this.reportProgress(this.toDo, done);
            }
        }
    }
}

