/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.AuditException;
import org.alfresco.repo.audit.AuditFilter;
import org.alfresco.repo.audit.extractor.DataExtractor;
import org.alfresco.repo.audit.generator.DataGenerator;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PathMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class AuditComponentImpl
implements AuditComponent {
    private static final String INBOUND_LOGGER = "org.alfresco.repo.audit.inbound";
    private static Log logger = LogFactory.getLog(AuditComponentImpl.class);
    private static Log loggerInbound = LogFactory.getLog((String)"org.alfresco.repo.audit.inbound");
    private AuditModelRegistryImpl auditModelRegistry;
    private PropertyValueDAO propertyValueDAO;
    private AuditDAO auditDAO;
    private TransactionService transactionService;
    private AuditFilter auditFilter;

    public void setAuditModelRegistry(AuditModelRegistryImpl auditModelRegistry) {
        this.auditModelRegistry = auditModelRegistry;
    }

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    public void setAuditDAO(AuditDAO auditDAO) {
        this.auditDAO = auditDAO;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuditFilter(AuditFilter auditFilter) {
        this.auditFilter = auditFilter;
    }

    @Override
    public int deleteAuditEntries(String applicationName, Long fromTime, Long toTime) {
        ParameterCheck.mandatory((String)"applicationName", (Object)applicationName);
        AlfrescoTransactionSupport.checkTransactionReadState(true);
        AuditApplication application = this.auditModelRegistry.getAuditApplicationByName(applicationName);
        if (application == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No audit application named '" + applicationName + "' has been registered."));
            }
            return 0;
        }
        Long applicationId = application.getApplicationId();
        int deleted = this.auditDAO.deleteAuditEntries(applicationId, fromTime, toTime);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete audit " + deleted + " entries for " + applicationName + " (" + fromTime + " to " + toTime));
        }
        return deleted;
    }

    @Override
    public int deleteAuditEntries(List<Long> auditEntryIds) {
        if (auditEntryIds.size() == 0) {
            return 0;
        }
        return this.auditDAO.deleteAuditEntries(auditEntryIds);
    }

    private Set<String> getDisabledPaths(AuditApplication application) {
        try {
            Long disabledPathsId = application.getDisabledPathsId();
            Set disabledPaths = (Set)((Object)this.propertyValueDAO.getPropertyById(disabledPathsId));
            return new HashSet<String>(disabledPaths);
        }
        catch (Throwable e) {
            this.auditModelRegistry.loadAuditModels();
            throw new AlfrescoRuntimeException("Unabled to get AuditApplication disabled paths: " + application, e);
        }
    }

    @Override
    public boolean isAuditEnabled() {
        return this.auditModelRegistry.isAuditEnabled();
    }

    @Override
    public void setAuditEnabled(boolean enable) {
        boolean alreadyEnabled = this.auditModelRegistry.isAuditEnabled();
        if (alreadyEnabled != enable) {
            this.auditModelRegistry.stop();
            this.auditModelRegistry.setProperty("audit.enabled", Boolean.toString(enable).toLowerCase());
            this.auditModelRegistry.start();
        }
    }

    @Override
    public Map<String, AuditApplication> getAuditApplications() {
        return this.auditModelRegistry.getAuditApplications();
    }

    @Override
    public boolean areAuditValuesRequired() {
        if (this.transactionService.isReadOnly()) {
            return false;
        }
        return loggerInbound.isDebugEnabled() || this.isAuditEnabled() && !this.auditModelRegistry.getAuditPathMapper().isEmpty();
    }

    @Override
    public boolean areAuditValuesRequired(String path) {
        if (loggerInbound.isDebugEnabled()) {
            return !this.transactionService.isReadOnly();
        }
        PathMapper pathMapper = this.auditModelRegistry.getAuditPathMapper();
        Set mappedPaths = pathMapper.getMappedPathsWithPartialMatch(path);
        return mappedPaths.size() > 0 && !this.transactionService.isReadOnly();
    }

    @Override
    public boolean isAuditPathEnabled(String applicationName, String path) {
        ParameterCheck.mandatory((String)"applicationName", (Object)applicationName);
        AlfrescoTransactionSupport.checkTransactionReadState(false);
        AuditApplication application = this.auditModelRegistry.getAuditApplicationByName(applicationName);
        if (application == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No audit application named '" + applicationName + "' has been registered."));
            }
            return false;
        }
        if (path == null) {
            path = "/" + application.getApplicationKey();
        } else {
            application.checkPath(path);
        }
        Set<String> disabledPaths = this.getDisabledPaths(application);
        String disablingPath = null;
        for (String disabledPath : disabledPaths) {
            if (!path.startsWith(disabledPath)) continue;
            disablingPath = disabledPath;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Audit path enabled check: \n   Application:    " + applicationName + "\n" + "   Path:           " + path + "\n" + "   Disabling Path: " + disablingPath));
        }
        return disablingPath == null;
    }

    @Override
    public void enableAudit(String applicationName, String path) {
        ParameterCheck.mandatory((String)"applicationName", (Object)applicationName);
        AlfrescoTransactionSupport.checkTransactionReadState(true);
        AuditApplication application = this.auditModelRegistry.getAuditApplicationByName(applicationName);
        if (application == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No audit application named '" + applicationName + "' has been registered."));
            }
            return;
        }
        if (path == null) {
            path = "/" + application.getApplicationKey();
        } else {
            application.checkPath(path);
        }
        Long disabledPathsId = application.getDisabledPathsId();
        Set<String> disabledPaths = this.getDisabledPaths(application);
        boolean changed = false;
        Iterator<String> iterateDisabledPaths = disabledPaths.iterator();
        while (iterateDisabledPaths.hasNext()) {
            String disabledPath = iterateDisabledPaths.next();
            if (!disabledPath.startsWith(path)) continue;
            iterateDisabledPaths.remove();
            changed = true;
        }
        if (changed) {
            this.propertyValueDAO.updateProperty(disabledPathsId, (Serializable)((Object)disabledPaths));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Audit disabled paths updated: \n   Application: " + applicationName + "\n" + "   Disabled:    " + disabledPaths));
            }
        }
    }

    @Override
    public void disableAudit(String applicationName, String path) {
        ParameterCheck.mandatory((String)"applicationName", (Object)applicationName);
        AlfrescoTransactionSupport.checkTransactionReadState(true);
        AuditApplication application = this.auditModelRegistry.getAuditApplicationByName(applicationName);
        if (application == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No audit application named '" + applicationName + "' has been registered."));
            }
            return;
        }
        if (path == null) {
            path = "/" + application.getApplicationKey();
        } else {
            application.checkPath(path);
        }
        Long disabledPathsId = application.getDisabledPathsId();
        Set<String> disabledPaths = this.getDisabledPaths(application);
        if (disabledPaths.contains(path)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Audit disable path already present: \n   Path:       " + path));
            }
            return;
        }
        Iterator<String> iterateDisabledPaths = disabledPaths.iterator();
        while (iterateDisabledPaths.hasNext()) {
            String disabledPath = iterateDisabledPaths.next();
            if (disabledPath.startsWith(path)) {
                iterateDisabledPaths.remove();
                continue;
            }
            if (!path.startsWith(disabledPath)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Audit disable path superceded: \n   Path:          " + path + "\n" + "   Superceded by: " + disabledPath));
            }
            return;
        }
        disabledPaths.add(path);
        this.propertyValueDAO.updateProperty(disabledPathsId, (Serializable)((Object)disabledPaths));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Audit disabled paths updated: \n   Application: " + applicationName + "\n" + "   Disabled:    " + disabledPaths));
        }
    }

    @Override
    public void resetDisabledPaths(String applicationName) {
        ParameterCheck.mandatory((String)"applicationName", (Object)applicationName);
        AlfrescoTransactionSupport.checkTransactionReadState(true);
        AuditApplication application = this.auditModelRegistry.getAuditApplicationByName(applicationName);
        if (application == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No audit application named '" + applicationName + "' has been registered."));
            }
            return;
        }
        Long disabledPathsId = application.getDisabledPathsId();
        this.propertyValueDAO.updateProperty(disabledPathsId, (Serializable)((Object)Collections.emptySet()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed all disabled paths for application " + applicationName));
        }
    }

    @Override
    public Map<String, Serializable> recordAuditValues(String rootPath, Map<String, Serializable> values) {
        String path;
        String pathElement;
        ParameterCheck.mandatory((String)"rootPath", (Object)rootPath);
        AuditApplication.checkPathFormat(rootPath);
        if (values == null || values.isEmpty() || !this.areAuditValuesRequired() || !this.auditFilter.accept(rootPath, values)) {
            return Collections.emptyMap();
        }
        if (loggerInbound.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(values.size() * 64);
            sb.append("\n").append("Inbound audit values:");
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                pathElement = entry.getKey();
                path = AuditApplication.buildPath(rootPath, pathElement);
                Serializable value = entry.getValue();
                sb.append("\n\t").append(path).append("=").append(value);
            }
            loggerInbound.debug((Object)sb.toString());
        }
        HashMap<String, Serializable> pathedValues = new HashMap<String, Serializable>(values.size() * 2);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            pathElement = entry.getKey();
            path = AuditApplication.buildPath(rootPath, pathElement);
            pathedValues.put(path, entry.getValue());
        }
        PathMapper pathMapper = this.auditModelRegistry.getAuditPathMapper();
        final Map mappedValues = pathMapper.convertMap(pathedValues);
        if (mappedValues.isEmpty()) {
            return mappedValues;
        }
        AlfrescoTransactionSupport.TxnReadState txnState = AlfrescoTransactionSupport.getTransactionReadState();
        switch (txnState) {
            case TXN_NONE: 
            case TXN_READ_ONLY: {
                RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

                    @Override
                    public Map<String, Serializable> execute() throws Throwable {
                        return AuditComponentImpl.this.recordAuditValuesImpl(mappedValues);
                    }
                };
                return this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
            }
            case TXN_READ_WRITE: {
                return this.recordAuditValuesImpl(mappedValues);
            }
        }
        throw new IllegalStateException("Unknown txn state: " + (Object)((Object)txnState));
    }

    public Map<String, Serializable> recordAuditValuesImpl(Map<String, Serializable> mappedValues) {
        HashMap<String, Serializable> rootKeyMappedValues;
        String rootKey;
        HashMap<String, HashMap<String, Serializable>> mappedValuesByRootKey = new HashMap<String, HashMap<String, Serializable>>();
        for (Map.Entry<String, Serializable> entry : mappedValues.entrySet()) {
            String path = entry.getKey();
            rootKey = AuditApplication.getRootKey(path);
            rootKeyMappedValues = (HashMap<String, Serializable>)mappedValuesByRootKey.get(rootKey);
            if (rootKeyMappedValues == null) {
                rootKeyMappedValues = new HashMap<String, Serializable>(7);
                mappedValuesByRootKey.put(rootKey, rootKeyMappedValues);
            }
            rootKeyMappedValues.put(path, entry.getValue());
        }
        HashMap<String, Serializable> allAuditedValues = new HashMap<String, Serializable>(mappedValues.size() * 2 + 1);
        for (Map.Entry entry : mappedValuesByRootKey.entrySet()) {
            rootKey = (String)entry.getKey();
            rootKeyMappedValues = (Map)entry.getValue();
            AuditApplication application = this.auditModelRegistry.getAuditApplicationByKey(rootKey);
            if (application == null) {
                logger.debug((Object)("There is no application for root key: " + rootKey));
                continue;
            }
            Set<String> disabledPaths = this.getDisabledPaths(application);
            if (disabledPaths.contains(AuditApplication.buildPath(rootKey))) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Audit values root path has been excluded by disabled paths: \n   Application: " + application + "\n" + "   Root Path:   " + AuditApplication.buildPath(rootKey)));
                continue;
            }
            Map<String, Serializable> rootKeyAuditValues = this.audit(application, disabledPaths, rootKeyMappedValues);
            allAuditedValues.putAll(rootKeyAuditValues);
        }
        return allAuditedValues;
    }

    private Map<String, Serializable> audit(final AuditApplication application, Set<String> disabledPaths, final Map<String, Serializable> values) {
        Long applicationId = application.getApplicationId();
        if (applicationId == null) {
            throw new AuditException("No persisted instance exists for audit application: " + application);
        }
        if (values.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Audit values have all been excluded by disabled paths: \n   Application: " + application + "\n" + "   Values:      " + values));
            }
            return Collections.emptyMap();
        }
        Set<String> generatorKeys = values.keySet();
        Iterator<String> generatorKeysIterator = generatorKeys.iterator();
        while (generatorKeysIterator.hasNext()) {
            String generatorKey = generatorKeysIterator.next();
            for (String disabledPath : disabledPaths) {
                if (!generatorKey.startsWith(disabledPath)) continue;
                generatorKeysIterator.remove();
            }
        }
        Map<String, DataGenerator> generators = application.getDataGenerators(generatorKeys);
        Map<String, Serializable> auditData = this.generateData(generators);
        Map extractedData = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Serializable>>(){

            public Map<String, Serializable> doWork() throws Exception {
                return AuditComponentImpl.this.extractData(application, values);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        auditData.putAll(extractedData);
        long time = System.currentTimeMillis();
        String username = AuthenticationUtil.getFullyAuthenticatedUser();
        Long entryId = null;
        if (!auditData.isEmpty()) {
            boolean justGatherPreCallData = application.isApplicationJustGeneratingPreCallData();
            if (!justGatherPreCallData) {
                entryId = this.auditDAO.createAuditEntry(applicationId, time, username, auditData);
            }
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append((justGatherPreCallData ? "\nPreCallData: \n" : "\nNew audit entry: \n") + "\tApplication ID: " + applicationId + "\n" + (justGatherPreCallData ? "" : "\tEntry ID:       " + entryId + "\n") + "\tValues:         " + "\n");
                for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                    sb.append("\t\t").append(entry).append("\n");
                }
                sb.append("\n\tAudit Data: \n");
                for (Map.Entry<String, Serializable> entry : auditData.entrySet()) {
                    sb.append("\t\t").append(entry).append("\n");
                }
                logger.debug((Object)sb.toString());
            }
        } else if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nNothing audited: \n\tApplication ID: " + applicationId + "\n" + "\tEntry ID:       " + entryId + "\n" + "\tValues:         " + "\n");
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                sb.append("\t\t").append(entry).append("\n");
            }
            logger.debug((Object)sb.toString());
        }
        return auditData;
    }

    private Map<String, Serializable> extractData(AuditApplication application, Map<String, Serializable> values) {
        HashMap<String, Serializable> newData = new HashMap<String, Serializable>(values.size());
        List<AuditApplication.DataExtractorDefinition> extractors = application.getDataExtractors();
        for (AuditApplication.DataExtractorDefinition extractorDef : extractors) {
            Serializable data;
            Serializable value;
            DataExtractor dataExtractor = extractorDef.getDataExtractor();
            String triggerPath = extractorDef.getDataTrigger();
            String sourcePath = extractorDef.getDataSource();
            String targetPath = extractorDef.getDataTarget();
            if (!values.containsKey(triggerPath) || !values.containsKey(sourcePath) || !dataExtractor.isSupported(value = values.get(sourcePath))) continue;
            try {
                data = dataExtractor.extractData(value);
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to extract audit data: \n   Path:      " + sourcePath + "\n" + "   Raw value: " + value + "\n" + "   Extractor: " + dataExtractor, e);
            }
            newData.put(targetPath, data);
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nExtracted audit data: \n\tApplication:    " + application + "\n" + "\tValues:         " + "\n");
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                sb.append("\t\t").append(entry).append("\n");
            }
            sb.append("\n\tNew Data: \n");
            for (Map.Entry<String, Serializable> entry : newData.entrySet()) {
                sb.append("\t\t").append(entry).append("\n");
            }
            logger.debug((Object)sb.toString());
        }
        return newData;
    }

    private Map<String, Serializable> generateData(Map<String, DataGenerator> generators) {
        HashMap<String, Serializable> newData = new HashMap<String, Serializable>(generators.size() + 5);
        for (Map.Entry<String, DataGenerator> entry : generators.entrySet()) {
            Serializable data;
            String path = entry.getKey();
            DataGenerator generator = entry.getValue();
            try {
                data = generator.getData();
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to generate audit data: \n   Path:      " + path + "\n" + "   Generator: " + generator, e);
            }
            newData.put(path, data);
        }
        return newData;
    }

    @Override
    public void auditQuery(AuditService.AuditQueryCallback callback, AuditQueryParameters parameters, int maxResults) {
        ParameterCheck.mandatory((String)"callback", (Object)callback);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        if (parameters.isZeroResultQuery()) {
            return;
        }
        this.auditDAO.findAuditEntries(callback, parameters, maxResults);
    }
}

