/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.node.AbstractNodeServiceImpl;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreExistsException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMNodeService
extends AbstractNodeServiceImpl
implements NodeService {
    private static Log logger = LogFactory.getLog(AVMNodeService.class);
    private boolean fInvokePolicies = false;
    private AVMService fAVMService;
    private static QName[] fgBuiltinAspects = new QName[]{ContentModel.ASPECT_AUDITABLE, ContentModel.ASPECT_REFERENCEABLE};
    static QName[] fgBuiltinProperties = new QName[]{ContentModel.PROP_CREATED, ContentModel.PROP_CREATOR, ContentModel.PROP_MODIFIED, ContentModel.PROP_MODIFIER, ContentModel.PROP_OWNER, ContentModel.PROP_CONTENT, ContentModel.PROP_NAME, ContentModel.PROP_NODE_UUID, ContentModel.PROP_NODE_DBID, ContentModel.PROP_STORE_PROTOCOL, ContentModel.PROP_STORE_IDENTIFIER, WCMModel.PROP_AVM_FILE_INDIRECTION, WCMModel.PROP_AVM_DIR_INDIRECTION};

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    public void setInvokePolicies(boolean invoke) {
        this.fInvokePolicies = invoke;
    }

    protected PropertyValue makePropertyValue(PropertyDefinition propertyDef, Serializable value) {
        QName propertyTypeQName = null;
        if (propertyDef == null) {
            propertyTypeQName = DataTypeDefinition.ANY;
        } else {
            propertyTypeQName = propertyDef.getDataType().getName();
            boolean isMultiValued = propertyDef.isMultiValued();
            if (isMultiValued && !(value instanceof Collection)) {
                if (value != null) {
                    value = (Serializable)((Object)Collections.singletonList(value));
                }
            } else if (!isMultiValued && value instanceof Collection && !propertyTypeQName.equals((Object)DataTypeDefinition.ANY)) {
                throw new DictionaryException("A single-valued property of this type may not be a collection: \n   Property: " + propertyDef + "\n" + "   Type: " + propertyTypeQName + "\n" + "   Value: " + value);
            }
        }
        try {
            PropertyValue propertyValue = new PropertyValue(propertyTypeQName, value);
            return propertyValue;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   value: " + value + "\n" + "   value type: " + value.getClass(), (Throwable)e);
        }
    }

    protected Serializable makeSerializableValue(PropertyDefinition propertyDef, PropertyValue propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        QName propertyTypeQName = null;
        propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        try {
            Serializable value = propertyValue.getValue(propertyTypeQName);
            return value;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   property value: " + propertyValue, (Throwable)e);
        }
    }

    public List<StoreRef> getStores() {
        List<AVMStoreDescriptor> stores = this.fAVMService.getStores();
        ArrayList<StoreRef> result = new ArrayList<StoreRef>();
        for (AVMStoreDescriptor desc : stores) {
            String name = desc.getName();
            result.add(new StoreRef("avm", name));
        }
        return result;
    }

    public StoreRef createStore(String protocol, String identifier) throws StoreExistsException {
        StoreRef result = new StoreRef("avm", identifier);
        try {
            this.fAVMService.createStore(identifier);
            NodeRef rootRef = this.getRootNode(result);
            this.addAspect(rootRef, ContentModel.ASPECT_ROOT, Collections.emptyMap());
            return result;
        }
        catch (AVMExistsException e) {
            throw new StoreExistsException(result, (Throwable)((Object)e));
        }
    }

    public void deleteStore(StoreRef storeRef) throws InvalidStoreRefException {
        throw new UnsupportedOperationException();
    }

    public boolean exists(StoreRef storeRef) {
        return this.fAVMService.getStore(storeRef.getIdentifier()) != null;
    }

    public boolean exists(NodeRef nodeRef) {
        String avmPath;
        Pair<Integer, String> avmInfo = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmInfo.getFirst();
        return this.fAVMService.lookup(version, avmPath = (String)avmInfo.getSecond()) != null;
    }

    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        return new NodeRef.Status(null, nodeRef, "Unknown", null, !this.exists(nodeRef));
    }

    public NodeRef getNodeRef(Long nodeId) {
        throw new UnsupportedOperationException();
    }

    public NodeRef getRootNode(StoreRef storeRef) throws InvalidStoreRefException {
        String storeName = storeRef.getIdentifier();
        if (this.fAVMService.getStore(storeName) != null) {
            return AVMNodeConverter.ToNodeRef(-1, storeName + ":/");
        }
        throw new InvalidStoreRefException(storeName + ":/" + " not found.", storeRef);
    }

    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        return Collections.singleton(this.getRootNode(storeRef));
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) throws InvalidNodeRefException, InvalidTypeException {
        return this.createNode(parentRef, assocTypeQName, assocQName, nodeTypeQName, new HashMap<QName, Serializable>());
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) throws InvalidNodeRefException, InvalidTypeException {
        if (!assocTypeQName.equals((Object)ContentModel.ASSOC_CONTAINS)) {
            throw new InvalidTypeException(assocTypeQName);
        }
        String nodeName = assocQName.getLocalName();
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(parentRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read only store.", parentRef);
        }
        String avmPath = (String)avmVersionPath.getSecond();
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(nodeTypeQName);
        try {
            Pair<Integer, String> indVersionPath;
            NodeRef indirection;
            if (nodeTypeQName.equals((Object)WCMModel.TYPE_AVM_PLAIN_FOLDER) || nodeTypeQName.equals((Object)ContentModel.TYPE_FOLDER)) {
                this.fAVMService.createDirectory(avmPath, nodeName);
            } else if (nodeTypeQName.equals((Object)WCMModel.TYPE_AVM_PLAIN_CONTENT) || nodeTypeQName.equals((Object)ContentModel.TYPE_CONTENT)) {
                OutputStream os = this.fAVMService.createFile(avmPath, nodeName);
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to close output stream when creating file '" + AVMUtil.extendAVMPath(avmPath, nodeName) + "'" + ioe.getMessage()));
                }
            } else if (nodeTypeQName.equals((Object)WCMModel.TYPE_AVM_LAYERED_CONTENT)) {
                indirection = (NodeRef)properties.get(WCMModel.PROP_AVM_FILE_INDIRECTION);
                if (indirection == null) {
                    throw new InvalidTypeException("No Indirection Property", nodeTypeQName);
                }
                indVersionPath = AVMNodeConverter.ToAVMVersionPath(indirection);
                this.fAVMService.createLayeredFile((String)indVersionPath.getSecond(), avmPath, nodeName);
            } else if (nodeTypeQName.equals((Object)WCMModel.TYPE_AVM_LAYERED_FOLDER)) {
                indirection = (NodeRef)properties.get(WCMModel.PROP_AVM_DIR_INDIRECTION);
                if (indirection == null) {
                    throw new InvalidTypeException("No Indirection Property.", nodeTypeQName);
                }
                indVersionPath = AVMNodeConverter.ToAVMVersionPath(indirection);
                this.fAVMService.createLayeredDirectory((String)indVersionPath.getSecond(), avmPath, nodeName);
            } else {
                throw new InvalidTypeException("Invalid node type for AVM.", nodeTypeQName);
            }
            properties.putAll(this.getDefaultProperties((ClassDefinition)nodeTypeDef));
            this.addDefaultAspects((ClassDefinition)nodeTypeDef, avmPath, properties);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException(avmPath + " not found.", parentRef);
        }
        catch (AVMExistsException e) {
            throw new InvalidNodeRefException("Child " + nodeName + " exists", parentRef);
        }
        String newAVMPath = AVMNodeConverter.ExtendAVMPath(avmPath, nodeName);
        NodeRef childRef = AVMNodeConverter.ToNodeRef(-1, newAVMPath);
        properties.putAll(this.getDefaultProperties((ClassDefinition)nodeTypeDef));
        this.addDefaultAspects((ClassDefinition)nodeTypeDef, newAVMPath, properties);
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>();
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            QName propertyQName = entry.getKey();
            if (this.isBuiltInProperty(propertyQName)) continue;
            Serializable value = entry.getValue();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
            props.put(propertyQName, propertyValue);
        }
        this.fAVMService.setNodeProperties(newAVMPath, props);
        ChildAssociationRef ref = new ChildAssociationRef(assocTypeQName, parentRef, assocQName, childRef, true, -1);
        return ref;
    }

    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) throws InvalidNodeRefException {
        if (!assocTypeQName.equals((Object)ContentModel.ASSOC_CONTAINS)) {
            throw new InvalidTypeException(assocTypeQName);
        }
        Pair<Integer, String> src = AVMNodeConverter.ToAVMVersionPath(nodeToMoveRef);
        int srcVersion = (Integer)src.getFirst();
        if (srcVersion >= 0) {
            throw new InvalidNodeRefException("Read Only Store.", nodeToMoveRef);
        }
        String srcPath = (String)src.getSecond();
        String[] splitSrc = null;
        try {
            splitSrc = AVMNodeConverter.SplitBase(srcPath);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException("Invalid src path.", nodeToMoveRef);
        }
        String srcParent = splitSrc[0];
        if (srcParent == null) {
            throw new InvalidNodeRefException("Cannot rename root node.", nodeToMoveRef);
        }
        String srcName = splitSrc[1];
        Pair<Integer, String> dst = AVMNodeConverter.ToAVMVersionPath(newParentRef);
        if ((Integer)dst.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read Only Store.", newParentRef);
        }
        String dstParent = (String)dst.getSecond();
        String dstName = assocQName.getLocalName();
        NodeRef oldParentRef = AVMNodeConverter.ToNodeRef(-1, srcParent);
        ChildAssociationRef oldAssocRef = new ChildAssociationRef(assocTypeQName, oldParentRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)srcName), nodeToMoveRef, true, -1);
        String dstPath = AVMNodeConverter.ExtendAVMPath(dstParent, dstName);
        NodeRef newChildRef = AVMNodeConverter.ToNodeRef(-1, dstPath);
        try {
            this.fAVMService.rename(srcParent, srcName, dstParent, dstName);
            ChildAssociationRef newAssocRef = new ChildAssociationRef(assocTypeQName, newParentRef, assocQName, newChildRef, true, -1);
            this.invokeOnMoveNode(oldAssocRef, newAssocRef);
            return newAssocRef;
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException("Non existent node.", nodeToMoveRef);
        }
        catch (AVMExistsException e) {
            throw new InvalidNodeRefException("Target already exists.", newParentRef);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException("Illegal move.", nodeToMoveRef);
        }
    }

    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) throws InvalidChildAssociationRefException {
    }

    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        AVMNodeDescriptor desc = this.fAVMService.lookup((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
        if (desc == null) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
        if (desc.isPlainDirectory()) {
            return WCMModel.TYPE_AVM_PLAIN_FOLDER;
        }
        if (desc.isPlainFile()) {
            return WCMModel.TYPE_AVM_PLAIN_CONTENT;
        }
        if (desc.isLayeredDirectory()) {
            return WCMModel.TYPE_AVM_LAYERED_FOLDER;
        }
        return WCMModel.TYPE_AVM_LAYERED_CONTENT;
    }

    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException("AVM Types are immutable.");
    }

    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new InvalidAspectException("The aspect is invalid: " + aspectTypeQName, aspectTypeQName);
        }
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only node.", nodeRef);
        }
        String avmPath = (String)avmVersionPath.getSecond();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        if (aspectProperties != null) {
            properties.putAll(aspectProperties);
        }
        Map<QName, Serializable> defaultProperties = this.getDefaultProperties((ClassDefinition)aspectDef);
        properties.putAll(defaultProperties);
        this.addDefaultAspects((ClassDefinition)aspectDef, avmPath, properties);
        if (properties.size() != 0) {
            HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>();
            for (Map.Entry entry : properties.entrySet()) {
                QName propertyQName = (QName)entry.getKey();
                if (this.isBuiltInProperty(propertyQName)) continue;
                Serializable value = (Serializable)entry.getValue();
                PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
                PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
                props.put(propertyQName, propertyValue);
            }
            if (props.size() != 0) {
                this.fAVMService.setNodeProperties(avmPath, props);
            }
        }
        if (this.isBuiltinAspect(aspectTypeQName)) {
            return;
        }
        try {
            this.fAVMService.addAspect(avmPath, aspectTypeQName);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    private void addDefaultAspects(ClassDefinition classDef, String path, Map<QName, Serializable> properties) {
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
        List defaultAspectDefs = classDef.getDefaultAspects();
        for (AspectDefinition def : defaultAspectDefs) {
            this.addAspect(nodeRef, def.getName(), Collections.emptyMap());
            properties.putAll(this.getDefaultProperties((ClassDefinition)def));
            this.addDefaultAspects((ClassDefinition)def, path, properties);
        }
    }

    public void removeAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        AspectDefinition def = this.dictionaryService.getAspect(aspectTypeQName);
        if (def == null) {
            throw new InvalidAspectException(aspectTypeQName);
        }
        if (this.isBuiltinAspect(aspectTypeQName)) {
            return;
        }
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", nodeRef);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            if (this.fAVMService.hasAspect(-1, path, aspectTypeQName)) {
                this.fAVMService.removeAspect(path, aspectTypeQName);
                Map propDefs = def.getProperties();
                for (QName propertyName : propDefs.keySet()) {
                    this.fAVMService.deleteNodeProperty(path, propertyName);
                }
            }
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    public boolean hasAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        if (this.isBuiltinAspect(aspectTypeQName)) {
            return true;
        }
        return this.fAVMService.hasAspect(version, path, aspectTypeQName);
    }

    private boolean isBuiltinAspect(QName aspectQName) {
        for (QName builtin : fgBuiltinAspects) {
            if (!builtin.equals((Object)aspectQName)) continue;
            return true;
        }
        return false;
    }

    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        HashSet<QName> result = new HashSet<QName>();
        for (QName name : fgBuiltinAspects) {
            result.add(name);
        }
        try {
            for (QName name : this.fAVMService.getAspects(version, path)) {
                result.add(name);
            }
            return result;
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    public void deleteNode(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        if ((Integer)avmVersionPath.getFirst() != -1) {
            throw new InvalidNodeRefException("Read only store.", nodeRef);
        }
        String[] avmPathBase = AVMNodeConverter.SplitBase((String)avmVersionPath.getSecond());
        if (avmPathBase[0] == null) {
            throw new InvalidNodeRefException("Cannot delete root node.", nodeRef);
        }
        try {
            this.fAVMService.removeNode(avmPathBase[0], avmPathBase[1]);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
    }

    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        return this.addChild(Collections.singletonList(parentRef), childRef, assocTypeQName, qname).get(0);
    }

    public List<ChildAssociationRef> addChild(Collection<NodeRef> parentRefs, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        Pair<Integer, String> childVersionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
        AVMNodeDescriptor child = this.fAVMService.lookup((Integer)childVersionPath.getFirst(), (String)childVersionPath.getSecond());
        if (child == null) {
            throw new InvalidNodeRefException((String)childVersionPath.getSecond() + " not found.", childRef);
        }
        ArrayList<ChildAssociationRef> childAssociationRefs = new ArrayList<ChildAssociationRef>(parentRefs.size());
        for (NodeRef parentRef : parentRefs) {
            Pair<Integer, String> parentVersionPath = AVMNodeConverter.ToAVMVersionPath(parentRef);
            if ((Integer)parentVersionPath.getFirst() >= 0) {
                throw new InvalidNodeRefException("Read Only.", parentRef);
            }
            try {
                this.fAVMService.link((String)parentVersionPath.getSecond(), qname.getLocalName(), child);
                ChildAssociationRef newChild = new ChildAssociationRef(assocTypeQName, parentRef, qname, AVMNodeConverter.ToNodeRef(-1, AVMNodeConverter.ExtendAVMPath((String)parentVersionPath.getSecond(), qname.getLocalName())));
                childAssociationRefs.add(newChild);
            }
            catch (AVMException e) {
                throw new InvalidNodeRefException("Could not link.", childRef);
            }
        }
        return childAssociationRefs;
    }

    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        Pair<Integer, String> parentVersionPath = AVMNodeConverter.ToAVMVersionPath(parentRef);
        if ((Integer)parentVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", parentRef);
        }
        Pair<Integer, String> childVersionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
        if ((Integer)childVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", childRef);
        }
        String parentPath = (String)parentVersionPath.getSecond();
        String childPath = (String)childVersionPath.getSecond();
        String[] childPathBase = AVMNodeConverter.SplitBase(childPath);
        if (childPathBase[0] == null || !childPathBase[0].equals(parentPath)) {
            throw new InvalidNodeRefException(childPath + " not a child of " + parentPath, childRef);
        }
        try {
            this.fAVMService.removeNode(childPathBase[0], childPathBase[1]);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException(childPathBase[1] + " not found in " + childPathBase[0], childRef);
        }
    }

    public boolean removeChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentRef = childAssocRef.getParentRef();
        NodeRef childRef = childAssocRef.getChildRef();
        Pair<Integer, String> parentVersionPath = AVMNodeConverter.ToAVMVersionPath(parentRef);
        if ((Integer)parentVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", parentRef);
        }
        Pair<Integer, String> childVersionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
        if ((Integer)childVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", childRef);
        }
        String parentPath = (String)parentVersionPath.getSecond();
        String childPath = (String)childVersionPath.getSecond();
        String[] childPathBase = AVMNodeConverter.SplitBase(childPath);
        if (childPathBase[0] == null || !childPathBase[0].equals(parentPath)) {
            return false;
        }
        try {
            this.fAVMService.removeNode(childPathBase[0], childPathBase[1]);
            return true;
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException("Not found.", childRef);
        }
    }

    public boolean removeSecondaryChildAssociation(ChildAssociationRef childAssocRef) {
        throw new UnsupportedOperationException();
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        Map<QName, PropertyValue> props = null;
        AVMNodeDescriptor desc = this.fAVMService.lookup((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
        try {
            props = this.fAVMService.getNodeProperties((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        for (QName qName : props.keySet()) {
            PropertyValue value = props.get(qName);
            PropertyDefinition def = this.dictionaryService.getProperty(qName);
            result.put(qName, this.makeSerializableValue(def, value));
        }
        result.put(ContentModel.PROP_CREATED, new Date(desc.getCreateDate()));
        result.put(ContentModel.PROP_CREATOR, (Serializable)((Object)desc.getCreator()));
        result.put(ContentModel.PROP_MODIFIED, new Date(desc.getModDate()));
        result.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)desc.getLastModifier()));
        result.put(ContentModel.PROP_OWNER, (Serializable)((Object)desc.getOwner()));
        result.put(ContentModel.PROP_NAME, (Serializable)((Object)desc.getName()));
        result.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)"UNKNOWN"));
        result.put(ContentModel.PROP_NODE_DBID, new Long(desc.getId()));
        result.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)"avm"));
        result.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        if (desc.isLayeredDirectory()) {
            result.put(WCMModel.PROP_AVM_DIR_INDIRECTION, (Serializable)AVMNodeConverter.ToNodeRef(-1, desc.getIndirection()));
        }
        if (desc.isLayeredFile()) {
            result.put(WCMModel.PROP_AVM_FILE_INDIRECTION, (Serializable)AVMNodeConverter.ToNodeRef(-1, desc.getIndirection()));
        }
        if (desc.isFile()) {
            try {
                ContentData contentData = this.fAVMService.getContentDataForRead((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
                result.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
            }
            catch (AVMException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        if (this.isBuiltInProperty(qname)) {
            return this.getBuiltInProperty(avmVersionPath, qname, nodeRef);
        }
        try {
            PropertyValue value = this.fAVMService.getNodeProperty((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond(), qname);
            if (value == null) {
                return null;
            }
            PropertyDefinition def = this.dictionaryService.getProperty(qname);
            return this.makeSerializableValue(def, value);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
    }

    public void removeProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        if (this.isBuiltInProperty(qname)) {
            return;
        }
        try {
            this.fAVMService.deleteNodeProperty((String)avmVersionPath.getSecond(), qname);
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
    }

    private Serializable getBuiltInProperty(Pair<Integer, String> avmVersionPath, QName qName, NodeRef nodeRef) {
        if (qName.equals((Object)ContentModel.PROP_CONTENT)) {
            try {
                ContentData contentData = this.fAVMService.getContentDataForRead((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
                return contentData;
            }
            catch (AVMException e) {
                return null;
            }
        }
        AVMNodeDescriptor desc = this.fAVMService.lookup((Integer)avmVersionPath.getFirst(), (String)avmVersionPath.getSecond());
        if (desc == null) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
        if (qName.equals((Object)ContentModel.PROP_CREATED)) {
            return new Date(desc.getCreateDate());
        }
        if (qName.equals((Object)ContentModel.PROP_CREATOR)) {
            return desc.getCreator();
        }
        if (qName.equals((Object)ContentModel.PROP_MODIFIED)) {
            return new Date(desc.getModDate());
        }
        if (qName.equals((Object)ContentModel.PROP_MODIFIER)) {
            return desc.getLastModifier();
        }
        if (qName.equals((Object)ContentModel.PROP_OWNER)) {
            return desc.getOwner();
        }
        if (qName.equals((Object)ContentModel.PROP_NAME)) {
            return desc.getName();
        }
        if (qName.equals((Object)ContentModel.PROP_NODE_UUID)) {
            return "UNKNOWN";
        }
        if (qName.equals((Object)ContentModel.PROP_NODE_DBID)) {
            return new Long(desc.getId());
        }
        if (qName.equals((Object)ContentModel.PROP_STORE_PROTOCOL)) {
            return "avm";
        }
        if (qName.equals((Object)ContentModel.PROP_STORE_IDENTIFIER)) {
            return nodeRef.getStoreRef().getIdentifier();
        }
        if (qName.equals((Object)WCMModel.PROP_AVM_DIR_INDIRECTION)) {
            if (desc.isLayeredDirectory()) {
                return AVMNodeConverter.ToNodeRef(-1, desc.getIndirection());
            }
            return null;
        }
        if (qName.equals((Object)WCMModel.PROP_AVM_FILE_INDIRECTION)) {
            if (desc.isLayeredFile()) {
                return AVMNodeConverter.ToNodeRef(-1, desc.getIndirection());
            }
            return null;
        }
        logger.error((Object)("Invalid Built In Property: " + qName));
        return null;
    }

    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        if ((Integer)avmVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", nodeRef);
        }
        try {
            Map<QName, Serializable> propsBefore = null;
            if (this.fInvokePolicies) {
                propsBefore = this.getProperties(nodeRef);
            }
            this.fAVMService.deleteNodeProperties((String)avmVersionPath.getSecond());
            HashMap<QName, PropertyValue> values = new HashMap<QName, PropertyValue>();
            for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
                QName propertyQName = entry.getKey();
                Serializable value = entry.getValue();
                if (this.isBuiltInProperty(propertyQName) && propertyQName.equals((Object)ContentModel.PROP_CONTENT)) {
                    AVMNodeDescriptor desc = this.fAVMService.lookup(-1, (String)avmVersionPath.getSecond());
                    if (desc == null) {
                        throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
                    }
                    if (desc.isPlainFile()) {
                        this.fAVMService.setContentData((String)avmVersionPath.getSecond(), (ContentData)properties.get(propertyQName));
                    }
                }
                PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
                PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
                values.put(propertyQName, propertyValue);
            }
            this.fAVMService.setNodeProperties((String)avmVersionPath.getSecond(), values);
            if (this.fInvokePolicies) {
                Map<QName, Serializable> propsAfter = properties;
                this.invokeOnUpdateProperties(nodeRef, propsBefore, propsAfter);
            }
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
    }

    public void addProperties(NodeRef nodeRef, Map<QName, Serializable> properties) {
        Map<QName, Serializable> currentProperties = this.getProperties(nodeRef);
        currentProperties.putAll(properties);
        this.setProperties(nodeRef, currentProperties);
    }

    private boolean isBuiltInProperty(QName qName) {
        for (QName name : fgBuiltinProperties) {
            if (!name.equals((Object)qName)) continue;
            return true;
        }
        return false;
    }

    public void setProperty(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        if ((Integer)avmVersionPath.getFirst() >= 0) {
            throw new InvalidNodeRefException("Read only store.", nodeRef);
        }
        Map<QName, Serializable> propsBefore = null;
        if (this.fInvokePolicies) {
            propsBefore = this.getProperties(nodeRef);
        }
        if (this.isBuiltInProperty(qname)) {
            if (qname.equals((Object)ContentModel.PROP_CONTENT)) {
                try {
                    this.fAVMService.setContentData((String)avmVersionPath.getSecond(), (ContentData)value);
                    if (this.fInvokePolicies) {
                        HashMap<QName, Serializable> propsAfter = new HashMap<QName, Serializable>(propsBefore);
                        propsAfter.put(ContentModel.PROP_CONTENT, value);
                        this.invokeOnUpdateProperties(nodeRef, propsBefore, propsAfter);
                    }
                }
                catch (ClassCastException e) {
                    throw new AVMException("Invalid ContentData.", e);
                }
            }
            return;
        }
        try {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
            PropertyValue propertyValue = this.makePropertyValue(propertyDef, value);
            this.fAVMService.setNodeProperty((String)avmVersionPath.getSecond(), qname, propertyValue);
            if (this.fInvokePolicies) {
                HashMap<QName, Serializable> propsAfter = new HashMap<QName, Serializable>(propsBefore);
                propsAfter.put(qname, value);
                this.invokeOnUpdateProperties(nodeRef, propsBefore, propsAfter);
            }
        }
        catch (AVMNotFoundException e) {
            throw new InvalidNodeRefException((String)avmVersionPath.getSecond() + " not found.", nodeRef);
        }
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        String path = (String)avmVersionPath.getSecond();
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        String[] splitPath = AVMNodeConverter.SplitBase(path);
        if (splitPath[0] == null) {
            return result;
        }
        result.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, AVMNodeConverter.ToNodeRef((Integer)avmVersionPath.getFirst(), splitPath[0]), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)splitPath[1]), nodeRef, true, -1));
        return result;
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) throws InvalidNodeRefException {
        if (!typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
            return new ArrayList<ChildAssociationRef>();
        }
        List<ChildAssociationRef> result = this.getParentAssocs(nodeRef);
        if (result.size() == 0) {
            return result;
        }
        if (qnamePattern.isMatch(result.get(0).getQName())) {
            return result;
        }
        return new ArrayList<ChildAssociationRef>();
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        SortedMap<String, AVMNodeDescriptor> children = null;
        try {
            children = this.fAVMService.getDirectoryListing(version, path);
        }
        catch (AVMNotFoundException e) {
            return result;
        }
        for (String name : children.keySet()) {
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), AVMNodeConverter.ToNodeRef(version, AVMNodeConverter.ExtendAVMPath(path, name)), true, -1));
        }
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) throws InvalidNodeRefException {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        if (!typeQNamePattern.isMatch(ContentModel.ASSOC_CONTAINS)) {
            return result;
        }
        if (qnamePattern == null || !(qnamePattern instanceof QName)) {
            List<ChildAssociationRef> all = this.getChildAssocs(nodeRef);
            for (ChildAssociationRef child : all) {
                if (qnamePattern == null || !qnamePattern.isMatch(child.getQName())) continue;
                result.add(child);
            }
            return result;
        }
        QName qname = (QName)qnamePattern;
        String name = qname.getLocalName();
        Pair<Integer, String> containerVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int containerVersion = (Integer)containerVersionPath.getFirst();
        String containerPath = (String)containerVersionPath.getSecond();
        try {
            AVMNodeDescriptor containerDescriptor = this.fAVMService.lookup(containerVersion, containerPath);
            AVMNodeDescriptor childDescriptor = this.fAVMService.lookup(containerDescriptor, name);
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), AVMNodeConverter.ToNodeRef(containerVersion, AVMNodeConverter.ExtendAVMPath(containerPath, name)), true, -1));
        }
        catch (AVMNotFoundException e) {
            return result;
        }
        catch (AVMWrongTypeException e) {
            return result;
        }
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQName, QNamePattern qname, int maxResults, boolean preload) throws InvalidNodeRefException {
        List<ChildAssociationRef> result = this.getChildAssocs(nodeRef, typeQName, qname);
        if (result.size() > maxResults) {
            return result.subList(0, maxResults);
        }
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, boolean preload) throws InvalidNodeRefException {
        return this.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, Set<QName> childNodeTypes) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        SortedMap<String, AVMNodeDescriptor> children = null;
        try {
            children = this.fAVMService.getDirectoryListing(version, path);
        }
        catch (AVMNotFoundException e) {
            return result;
        }
        for (Map.Entry<String, AVMNodeDescriptor> entry : children.entrySet()) {
            String name = entry.getKey();
            AVMNodeDescriptor descriptor = entry.getValue();
            if (descriptor.isFile() ? !childNodeTypes.contains(ContentModel.TYPE_CONTENT) : !descriptor.isDirectory() || !childNodeTypes.contains(ContentModel.TYPE_FOLDER)) continue;
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), AVMNodeConverter.ToNodeRef(version, AVMNodeConverter.ExtendAVMPath(path, name)), true, -1));
        }
        return result;
    }

    public List<ChildAssociationRef> getChildrenByName(NodeRef nodeRef, QName assocTypeQName, Collection<String> childNames) {
        ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        if (!assocTypeQName.equals((Object)ContentModel.ASSOC_CONTAINS)) {
            throw new UnsupportedOperationException("AVM getChildrenByName only supports ASSOCS_CONTAINS.");
        }
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        try {
            for (String childName : childNames) {
                AVMNodeDescriptor child = this.fAVMService.lookup((Integer)avmVersionPath.getFirst(), AVMUtil.extendAVMPath((String)avmVersionPath.getSecond(), childName));
                if (child == null) continue;
                NodeRef childRef = AVMNodeConverter.ToNodeRef((Integer)avmVersionPath.getFirst(), child.getPath());
                QName childQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)childName);
                ChildAssociationRef ref = new ChildAssociationRef(assocTypeQName, nodeRef, childQName, childRef);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("got a child node :" + ref));
                }
                results.add(ref);
            }
            return results;
        }
        catch (AVMException e) {
            logger.debug((Object)"exception in getChildrenByName ", (Throwable)((Object)e));
            return results;
        }
    }

    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        if (!assocTypeQName.equals((Object)ContentModel.ASSOC_CONTAINS)) {
            return null;
        }
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        try {
            AVMNodeDescriptor child = this.fAVMService.lookup((Integer)avmVersionPath.getFirst(), AVMUtil.extendAVMPath((String)avmVersionPath.getSecond(), childName));
            if (child == null) {
                return null;
            }
            return AVMNodeConverter.ToNodeRef((Integer)avmVersionPath.getFirst(), child.getPath());
        }
        catch (AVMException e) {
            return null;
        }
    }

    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        List<ChildAssociationRef> parents = this.getParentAssocs(nodeRef);
        if (parents.size() == 0) {
            return new ChildAssociationRef(null, null, null, nodeRef);
        }
        return parents.get(0);
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        throw new UnsupportedOperationException("AVM does not support arbitrary associations.");
    }

    public void setAssociations(NodeRef sourceRef, QName assocTypeQName, List<NodeRef> targetRefs) {
        throw new UnsupportedOperationException("AVM does not support arbitrary associations.");
    }

    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException("AVM does not support arbitrary associations.");
    }

    public AssociationRef getAssoc(Long id) {
        return null;
    }

    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) throws InvalidNodeRefException {
        return new ArrayList<AssociationRef>();
    }

    public List<AssociationRef> getSourceAssocs(NodeRef targetRef, QNamePattern qnamePattern) throws InvalidNodeRefException {
        return new ArrayList<AssociationRef>();
    }

    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        Path path = new Path();
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String currPath = (String)avmVersionPath.getSecond();
        while (!currPath.endsWith("/")) {
            String[] splitPath = AVMNodeConverter.SplitBase(currPath);
            String parentPath = splitPath[0];
            String name = splitPath[1];
            ChildAssociationRef caRef = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, AVMNodeConverter.ToNodeRef(version, parentPath), QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), AVMNodeConverter.ToNodeRef(version, currPath), true, -1);
            path.prepend((Path.Element)new Path.ChildAssocElement(caRef));
            currPath = parentPath;
        }
        ChildAssociationRef caRef = new ChildAssociationRef(null, null, null, AVMNodeConverter.ToNodeRef(version, currPath));
        path.prepend((Path.Element)new Path.ChildAssocElement(caRef));
        return path;
    }

    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> result = new ArrayList<Path>();
        result.add(this.getPath(nodeRef));
        return result;
    }

    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        throw new UnsupportedOperationException("AVM does not support this operation.");
    }

    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        throw new UnsupportedOperationException("AVM does not support this operation.");
    }

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef parent, QName assocTypeQName) {
        throw new UnsupportedOperationException("AVM does not support this operation.");
    }

    public Long getNodeAclId(NodeRef nodeRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException("getNodeAclId is unsupported for AVMNodeService");
    }

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef nodeRef, QName propertyQName, Serializable value) {
        throw new UnsupportedOperationException("AVM does not support this operation.");
    }

    public int countChildAssocs(NodeRef nodeRef, boolean isPrimary) throws InvalidNodeRefException {
        throw new UnsupportedOperationException("AVM does not support this operation.");
    }
}

