/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.avm.AVMMergeLinkEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrphanReaper {
    private Log fgLogger = LogFactory.getLog(OrphanReaper.class);
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"OrphanReaper");
    private JobLockService jobLockService;
    private TransactionService fTransactionService;
    private long lockRefreshTime = 60000L;
    private long lockTimeOut = 3600000L;
    private long fActiveBaseSleep = 1000L;
    private int fBatchSize = 50;
    private AtomicBoolean fActive = new AtomicBoolean(false);
    private AtomicBoolean fDone = new AtomicBoolean(false);
    private AtomicBoolean fRunning = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        OrphanReaper orphanReaper = this;
        synchronized (orphanReaper) {
            if (this.fRunning.get()) {
                if (this.fgLogger.isDebugEnabled()) {
                    this.fgLogger.debug((Object)"OrphanReaper is already running - just return");
                }
                return;
            }
            this.fRunning.set(true);
            if (this.fgLogger.isTraceEnabled()) {
                this.fgLogger.trace((Object)"Start running OrphanReaper ...");
            }
        }
        try {
            do {
                this.doBatch();
                if (this.fDone.get()) {
                    if (this.fgLogger.isTraceEnabled()) {
                        this.fgLogger.trace((Object)"OrphanReaper is done - just return");
                    }
                    return;
                }
                try {
                    if (this.fgLogger.isTraceEnabled()) {
                        this.fgLogger.trace((Object)("OrphanReaper is not done - sleep for " + this.fActiveBaseSleep + " ms"));
                    }
                    Thread.sleep(this.fActiveBaseSleep);
                }
                catch (InterruptedException e) {
                    this.fgLogger.warn((Object)("OrphanReaper was interrupted - do nothing: " + e));
                }
            } while (this.fActive.get());
        }
        finally {
            orphanReaper = this;
            synchronized (orphanReaper) {
                this.fRunning.set(false);
                if (this.fgLogger.isTraceEnabled()) {
                    this.fgLogger.trace((Object)"... finish running OrphanReaper");
                }
            }
        }
    }

    public void setActiveBaseSleep(long interval) {
        this.fActiveBaseSleep = interval;
    }

    public void setBatchSize(int size) {
        this.fBatchSize = size;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.fTransactionService = transactionService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setLockRefreshTime(long lockRefreshTime) {
        this.lockRefreshTime = lockRefreshTime;
    }

    public long getLockRefreshTime() {
        return this.lockRefreshTime;
    }

    public long getTimeToLive() {
        return this.getLockRefreshTime() * 2L;
    }

    public void setLockTimeOut(long lockTimeOut) {
        this.lockTimeOut = lockTimeOut;
    }

    public long getLockTimeOut() {
        return this.lockTimeOut;
    }

    public void shutDown() {
        this.fDone.set(true);
    }

    private String getLock() {
        try {
            return this.jobLockService.getLock(LOCK, this.getTimeToLive());
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    private void createLockRefreshCallback(String lockToken, final AtomicBoolean lockHeld, final long start) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            @Override
            public boolean isActive() {
                boolean active = lockHeld.get();
                if (active && System.currentTimeMillis() >= start + OrphanReaper.this.getLockTimeOut()) {
                    active = false;
                    lockHeld.set(false);
                    OrphanReaper.this.fgLogger.error((Object)"Lock held too long. Do we have a deadlock? Restart process.");
                }
                return active;
            }

            @Override
            public void lockReleased() {
                lockHeld.set(false);
            }
        };
        this.jobLockService.refreshLock(lockToken, LOCK, this.getTimeToLive(), callback);
    }

    public void activate() {
        this.fActive.set(true);
    }

    public boolean isActive() {
        return this.fActive.get();
    }

    public void doBatch() {
        try {
            if (!this.fTransactionService.isReadOnly()) {
                class TxnWork
                implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                    TxnWork() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object execute() throws Exception {
                        long start = System.currentTimeMillis();
                        int reapCnt = 0;
                        String lockToken = OrphanReaper.this.getLock();
                        if (lockToken == null) {
                            OrphanReaper.this.fgLogger.info((Object)"Can't get lock. Assume multiple reapers ...");
                            OrphanReaper.this.fActive.set(false);
                            return null;
                        }
                        AtomicBoolean lockHeld = new AtomicBoolean(true);
                        try {
                            List<AVMNode> nodes;
                            OrphanReaper.this.createLockRefreshCallback(lockToken, lockHeld, start);
                            if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                OrphanReaper.this.fgLogger.trace((Object)("Orphan reaper doBatch: batchSize=" + OrphanReaper.this.fBatchSize + ", fActiveBaseSleep=" + OrphanReaper.this.fActiveBaseSleep));
                            }
                            if ((nodes = AVMDAOs.Instance().fAVMNodeDAO.getOrphans(OrphanReaper.this.fBatchSize)).size() == 0) {
                                if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                    OrphanReaper.this.fgLogger.trace((Object)"Nothing to purge (set fActive = false)");
                                }
                                OrphanReaper.this.fActive.set(false);
                                Object var7_6 = null;
                                return var7_6;
                            }
                            if (!lockHeld.get()) {
                                throw new LockAcquisitionException("Lock lost. Finding orphans to reap.", new Object[0]);
                            }
                            LinkedList<Long> fPurgeQueue = new LinkedList<Long>();
                            for (AVMNode node : nodes) {
                                fPurgeQueue.add(node.getId());
                            }
                            if (OrphanReaper.this.fgLogger.isDebugEnabled()) {
                                OrphanReaper.this.fgLogger.debug((Object)("Queue was empty so got more orphans from DB. Orphan queue size = " + fPurgeQueue.size()));
                            }
                            OrphanReaper.this.fActive.set(true);
                            for (int i = 0; i < OrphanReaper.this.fBatchSize; ++i) {
                                if (fPurgeQueue.size() == 0) {
                                    if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                        OrphanReaper.this.fgLogger.trace((Object)("Purge queue is empty (fpurgeQueue size = " + fPurgeQueue.size() + ")"));
                                    }
                                    fPurgeQueue = null;
                                    break;
                                }
                                if (!lockHeld.get()) {
                                    throw new LockAcquisitionException("Lock lost. Orphan reap loop: " + i, new Object[0]);
                                }
                                Long nodeId = (Long)fPurgeQueue.removeFirst();
                                AVMNode node = AVMDAOs.Instance().fAVMNodeDAO.getByID(nodeId);
                                AVMNode ancestor = null;
                                AVMHistoryLinkEntity hlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinkByDescendent(node.getId());
                                if (hlEntity != null) {
                                    ancestor = AVMDAOs.Instance().fAVMNodeDAO.getByID(hlEntity.getAncestorNodeId());
                                    AVMDAOs.Instance().newAVMNodeLinksDAO.deleteHistoryLink(hlEntity.getAncestorNodeId(), hlEntity.getDescendentNodeId());
                                }
                                AVMNode mergedFrom = null;
                                AVMMergeLinkEntity mlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getMergeLinkByTo(node.getId());
                                if (mlEntity != null) {
                                    mergedFrom = AVMDAOs.Instance().fAVMNodeDAO.getByID(mlEntity.getMergeFromNodeId());
                                    AVMDAOs.Instance().newAVMNodeLinksDAO.deleteMergeLink(mlEntity.getMergeFromNodeId(), mlEntity.getMergeToNodeId());
                                }
                                List<AVMHistoryLinkEntity> hlEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinksByAncestor(node.getId());
                                for (AVMHistoryLinkEntity link : hlEntities) {
                                    AVMNode desc = AVMDAOs.Instance().fAVMNodeDAO.getByID(link.getDescendentNodeId());
                                    if (desc != null) {
                                        desc.setAncestor(ancestor);
                                        if (desc.getMergedFrom() == null) {
                                            desc.setMergedFrom(mergedFrom);
                                        }
                                    }
                                    AVMDAOs.Instance().newAVMNodeLinksDAO.deleteHistoryLink(link.getAncestorNodeId(), link.getDescendentNodeId());
                                }
                                List<AVMMergeLinkEntity> mlEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getMergeLinksByFrom(node.getId());
                                for (AVMMergeLinkEntity link : mlEntities) {
                                    AVMNode mto = AVMDAOs.Instance().fAVMNodeDAO.getByID(link.getMergeToNodeId());
                                    if (mto != null) {
                                        mto.setMergedFrom(ancestor);
                                    }
                                    AVMDAOs.Instance().newAVMNodeLinksDAO.deleteMergeLink(link.getMergeFromNodeId(), link.getMergeToNodeId());
                                }
                                AVMDAOs.Instance().fAVMNodeDAO.deleteProperties(node.getId());
                                AVMDAOs.Instance().fAVMNodeDAO.deleteAspects(node.getId());
                                Acl acl = node.getAcl();
                                node.setAcl(null);
                                if (node.getType() == 2 || node.getType() == 3) {
                                    AVMDAOs.Instance().fChildEntryDAO.deleteByParent(node);
                                } else if (node.getType() == 0) {
                                    Long contentDataId;
                                    PlainFileNode file = (PlainFileNode)node;
                                    if (file.isLegacyContentData()) {
                                        ContentData contentData = file.getContentData();
                                        file.setContentData(contentData);
                                    }
                                    if ((contentDataId = file.getContentDataId()) != null) {
                                        AVMDAOs.Instance().contentDataDAO.deleteContentData(contentDataId);
                                    }
                                }
                                AVMDAOs.Instance().fAVMNodeDAO.delete(node);
                                if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                    OrphanReaper.this.fgLogger.trace((Object)("Deleted Node [" + node.getId() + "]"));
                                }
                                ++reapCnt;
                            }
                            if (!lockHeld.get()) {
                                throw new LockAcquisitionException("Lock lost at the end of processing", new Object[0]);
                            }
                        }
                        finally {
                            lockHeld.set(false);
                            OrphanReaper.this.jobLockService.releaseLock(lockToken, LOCK);
                            if (OrphanReaper.this.fgLogger.isDebugEnabled()) {
                                OrphanReaper.this.fgLogger.debug((Object)("Reaped " + reapCnt + " nodes in " + (System.currentTimeMillis() - start) + " ms"));
                            }
                        }
                        return null;
                    }
                }
                this.fTransactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            }
        }
        catch (Exception e) {
            this.fgLogger.warn((Object)"Garbage collector error. Restarting process", (Throwable)e);
        }
    }
}

