/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import java.util.List;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class AVMSubmitHandler
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 7561005904505181493L;
    private static Log fgLogger = LogFactory.getLog(AVMSubmitHandler.class);
    private AVMSyncService fAVMSyncService;
    private AVMService fAVMService;

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.fAVMSyncService = (AVMSyncService)factory.getBean("AVMSyncService");
        this.fAVMService = (AVMService)factory.getBean("AVMService");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        String avmSource = (String)executionContext.getContextInstance().getVariable("sourcePath");
        String[] storePath = avmSource.split(":");
        if (storePath.length != 2) {
            fgLogger.error((Object)("Malformed path: " + avmSource));
            return;
        }
        String webSiteName = this.fAVMService.getStoreProperty(storePath[0], SandboxConstants.PROP_WEBSITE_NAME).getStringValue();
        String avmDest = webSiteName + ":" + storePath[1];
        List<AVMDifference> diffs = this.fAVMSyncService.compare(-1, avmSource, -1, avmDest, null);
        this.fAVMSyncService.update(diffs, null, true, true, false, false, null, null);
        this.fAVMSyncService.flatten(avmSource, avmDest);
    }
}

