/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.bulkimport.BulkFilesystemImporter;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.MetadataLoader;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.BulkImportStatusImpl;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Triple;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNodeImporter
implements NodeImporter {
    protected static final Log logger = LogFactory.getLog(BulkFilesystemImporter.class);
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected MetadataLoader metadataLoader = null;
    protected BulkImportStatusImpl importStatus;
    protected VersionService versionService;
    protected BehaviourFilter behaviourFilter;

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMetadataLoader(MetadataLoader metadataLoader) {
        this.metadataLoader = metadataLoader;
    }

    public void setImportStatus(BulkImportStatusImpl importStatus) {
        this.importStatus = importStatus;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    protected abstract NodeRef importImportableItemImpl(ImportableItem var1, boolean var2);

    protected abstract void importContentAndMetadata(NodeRef var1, ImportableItem.ContentAndMetadata var2, MetadataLoader.Metadata var3);

    protected final String mapToString(Map<?, ?> map) {
        StringBuffer result = new StringBuffer();
        if (map != null) {
            result.append('[');
            if (map.size() > 0) {
                for (Object key : map.keySet()) {
                    result.append(String.valueOf(key));
                    result.append(" = ");
                    result.append(String.valueOf(map.get(key)));
                    result.append(",\n");
                }
                result.delete(result.length() - 2, result.length());
            }
            result.append(']');
        } else {
            result.append("(null)");
        }
        return result.toString();
    }

    protected final String getImportableItemName(ImportableItem importableItem, MetadataLoader.Metadata metadata) {
        File metadataFile;
        String result = null;
        if (metadata != null) {
            result = (String)((Object)metadata.getProperties().get(ContentModel.PROP_NAME));
        }
        if (result == null && importableItem != null && importableItem.getHeadRevision() != null && (metadataFile = importableItem.getHeadRevision().getMetadataFile()) != null) {
            String metadataFileName = metadataFile.getName();
            result = metadataFileName.substring(0, metadataFileName.length() - (".metadata.".length() + this.metadataLoader.getMetadataFileExtension().length()));
        }
        return result;
    }

    protected final int importImportableItemFile(NodeRef nodeRef, ImportableItem importableItem, MetadataLoader.Metadata metadata) {
        int result = 0;
        if (importableItem.hasVersionEntries()) {
            if (!metadata.getAspects().contains(ContentModel.ASPECT_VERSIONABLE)) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Metadata for file '" + this.getFileName(importableItem.getHeadRevision().getContentFile()) + "' was missing the cm:versionable aspect, yet it has " + importableItem.getVersionEntries().size() + " versions.  Adding cm:versionable."));
                }
                metadata.addAspect(ContentModel.ASPECT_VERSIONABLE);
            }
            result = this.importContentVersions(nodeRef, importableItem);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating head revision of node " + nodeRef.toString()));
        }
        this.importContentAndMetadata(nodeRef, importableItem.getHeadRevision(), metadata);
        return result;
    }

    protected final int importContentVersions(NodeRef nodeRef, ImportableItem importableItem) {
        int result = 0;
        for (ImportableItem.VersionedContentAndMetadata versionEntry : importableItem.getVersionEntries()) {
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
            MetadataLoader.Metadata metadata = this.loadMetadata(versionEntry);
            this.importContentAndMetadata(nodeRef, versionEntry, metadata);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating v" + String.valueOf(versionEntry.getVersion()) + " of node '" + nodeRef.toString() + "' (note: version label in Alfresco will not be the same - it is not currently possible to explicitly force a particular version label)."));
            }
            versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
            this.versionService.createVersion(nodeRef, versionProperties);
            result += metadata.getProperties().size() + 4;
        }
        return result;
    }

    protected final Triple<NodeRef, Boolean, BulkImportStatusImpl.NodeState> createOrFindNode(NodeRef target, ImportableItem importableItem, boolean replaceExisting, MetadataLoader.Metadata metadata) {
        Triple result = null;
        boolean isDirectory = false;
        BulkImportStatusImpl.NodeState nodeState = replaceExisting ? BulkImportStatusImpl.NodeState.REPLACED : BulkImportStatusImpl.NodeState.SKIPPED;
        String nodeName = this.getImportableItemName(importableItem, metadata);
        NodeRef nodeRef = null;
        if (nodeName == null) {
            throw new IllegalStateException("Unable to determine node name for " + String.valueOf(importableItem));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for node with name '" + nodeName + "' within node '" + target.toString() + "'."));
        }
        if ((nodeRef = this.fileFolderService.searchSimple(target, nodeName)) == null) {
            if (importableItem.getHeadRevision().contentFileExists()) {
                isDirectory = ImportableItem.FileType.DIRECTORY.equals((Object)importableItem.getHeadRevision().getContentFileType());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating new node of type '" + metadata.getType().toString() + "' with name '" + nodeName + "' within node '" + target.toString() + "'."));
                    }
                    nodeRef = this.fileFolderService.create(target, nodeName, metadata.getType()).getNodeRef();
                    nodeState = BulkImportStatusImpl.NodeState.CREATED;
                }
                catch (FileExistsException fee) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Node with name '" + nodeName + "' within node '" + target.toString() + "' was created concurrently to the bulk import.  Skipping importing it."), (Throwable)fee);
                    }
                    nodeRef = null;
                    nodeState = BulkImportStatusImpl.NodeState.SKIPPED;
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping creation of new node '" + nodeName + "' within node '" + target.toString() + "' since it doesn't have a content file."));
                }
                nodeRef = null;
                nodeState = BulkImportStatusImpl.NodeState.SKIPPED;
            }
        } else if (replaceExisting) {
            boolean targetNodeIsSpace = this.fileFolderService.getFileInfo(nodeRef).isFolder();
            if (importableItem.getHeadRevision().contentFileExists()) {
                isDirectory = ImportableItem.FileType.DIRECTORY.equals((Object)importableItem.getHeadRevision().getContentFileType());
                if (isDirectory != targetNodeIsSpace) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Skipping replacement of " + (isDirectory ? "Directory " : "File ") + "'" + this.getFileName(importableItem.getHeadRevision().getContentFile()) + "'. " + "The target node in the repository is a " + (targetNodeIsSpace ? "space node" : "content node") + "."));
                    }
                    nodeState = BulkImportStatusImpl.NodeState.SKIPPED;
                }
            } else {
                isDirectory = targetNodeIsSpace;
            }
            if (nodeRef != null) {
                if (metadata.getType() != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Specialising type of node '" + nodeRef.toString() + "' to '" + String.valueOf(metadata.getType()) + "'."));
                    }
                    this.nodeService.setType(nodeRef, metadata.getType());
                }
                nodeState = BulkImportStatusImpl.NodeState.REPLACED;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found content node '" + nodeRef.toString() + "', but replaceExisting=false, so skipping it."));
            }
            nodeState = BulkImportStatusImpl.NodeState.SKIPPED;
        }
        result = new Triple((Object)nodeRef, (Object)isDirectory, (Object)nodeState);
        return result;
    }

    protected String getFileName(File file) {
        return FileUtils.getFileName(file);
    }

    protected final void importImportableItemMetadata(NodeRef nodeRef, File parentFile, MetadataLoader.Metadata metadata) {
        if (metadata.getAspects() != null) {
            for (QName aspect : metadata.getAspects()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attaching aspect '" + aspect.toString() + "' to node '" + nodeRef.toString() + "'."));
                }
                this.nodeService.addAspect(nodeRef, aspect, null);
            }
        }
        if (metadata.getProperties() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding properties to node '" + nodeRef.toString() + "':\n" + this.mapToString(metadata.getProperties())));
            }
            try {
                this.nodeService.addProperties(nodeRef, metadata.getProperties());
            }
            catch (InvalidNodeRefException inre) {
                if (!nodeRef.equals((Object)inre.getNodeRef())) {
                    throw new IllegalStateException("Invalid nodeRef found in metadata for '" + this.getFileName(parentFile) + "'.  " + "Probable cause: an association is being populated via metadata, but the " + "NodeRef for the target of that association ('" + inre.getNodeRef() + "') is invalid.  " + "Please double check your metadata file and try again.", inre);
                }
                throw inre;
            }
        }
    }

    protected final void importImportableItemDirectory(NodeRef nodeRef, ImportableItem importableItem, MetadataLoader.Metadata metadata) {
        if (importableItem.hasVersionEntries()) {
            logger.warn((Object)("Skipping versions for directory '" + this.getFileName(importableItem.getHeadRevision().getContentFile()) + "' - Alfresco does not support versioned spaces."));
        }
        this.importImportableItemMetadata(nodeRef, importableItem.getHeadRevision().getContentFile(), metadata);
    }

    protected final MetadataLoader.Metadata loadMetadata(ImportableItem.ContentAndMetadata contentAndMetadata) {
        MetadataLoader.Metadata result = new MetadataLoader.Metadata();
        if (contentAndMetadata != null && contentAndMetadata.contentFileExists()) {
            Date modified;
            String filename = contentAndMetadata.getContentFile().getName().trim().replaceFirst("\\.v([0-9]+)\\z", "");
            Date created = modified = new Date(contentAndMetadata.getContentFile().lastModified());
            result.setType(ImportableItem.FileType.FILE.equals((Object)contentAndMetadata.getContentFileType()) ? ContentModel.TYPE_CONTENT : ContentModel.TYPE_FOLDER);
            result.addProperty(ContentModel.PROP_NAME, (Serializable)((Object)filename));
            result.addProperty(ContentModel.PROP_TITLE, (Serializable)((Object)filename));
            result.addProperty(ContentModel.PROP_CREATED, created);
            result.addProperty(ContentModel.PROP_MODIFIED, modified);
        }
        if (this.metadataLoader != null) {
            this.metadataLoader.loadMetadata(contentAndMetadata, result);
        }
        return result;
    }

    @Override
    public NodeRef importImportableItem(ImportableItem importableItem, boolean replaceExisting) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Importing " + String.valueOf(importableItem)));
        }
        NodeRef nodeRef = this.importImportableItemImpl(importableItem, replaceExisting);
        importableItem.setNodeRef(nodeRef);
        return nodeRef;
    }

    protected void skipImportableDirectory(ImportableItem importableItem) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Skipping '" + this.getFileName(importableItem.getHeadRevision().getContentFile()) + "' as it already exists in the repository and 'replace existing' is false."));
        }
        this.importStatus.incrementImportableItemsSkipped(importableItem, true);
    }

    protected void skipImportableFile(ImportableItem importableItem) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Skipping '" + this.getFileName(importableItem.getHeadRevision().getContentFile()) + "' as it already exists in the repository and 'replace existing' is false."));
        }
        this.importStatus.incrementImportableItemsSkipped(importableItem, false);
    }
}

