/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.cache.AsynchronouslyRefreshedCache;
import org.alfresco.repo.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.repo.cache.RefreshableCacheEvent;
import org.alfresco.repo.cache.RefreshableCacheListener;
import org.alfresco.repo.cache.RefreshableCacheRefreshEvent;
import org.alfresco.repo.cache.RefreshableCacheRefreshedEvent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractAsynchronouslyRefreshedCache<T>
implements AsynchronouslyRefreshedCache<T>,
RefreshableCacheListener,
Callable<Void>,
BeanNameAware,
InitializingBean,
TransactionListener {
    private static final String RESOURCE_KEY_TXN_DATA = "AbstractAsynchronouslyRefreshedCache.TxnData";
    private static Log logger = LogFactory.getLog(AbstractAsynchronouslyRefreshedCache.class);
    private ThreadPoolExecutor threadPoolExecutor;
    private AsynchronouslyRefreshedCacheRegistry registry;
    private TenantService tenantService;
    private List<RefreshableCacheListener> listeners = new LinkedList<RefreshableCacheListener>();
    private final ReentrantReadWriteLock liveLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock refreshLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock runLock = new ReentrantReadWriteLock();
    private HashMap<String, T> live = new HashMap();
    private LinkedHashSet<Refresh> refreshQueue = new LinkedHashSet();
    private String cacheId;
    private RefreshState refreshState = RefreshState.IDLE;
    private String resourceKeyTxnData;

    @Override
    public void register(RefreshableCacheListener listener) {
        this.listeners.add(listener);
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setRegistry(AsynchronouslyRefreshedCacheRegistry registry) {
        this.registry = registry;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void init() {
        this.registry.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        this.liveLock.readLock().lock();
        try {
            if (this.live.get(tenantId) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"get() from cache");
                }
                T t = this.live.get(tenantId);
                return t;
            }
        }
        finally {
            this.liveLock.readLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get() miss, sechudling and waiting ...");
        }
        Refresh refresh = null;
        this.refreshLock.writeLock().lock();
        try {
            for (Refresh existing : this.refreshQueue) {
                if (!existing.getTenantId().equals(tenantId)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"get() found existing build to wait for  ...");
                }
                refresh = existing;
            }
            if (refresh == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"get() building from scratch");
                }
                refresh = new Refresh(tenantId);
                this.refreshQueue.add(refresh);
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
        this.submit();
        this.waitForBuild(refresh);
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInChangesForThisUncommittedTransaction() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for tenant" + tenantId + " ......"));
        }
        T cache = this.buildCache(tenantId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(".... cache built for tenant" + tenantId));
        }
        this.liveLock.writeLock().lock();
        try {
            this.live.put(tenantId, cache);
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForBuild(Refresh refresh) {
        while (refresh.getState() != RefreshState.DONE) {
            Refresh refresh2 = refresh;
            synchronized (refresh2) {
                try {
                    refresh.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void refresh() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async cache refresh request: " + this.cacheId + " for tenant " + tenantId));
        }
        this.registry.broadcastEvent(new RefreshableCacheRefreshEvent(this.cacheId, tenantId), true);
    }

    @Override
    public void onRefreshableCacheEvent(RefreshableCacheEvent refreshableCacheEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async cache onRefreshableCacheEvent " + refreshableCacheEvent));
        }
        if (!refreshableCacheEvent.getCacheId().equals(this.cacheId)) {
            return;
        }
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Async cache adding" + refreshableCacheEvent.getTenantId() + " to post commit list"));
            }
            TransactionData txData = this.getTransactionData();
            txData.tenantIds.add(refreshableCacheEvent.getTenantId());
        } else {
            LinkedHashSet<String> tenantIds = new LinkedHashSet<String>();
            tenantIds.add(refreshableCacheEvent.getTenantId());
            this.queueRefreshAndSubmit(tenantIds);
        }
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)AlfrescoTransactionSupport.getResource(this.resourceKeyTxnData);
        if (data == null) {
            data = new TransactionData();
            data.tenantIds = new LinkedHashSet();
            AlfrescoTransactionSupport.bindListener(this);
            AlfrescoTransactionSupport.bindResource(this.resourceKeyTxnData, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRefreshAndSubmit(LinkedHashSet<String> tenantIds) {
        if (tenantIds == null || tenantIds.size() == 0) {
            return;
        }
        this.refreshLock.writeLock().lock();
        try {
            for (String tenantId : tenantIds) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Async cache adding refresh to queue for " + tenantId));
                }
                this.refreshQueue.add(new Refresh(tenantId));
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
        this.submit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        this.refreshLock.readLock().lock();
        try {
            for (Refresh refresh : this.refreshQueue) {
                if (!refresh.getTenantId().equals(tenantId)) continue;
                boolean bl = false;
                return bl;
            }
            if (AlfrescoTransactionSupport.getTransactionId() != null) {
                boolean bl = !this.getTransactionData().tenantIds.contains(tenantId);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.refreshLock.readLock().unlock();
        }
    }

    private Refresh getNextRefresh() {
        if (this.runLock.writeLock().isHeldByCurrentThread()) {
            for (Refresh refresh : this.refreshQueue) {
                if (refresh.state != RefreshState.WAITING) continue;
                return refresh;
            }
            return null;
        }
        throw new IllegalStateException("Method should not be called without holding the write lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countWaiting() {
        int count = 0;
        if (this.runLock.writeLock().isHeldByCurrentThread()) {
            this.refreshLock.readLock().lock();
            try {
                for (Refresh refresh : this.refreshQueue) {
                    if (refresh.state != RefreshState.WAITING) continue;
                    ++count;
                }
                int n = count;
                return n;
            }
            finally {
                this.refreshLock.readLock().unlock();
            }
        }
        throw new IllegalStateException("Method should not be called without holding the write lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit() {
        this.runLock.writeLock().lock();
        try {
            if (this.refreshState == RefreshState.IDLE) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"submit() scheduling job");
                }
                this.threadPoolExecutor.submit(this);
                this.refreshState = RefreshState.WAITING;
            }
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        try {
            this.doCall();
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("Cache update failed (" + this.getCacheId() + ")."), (Throwable)e);
            this.runLock.writeLock().lock();
            try {
                this.threadPoolExecutor.submit(this);
                this.refreshState = RefreshState.WAITING;
            }
            finally {
                this.runLock.writeLock().unlock();
            }
            return null;
        }
    }

    private void doCall() throws Exception {
        Refresh refresh = this.setUpRefresh();
        if (refresh == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for tenant" + refresh.getTenantId()));
        }
        try {
            this.doRefresh(refresh);
        }
        catch (Exception e) {
            refresh.setState(RefreshState.WAITING);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(Refresh refresh) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for tenant" + refresh.getTenantId() + " ......"));
        }
        T cache = this.buildCache(refresh.getTenantId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(".... cache built for tenant" + refresh.getTenantId()));
        }
        this.liveLock.writeLock().lock();
        try {
            this.live.put(refresh.getTenantId(), cache);
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache entry updated for tenant" + refresh.getTenantId()));
        }
        this.broadcastEvent(new RefreshableCacheRefreshedEvent(this.cacheId, refresh.tenantId));
        this.runLock.writeLock().lock();
        try {
            this.refreshLock.writeLock().lock();
            try {
                if (this.countWaiting() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Rescheduling ... more work");
                    }
                    this.threadPoolExecutor.submit(this);
                    this.refreshState = RefreshState.WAITING;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Nothing to do .... going idle");
                    }
                    this.refreshState = RefreshState.IDLE;
                }
                refresh.setState(RefreshState.DONE);
                this.refreshQueue.remove(refresh);
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Refresh setUpRefresh() throws Exception {
        Refresh refresh = null;
        this.runLock.writeLock().lock();
        try {
            if (this.refreshState == RefreshState.WAITING) {
                this.refreshLock.writeLock().lock();
                try {
                    refresh = this.getNextRefresh();
                    if (refresh != null) {
                        this.refreshState = RefreshState.RUNNING;
                        refresh.setState(RefreshState.RUNNING);
                        Refresh refresh2 = refresh;
                        return refresh2;
                    }
                    this.refreshState = RefreshState.IDLE;
                    Refresh refresh3 = null;
                    return refresh3;
                }
                finally {
                    this.refreshLock.writeLock().unlock();
                }
            }
            Refresh refresh4 = null;
            return refresh4;
        }
        catch (Exception e) {
            if (refresh != null) {
                refresh.setState(RefreshState.WAITING);
            }
            throw e;
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    public void setBeanName(String name) {
        this.cacheId = name;
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    protected abstract T buildCache(String var1);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"threadPoolExecutor", (Object)this.threadPoolExecutor);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"registry", (Object)this.registry);
        this.registry.register(this);
        this.resourceKeyTxnData = "AbstractAsynchronouslyRefreshedCache.TxnData." + this.cacheId;
    }

    public void broadcastEvent(RefreshableCacheEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying cache listeners for " + this.getCacheId() + " " + event));
        }
        for (RefreshableCacheListener listener : this.listeners) {
            listener.onRefreshableCacheEvent(event);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
        TransactionData txnData = this.getTransactionData();
        this.queueRefreshAndSubmit(txnData.tenantIds);
    }

    @Override
    public void afterRollback() {
    }

    private static class TransactionData {
        LinkedHashSet<String> tenantIds;

        private TransactionData() {
        }
    }

    private static class Refresh {
        private String tenantId;
        private volatile RefreshState state = RefreshState.WAITING;

        Refresh(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public RefreshState getState() {
            return this.state;
        }

        public void setState(RefreshState state) {
            this.state = state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Refresh other = (Refresh)obj;
            if (this.state != other.state) {
                return false;
            }
            return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
        }

        public String toString() {
            return "Refresh [tenantId=" + this.tenantId + ", state=" + (Object)((Object)this.state) + ", hashCode()=" + this.hashCode() + "]";
        }
    }

    private static enum RefreshState {
        IDLE,
        WAITING,
        RUNNING,
        DONE;

    }
}

