/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import org.alfresco.repo.cache.AbstractCacheFactory;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCacheFactory<K extends Serializable, V>
extends AbstractCacheFactory<K, V> {
    private static final Log log = LogFactory.getLog(DefaultCacheFactory.class);

    @Override
    public SimpleCache<K, V> createCache(String cacheName) {
        return this.createLocalCache(cacheName);
    }

    private SimpleCache<K, V> createLocalCache(String cacheName) {
        DefaultSimpleCache cache = new DefaultSimpleCache();
        cache.setCacheName(cacheName);
        int maxItems = this.maxItems(cacheName);
        if (maxItems > 0) {
            cache.setMaxItems(maxItems);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating cache: " + cache));
        }
        return cache;
    }

    private int maxItems(String cacheName) {
        String maxItemsStr = this.getProperty(cacheName, "maxItems", "0");
        Integer maxItems = Integer.parseInt(maxItemsStr);
        return maxItems;
    }
}

