/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import org.alfresco.repo.cache.SimpleCache;
import org.springframework.beans.factory.BeanNameAware;

public final class DefaultSimpleCache<K extends Serializable, V>
implements SimpleCache<K, V>,
BeanNameAware {
    private static final int DEFAULT_CAPACITY = 200000;
    private ConcurrentLinkedHashMap<K, AbstractMap.SimpleImmutableEntry<K, V>> map;
    private String cacheName;

    public DefaultSimpleCache(int maxItems, String cacheName) {
        if (maxItems < 1) {
            throw new IllegalArgumentException("maxItems must be a positive integer, but was " + maxItems);
        }
        this.setBeanName(cacheName);
        this.map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(maxItems).concurrencyLevel(32).weigher(Weighers.singleton()).build();
    }

    public DefaultSimpleCache() {
        this(200000, null);
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public Collection<K> getKeys() {
        return this.map.keySet();
    }

    public V get(K key) {
        AbstractMap.SimpleImmutableEntry kvp = (AbstractMap.SimpleImmutableEntry)this.map.get(key);
        if (kvp == null) {
            return null;
        }
        return kvp.getValue();
    }

    public void put(K key, V value) {
        this.putAndCheckUpdate(key, value);
    }

    public boolean putAndCheckUpdate(K key, V value) {
        AbstractMap.SimpleImmutableEntry<K, V> kvp = new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        AbstractMap.SimpleImmutableEntry priorKVP = (AbstractMap.SimpleImmutableEntry)this.map.put(key, kvp);
        return priorKVP != null && !priorKVP.equals(kvp);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return "DefaultSimpleCache[maxItems=" + this.map.capacity() + ", cacheName=" + this.cacheName + "]";
    }

    public void setMaxItems(int maxItems) {
        this.map.setCapacity(maxItems);
    }

    public int getMaxItems() {
        return this.map.capacity();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setBeanName(String cacheName) {
        this.cacheName = cacheName;
    }
}

