/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config;

import com.sun.star.uno.RuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.cache.AbstractAsynchronouslyRefreshedCache;
import org.alfresco.repo.config.ImmutableConfig;
import org.alfresco.repo.config.xml.RepoXMLConfigService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class ConfigDataCache
extends AbstractAsynchronouslyRefreshedCache<ConfigData> {
    private static Log logger = LogFactory.getLog(ConfigDataCache.class);
    private RepoXMLConfigService repoXMLConfigService;

    public void setRepoXMLConfigService(RepoXMLConfigService repoXMLConfigService) {
        this.repoXMLConfigService = repoXMLConfigService;
    }

    @Override
    protected ConfigData buildCache(String tenantId) {
        ConfigData configData;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received request to rebuild config data for tenant: " + tenantId));
        }
        if (!((configData = this.repoXMLConfigService.getRepoConfig(tenantId)) instanceof ImmutableConfigData)) {
            throw new RuntimeException("ConfigData must be immutable for the cache.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rebuilt config data for tenant: " + tenantId + " (" + configData + ")."));
        }
        return configData;
    }

    public static class ImmutableConfigData
    extends ConfigData {
        private boolean locked = false;

        public ImmutableConfigData(ConfigData configData) {
            List<ConfigDeployment> configDeployments = configData.getConfigDeployments();
            if (configDeployments != null) {
                List<ConfigDeployment> configDeploymentsLocked = Collections.unmodifiableList(configDeployments);
                this.setConfigDeployments(configDeploymentsLocked);
            } else {
                this.setConfigDeployments(Collections.emptyList());
            }
            Map<String, ConfigElementReader> elementReaders = configData.getElementReaders();
            if (elementReaders != null) {
                Map<String, ConfigElementReader> elementReadersLocked = Collections.unmodifiableMap(elementReaders);
                this.setElementReaders(elementReadersLocked);
            } else {
                this.setElementReaders(Collections.emptyMap());
            }
            Map<String, Evaluator> evaluators = configData.getEvaluators();
            if (evaluators != null) {
                Map<String, Evaluator> evaluatorsLocked = Collections.unmodifiableMap(evaluators);
                this.setEvaluators(evaluatorsLocked);
            } else {
                this.setEvaluators(Collections.emptyMap());
            }
            ConfigImpl globalConfig = configData.getGlobalConfig();
            ImmutableConfig globalConfigLocked = new ImmutableConfig((Config)globalConfig);
            this.setGlobalConfig(globalConfigLocked);
            List<ConfigSection> sections = configData.getSections();
            if (sections != null) {
                List<ConfigSection> sectionsLocked = Collections.unmodifiableList(sections);
                this.setSections(sectionsLocked);
            } else {
                this.setSections(Collections.emptyList());
            }
            Map<String, List<ConfigSection>> sectionsByArea = configData.getSectionsByArea();
            if (sectionsByArea != null) {
                Map<String, List<ConfigSection>> sectionsByAreaLocked = Collections.unmodifiableMap(sectionsByArea);
                this.setSectionsByArea(sectionsByAreaLocked);
            } else {
                this.setSectionsByArea(Collections.emptyMap());
            }
            this.locked = true;
        }

        @Override
        public void setGlobalConfig(ConfigImpl globalConfig) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setGlobalConfig(globalConfig);
        }

        @Override
        public void setEvaluators(Map<String, Evaluator> evaluators) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setEvaluators(evaluators);
        }

        @Override
        public void setSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setSectionsByArea(sectionsByArea);
        }

        @Override
        public void setSections(List<ConfigSection> sections) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setSections(sections);
        }

        @Override
        public void setElementReaders(Map<String, ConfigElementReader> elementReaders) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setElementReaders(elementReaders);
        }

        @Override
        public void setConfigDeployments(List<ConfigDeployment> configDeployments) {
            if (this.locked) {
                throw new IllegalStateException("ConfigData has been locked.");
            }
            super.setConfigDeployments(configDeployments);
        }
    }

    public static class ConfigData {
        private ConfigImpl globalConfig;
        private Map<String, Evaluator> evaluators;
        private Map<String, List<ConfigSection>> sectionsByArea;
        private List<ConfigSection> sections;
        private Map<String, ConfigElementReader> elementReaders;
        private List<ConfigDeployment> configDeployments;

        public ConfigImpl getGlobalConfig() {
            return this.globalConfig;
        }

        public void setGlobalConfig(ConfigImpl globalConfig) {
            this.globalConfig = globalConfig;
        }

        public Map<String, Evaluator> getEvaluators() {
            return this.evaluators;
        }

        public void setEvaluators(Map<String, Evaluator> evaluators) {
            this.evaluators = evaluators;
        }

        public Map<String, List<ConfigSection>> getSectionsByArea() {
            return this.sectionsByArea;
        }

        public void setSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
            this.sectionsByArea = sectionsByArea;
        }

        public List<ConfigSection> getSections() {
            return this.sections;
        }

        public void setSections(List<ConfigSection> sections) {
            this.sections = sections;
        }

        public Map<String, ConfigElementReader> getElementReaders() {
            return this.elementReaders;
        }

        public void setElementReaders(Map<String, ConfigElementReader> elementReaders) {
            this.elementReaders = elementReaders;
        }

        public List<ConfigDeployment> getConfigDeployments() {
            return this.configDeployments;
        }

        public void setConfigDeployments(List<ConfigDeployment> configDeployments) {
            this.configDeployments = configDeployments;
        }
    }
}

