/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentAccessor;
import org.alfresco.repo.content.ContentLimitProvider;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.LimitedStreamCopier;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.TempFileProvider;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;

public abstract class AbstractContentWriter
extends AbstractContentAccessor
implements ContentWriter {
    private static final Log logger = LogFactory.getLog(AbstractContentWriter.class);
    private List<ContentStreamListener> listeners;
    private WritableByteChannel channel;
    private ContentReader existingContentReader;
    private MimetypeService mimetypeService;
    private DoGuessingOnCloseListener guessingOnCloseListener;
    private ContentLimitProvider limitProvider = new ContentLimitProvider.NoLimitProvider();
    private LimitedStreamCopier sizeLimitedStreamCopier = new LimitedStreamCopier();

    protected AbstractContentWriter(String contentUrl, ContentReader existingContentReader) {
        super(contentUrl);
        this.existingContentReader = existingContentReader;
        this.listeners = new ArrayList<ContentStreamListener>(2);
        this.guessingOnCloseListener = new DoGuessingOnCloseListener();
        this.listeners.add(this.guessingOnCloseListener);
    }

    public void setContentLimitProvider(ContentLimitProvider limitProvider) {
        this.limitProvider = limitProvider;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected ContentReader getExistingContentReader() {
        return this.existingContentReader;
    }

    public synchronized void addListener(ContentStreamListener listener) {
        if (this.channel != null) {
            throw new RuntimeException("Channel is already in use");
        }
        this.listeners.add(listener);
    }

    protected abstract ContentReader createReader() throws ContentIOException;

    public final ContentReader getReader() throws ContentIOException {
        String contentUrl = this.getContentUrl();
        if (!this.isClosed()) {
            return new EmptyContentReader(contentUrl);
        }
        ContentReader reader = this.createReader();
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentReader failed to create new reader: \n   writer: " + this);
        }
        if (reader.getContentUrl() == null || !reader.getContentUrl().equals(contentUrl)) {
            throw new AlfrescoRuntimeException("ContentReader has different URL: \n   writer: " + this + "\n" + "   new reader: " + reader);
        }
        reader.setMimetype(this.getMimetype());
        reader.setEncoding(this.getEncoding());
        reader.setLocale(this.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writer spawned new reader: \n   writer: " + this + "\n" + "   new reader: " + reader));
        }
        return reader;
    }

    protected ContentLimitProvider getContentLimitProvider() {
        return this.limitProvider == null ? new ContentLimitProvider.NoLimitProvider() : this.limitProvider;
    }

    public final synchronized boolean isClosed() {
        if (this.channel != null) {
            return !this.channel.isOpen();
        }
        return false;
    }

    public synchronized boolean isChannelOpen() {
        if (this.channel != null) {
            return this.channel.isOpen();
        }
        return false;
    }

    protected abstract WritableByteChannel getDirectWritableChannel() throws ContentIOException;

    private WritableByteChannel getCallbackWritableChannel(WritableByteChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        WritableByteChannel callbackChannel = null;
        if (directChannel instanceof FileChannel) {
            callbackChannel = this.getCallbackFileChannel((FileChannel)directChannel, listeners);
        } else {
            AbstractContentAccessor.ChannelCloseCallbackAdvise advise = new AbstractContentAccessor.ChannelCloseCallbackAdvise(listeners);
            ProxyFactory proxyFactory = new ProxyFactory((Object)directChannel);
            proxyFactory.addAdvice((Advice)advise);
            callbackChannel = (WritableByteChannel)proxyFactory.getProxy();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created callback byte channel: \n   original: " + directChannel + "\n" + "   new: " + callbackChannel));
        }
        return callbackChannel;
    }

    public final synchronized WritableByteChannel getWritableChannel() throws ContentIOException {
        if (this.channel != null) {
            throw new ContentIOException("A channel has already been opened");
        }
        WritableByteChannel directChannel = this.getDirectWritableChannel();
        this.channel = this.getCallbackWritableChannel(directChannel, this.listeners);
        super.channelOpened();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opened channel onto content: \n   content: " + this + "\n" + "   channel: " + this.channel));
        }
        return this.channel;
    }

    public FileChannel getFileChannel(boolean truncate) throws ContentIOException {
        this.channel = this.getWritableChannel();
        FileChannel clientFileChannel = null;
        if (this.channel instanceof FileChannel) {
            clientFileChannel = (FileChannel)this.channel;
            if (!truncate && this.existingContentReader != null) {
                ReadableByteChannel existingContentChannel = this.existingContentReader.getReadableChannel();
                long existingContentLength = this.existingContentReader.getSize();
                try {
                    clientFileChannel.transferFrom(existingContentChannel, 0L, existingContentLength);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Copied content for random access: \n   writer: " + this + "\n" + "   existing: " + this.existingContentReader));
                    }
                }
                catch (IOException e) {
                    throw new ContentIOException("Failed to copy from existing content to enable random access: \n   writer: " + this + "\n" + "   existing: " + this.existingContentReader, (Throwable)e);
                }
                finally {
                    try {
                        existingContentChannel.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content writer provided direct support for FileChannel: \n   writer: " + this));
            }
        } else {
            File tempFile = TempFileProvider.createTempFile((String)"random_write_spoof_", (String)".bin");
            final FileContentWriter spoofWriter = new FileContentWriter(tempFile, this.getExistingContentReader());
            ContentStreamListener spoofListener = new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    ContentReader spoofReader = spoofWriter.getReader();
                    FileChannel spoofChannel = spoofReader.getFileChannel();
                    try {
                        long spoofFileSize = spoofChannel.size();
                        spoofChannel.transferTo(0L, spoofFileSize, AbstractContentWriter.this.channel);
                    }
                    catch (IOException e) {
                        throw new ContentIOException("Failed to copy from spoofed temporary channel to permanent channel: \n   writer: " + this + "\n" + "   temp: " + spoofReader, (Throwable)e);
                    }
                    finally {
                        try {
                            spoofChannel.close();
                        }
                        catch (Throwable e) {}
                        try {
                            AbstractContentWriter.this.channel.close();
                        }
                        catch (IOException e) {
                            throw new ContentIOException("Failed to close underlying channel", (Throwable)e);
                        }
                    }
                }
            };
            spoofWriter.addListener(spoofListener);
            clientFileChannel = spoofWriter.getFileChannel(truncate);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content writer provided indirect support for FileChannel: \n   writer: " + this + "\n" + "   temp writer: " + spoofWriter));
            }
        }
        return clientFileChannel;
    }

    public OutputStream getContentOutputStream() throws ContentIOException {
        try {
            WritableByteChannel channel = this.getWritableChannel();
            BufferedOutputStream is = new BufferedOutputStream(Channels.newOutputStream(channel));
            return is;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open stream onto channel: \n   writer: " + this, e);
        }
    }

    public void putContent(ContentReader reader) throws ContentIOException {
        try {
            InputStream is = reader.getContentInputStream();
            this.putContent(is);
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to copy reader content to writer: \n   writer: " + this + "\n" + "   source reader: " + reader, e);
        }
    }

    public final void putContent(InputStream is) throws ContentIOException {
        try {
            OutputStream os = this.getContentOutputStream();
            this.copyStreams(is, os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from input stream: \n   writer: " + this, (Throwable)e);
        }
    }

    public final void putContent(File file) throws ContentIOException {
        try {
            OutputStream os = this.getContentOutputStream();
            FileInputStream is = new FileInputStream(file);
            this.copyStreams(is, os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from file: \n   writer: " + this + "\n" + "   file: " + file, (Throwable)e);
        }
    }

    private final int copyStreams(InputStream in, OutputStream out) throws IOException {
        ContentLimitProvider contentLimitProvider = this.getContentLimitProvider();
        long sizeLimit = contentLimitProvider.getSizeLimit();
        int byteCount = this.sizeLimitedStreamCopier.copyStreams(in, out, sizeLimit);
        return byteCount;
    }

    public final void putContent(String content) throws ContentIOException {
        try {
            byte[] bytes;
            String encoding = this.getEncoding();
            if (encoding == null) {
                bytes = content.getBytes();
                this.setEncoding(System.getProperty("file.encoding"));
            } else {
                bytes = content.getBytes(encoding);
            }
            OutputStream os = this.getContentOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.copyStreams(is, os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from string: \n   writer: " + this + "   content length: " + content.length(), (Throwable)e);
        }
    }

    public void guessEncoding() {
        if (this.mimetypeService == null) {
            logger.warn((Object)"MimetypeService not supplied, but required for content guessing");
            return;
        }
        if (this.isClosed()) {
            this.doGuessEncoding();
        } else {
            this.guessingOnCloseListener.guessEncoding = true;
        }
    }

    private void doGuessEncoding() {
        ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
        ContentReader reader = this.getReader();
        InputStream is = reader.getContentInputStream();
        Charset charset = charsetFinder.getCharset(is, this.getMimetype());
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.setEncoding(charset.name());
    }

    public void guessMimetype(String filename) {
        if (this.mimetypeService == null) {
            logger.warn((Object)"MimetypeService not supplied, but required for content guessing");
            return;
        }
        if (this.isClosed()) {
            this.doGuessMimetype(filename);
        } else {
            this.guessingOnCloseListener.guessMimetype = true;
            this.guessingOnCloseListener.filename = filename;
        }
    }

    private void doGuessMimetype(String filename) {
        String mimetype = this.mimetypeService.guessMimetype(filename, this.getReader());
        this.setMimetype(mimetype);
    }

    private class DoGuessingOnCloseListener
    implements ContentStreamListener {
        private boolean guessEncoding = false;
        private boolean guessMimetype = false;
        private String filename = null;

        private DoGuessingOnCloseListener() {
        }

        public void contentStreamClosed() throws ContentIOException {
            if (this.guessMimetype) {
                AbstractContentWriter.this.doGuessMimetype(this.filename);
            }
            if (this.guessEncoding) {
                AbstractContentWriter.this.doGuessEncoding();
            }
        }
    }
}

