/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileWipingContentCleanerListener
implements ContentStoreCleanerListener {
    private static Log logger = LogFactory.getLog(FileWipingContentCleanerListener.class);

    @Override
    public void beforeDelete(ContentStore sourceStore, String contentUrl) throws ContentIOException {
        ContentReader reader = sourceStore.getReader(contentUrl);
        if (reader != null && reader.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to shread: \n   URL:    " + contentUrl + "\n" + "   Source: " + sourceStore));
            }
            try {
                this.shred(reader);
            }
            catch (Throwable e) {
                logger.error((Object)("Content shredding failed: \n   URL:    " + contentUrl + "\n" + "   Source: " + sourceStore + "\n" + "   Reader: " + reader), e);
            }
        } else {
            logger.error((Object)("Content no longer exists.  Unable to shred: \n   URL:    " + contentUrl + "\n" + "   Source: " + sourceStore));
        }
    }

    protected void shred(ContentReader reader) throws IOException {
        if (reader instanceof FileContentReader) {
            FileContentReader fileReader = (FileContentReader)reader;
            File file = fileReader.getFile();
            this.shred(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shred(File file) throws IOException {
        if (!file.exists() || !file.canWrite()) {
            throw new ContentIOException("Unable to write to file: " + file);
        }
        long bytes = file.length();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            int i = 0;
            while ((long)i < bytes) {
                ((OutputStream)os).write(0);
                ++i;
            }
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Throwable e) {}
        }
    }
}

