/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;

public class HtmlMetadataExtracter
extends AbstractMappingMetadataExtracter {
    private static final String KEY_AUTHOR = "author";
    private static final String KEY_TITLE = "title";
    private static final String KEY_DESCRIPTION = "description";
    public static final Set<String> MIMETYPES = new HashSet<String>(5);

    public HtmlMetadataExtracter() {
        super(MIMETYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        final Map<String, Serializable> rawProperties = this.newRawMap();
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            StringBuffer title = null;
            boolean inHead = false;

            @Override
            public void handleText(char[] data, int pos) {
                if (this.title != null) {
                    this.title.append(data);
                }
            }

            @Override
            public void handleComment(char[] data, int pos) {
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (HTML.Tag.HEAD.equals(t)) {
                    this.inHead = true;
                } else if (HTML.Tag.TITLE.equals(t) && this.inHead) {
                    this.title = new StringBuffer();
                } else {
                    this.handleSimpleTag(t, a, pos);
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (HTML.Tag.HEAD.equals(t)) {
                    this.inHead = false;
                } else if (HTML.Tag.TITLE.equals(t) && this.title != null) {
                    HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_TITLE, (Serializable)((Object)this.title.toString()), rawProperties);
                    this.title = null;
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (HTML.Tag.META.equals(t)) {
                    Object nameO = a.getAttribute(HTML.Attribute.NAME);
                    Object valueO = a.getAttribute(HTML.Attribute.CONTENT);
                    if (nameO == null || valueO == null) {
                        return;
                    }
                    String name = nameO.toString();
                    if (name.equalsIgnoreCase("creator") || name.equalsIgnoreCase(HtmlMetadataExtracter.KEY_AUTHOR) || name.equalsIgnoreCase("dc.creator")) {
                        HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_AUTHOR, (Serializable)((Object)valueO.toString()), rawProperties);
                    } else if (name.equalsIgnoreCase(HtmlMetadataExtracter.KEY_DESCRIPTION) || name.equalsIgnoreCase("dc.description")) {
                        HtmlMetadataExtracter.this.putRawValue(HtmlMetadataExtracter.KEY_DESCRIPTION, (Serializable)((Object)valueO.toString()), rawProperties);
                    }
                }
            }

            @Override
            public void handleError(String errorMsg, int pos) {
            }
        };
        String charsetGuess = "UTF-8";
        int tries = 0;
        while (tries < 3) {
            rawProperties.clear();
            Reader r = null;
            InputStream cis = null;
            try {
                cis = reader.getContentInputStream();
                r = new InputStreamReader(cis);
                ParserDelegator parser = new ParserDelegator();
                ((HTMLEditorKit.Parser)parser).parse(r, callback, tries > 0);
                break;
            }
            catch (ChangedCharSetException ccse) {
                ++tries;
                charsetGuess = ccse.getCharSetSpec();
                int begin = charsetGuess.indexOf("charset=");
                if (begin > 0) {
                    charsetGuess = charsetGuess.substring(begin + 8, charsetGuess.length());
                }
                reader = reader.getReader();
            }
            finally {
                if (r != null) {
                    r.close();
                }
                if (cis == null) continue;
                cis.close();
            }
        }
        return rawProperties;
    }

    static {
        MIMETYPES.add("text/html");
        MIMETYPES.add("application/xhtml+xml");
    }
}

