/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.content.metadata.TikaPoweredMetadataExtracter;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;

public class MailMetadataExtracter
extends TikaPoweredMetadataExtracter {
    private static final String KEY_SENT_DATE = "sentDate";
    private static final String KEY_ORIGINATOR = "originator";
    private static final String KEY_ADDRESSEE = "addressee";
    private static final String KEY_ADDRESSEES = "addressees";
    private static final String KEY_SUBJECT = "subjectLine";
    private static final String KEY_TO_NAMES = "toNames";
    private static final String KEY_CC_NAMES = "ccNames";
    private static final String KEY_BCC_NAMES = "bccNames";
    public static ArrayList<String> SUPPORTED_MIMETYPES = MailMetadataExtracter.buildSupportedMimetypes(new String[]{"application/vnd.ms-outlook"}, null);

    public MailMetadataExtracter() {
        super(SUPPORTED_MIMETYPES);
    }

    @Override
    protected Parser getParser() {
        return new OfficeParser();
    }

    @Override
    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_ORIGINATOR, (Serializable)((Object)metadata.get("Author")), properties);
        this.putRawValue(KEY_SUBJECT, (Serializable)((Object)metadata.get("title")), properties);
        this.putRawValue("description", (Serializable)((Object)metadata.get("subject")), properties);
        this.putRawValue(KEY_SENT_DATE, (Serializable)((Object)metadata.get(Metadata.LAST_SAVED)), properties);
        this.putRawValue(KEY_ADDRESSEE, (Serializable)((Object)metadata.get("Message-To")), properties);
        this.putRawValue(KEY_TO_NAMES, (Serializable)metadata.getValues("Message-To"), properties);
        this.putRawValue(KEY_CC_NAMES, (Serializable)metadata.getValues("Message-Cc"), properties);
        this.putRawValue(KEY_BCC_NAMES, (Serializable)metadata.getValues("Message-Bcc"), properties);
        this.putRawValue(KEY_ADDRESSEES, (Serializable)metadata.getValues("Message-Recipient-Address"), properties);
        return properties;
    }
}

