/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.metadata.TikaPoweredMetadataExtracter;
import org.alfresco.service.namespace.QName;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OpenDocumentMetadataExtracter
extends TikaPoweredMetadataExtracter {
    private static final String KEY_CREATION_DATE = "creationDate";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_DATE = "date";
    private static final String KEY_GENERATOR = "generator";
    private static final String KEY_INITIAL_CREATOR = "initialCreator";
    private static final String KEY_KEYWORD = "keyword";
    private static final String KEY_LANGUAGE = "language";
    private static final String CUSTOM_PREFIX = "custom:";
    public static ArrayList<String> SUPPORTED_MIMETYPES = OpenDocumentMetadataExtracter.buildSupportedMimetypes(new String[]{"application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.chart", "applicationvnd.oasis.opendocument.chart-template", "application/vnd.oasis.opendocument.image", "applicationvnd.oasis.opendocument.image-template", "application/vnd.oasis.opendocument.formula", "applicationvnd.oasis.opendocument.formula-template", "application/vnd.oasis.opendocument.text-master", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.database"}, new Parser[]{new OpenDocumentParser()});
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");

    public OpenDocumentMetadataExtracter() {
        super(SUPPORTED_MIMETYPES);
    }

    @Override
    protected Parser getParser() {
        return new OpenDocumentParser();
    }

    @Override
    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_CREATION_DATE, this.getDateOrNull(metadata.get(Metadata.CREATION_DATE)), properties);
        this.putRawValue(KEY_CREATOR, (Serializable)((Object)metadata.get(KEY_CREATOR)), properties);
        this.putRawValue(KEY_DATE, this.getDateOrNull(metadata.get(Metadata.DATE)), properties);
        this.putRawValue("description", (Serializable)((Object)metadata.get("description")), properties);
        this.putRawValue(KEY_GENERATOR, (Serializable)((Object)metadata.get(KEY_GENERATOR)), properties);
        this.putRawValue(KEY_INITIAL_CREATOR, (Serializable)((Object)metadata.get("initial-creator")), properties);
        this.putRawValue(KEY_KEYWORD, (Serializable)((Object)metadata.get("Keywords")), properties);
        this.putRawValue(KEY_LANGUAGE, (Serializable)((Object)metadata.get(KEY_LANGUAGE)), properties);
        Map<String, Set<QName>> mapping = super.getMapping();
        for (String key : mapping.keySet()) {
            if (metadata.get(CUSTOM_PREFIX + key) == null) continue;
            this.putRawValue(key, (Serializable)((Object)metadata.get(CUSTOM_PREFIX + key)), properties);
        }
        return properties;
    }

    private Date getDateOrNull(String dateString) {
        if (dateString != null && dateString.length() != 0) {
            try {
                return dateFormatter.parseDateTime(dateString).toDate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

