/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathMetadataExtracter
extends AbstractMappingMetadataExtracter
implements NamespaceContext {
    public static String[] SUPPORTED_MIMETYPES = new String[]{"text/xml"};
    private static Log logger = LogFactory.getLog(XPathMetadataExtracter.class);
    private DocumentBuilder documentBuilder;
    private DocumentBuilder dtdIgnoringDocumentBuilder;
    private XPathFactory xpathFactory;
    private Map<String, String> namespacesByPrefix;
    private Map<String, XPathExpression> xpathExpressionMapping;

    public XPathMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)));
        try {
            DocumentBuilderFactory normalFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = normalFactory.newDocumentBuilder();
            DocumentBuilderFactory dtdIgnoringFactory = DocumentBuilderFactory.newInstance();
            dtdIgnoringFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dtdIgnoringFactory.setFeature("http://xml.org/sax/features/validation", false);
            this.dtdIgnoringDocumentBuilder = dtdIgnoringFactory.newDocumentBuilder();
            this.xpathFactory = XPathFactory.newInstance();
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to initialize XML metadata extractor", e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        ParameterCheck.mandatoryString((String)"prefix", (String)prefix);
        String namespace = this.namespacesByPrefix.get(prefix);
        if (namespace == null) {
            throw new AlfrescoRuntimeException("Prefix '" + prefix + "' is not associated with a namespace.");
        }
        return namespace;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        ParameterCheck.mandatoryString((String)"namespaceURI", (String)namespaceURI);
        for (Map.Entry<String, String> entry : this.namespacesByPrefix.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        ParameterCheck.mandatoryString((String)"namespaceURI", (String)namespaceURI);
        ArrayList<String> prefixes = new ArrayList<String>(2);
        for (Map.Entry<String, String> entry : this.namespacesByPrefix.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            prefixes.add(entry.getKey());
        }
        return prefixes.iterator();
    }

    public void setXpathMappingProperties(Properties xpathMappingProperties) {
        this.namespacesByPrefix = new HashMap<String, String>(7);
        this.xpathExpressionMapping = new HashMap<String, XPathExpression>(17);
        this.readXPathMappingProperties(xpathMappingProperties);
    }

    @Override
    protected void init() {
        PropertyCheck.mandatory((Object)this, (String)"xpathMappingProperties", this.xpathExpressionMapping);
        super.init();
        Map<String, Set<QName>> mapping = this.getMapping();
        HashSet<String> xpathExpressionMappingKeys = new HashSet<String>(this.xpathExpressionMapping.keySet());
        for (String xpathMappingKey : xpathExpressionMappingKeys) {
            if (mapping.containsKey(xpathMappingKey)) continue;
            this.xpathExpressionMapping.remove(xpathMappingKey);
        }
    }

    @Override
    protected Map<String, Set<QName>> getDefaultMapping() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        InputStream is = null;
        try {
            Document doc;
            is = reader.getContentInputStream();
            try {
                doc = this.documentBuilder.parse(is);
            }
            catch (FileNotFoundException e) {
                is = reader.getReader().getContentInputStream();
                doc = this.dtdIgnoringDocumentBuilder.parse(is);
            }
            Map<String, Serializable> rawProperties = this.processDocument(doc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nExtracted XML metadata: \n   Reader:  " + reader + "\n" + "   Results: " + rawProperties));
            }
            Map<String, Serializable> map = rawProperties;
            return map;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Map<String, Serializable> processDocument(Document document) throws Throwable {
        Map<String, Serializable> rawProperties = super.newRawMap();
        for (Map.Entry<String, XPathExpression> element : this.xpathExpressionMapping.entrySet()) {
            String documentProperty = element.getKey();
            XPathExpression xpathExpression = element.getValue();
            Serializable value = null;
            try {
                value = this.getNodeSetValue(document, xpathExpression);
            }
            catch (XPathExpressionException e) {
                value = this.getStringValue(document, xpathExpression);
            }
            super.putRawValue(documentProperty, value, rawProperties);
        }
        return rawProperties;
    }

    private Serializable getStringValue(Document document, XPathExpression xpathExpression) throws XPathExpressionException {
        String value = (String)xpathExpression.evaluate(document, XPathConstants.STRING);
        return value;
    }

    private Serializable getNodeSetValue(Document document, XPathExpression xpathExpression) throws XPathExpressionException {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to evaluate expression and return a NODESET: " + xpathExpression));
            }
            throw e;
        }
        Object value = null;
        int nodeCount = nodeList.getLength();
        if (nodeCount != 0) {
            if (nodeCount == 1) {
                Node node = nodeList.item(0);
                value = node.getTextContent();
            } else {
                ArrayList<String> stringValues = new ArrayList<String>(5);
                for (int i = 0; i < nodeCount; ++i) {
                    stringValues.add(nodeList.item(i).getTextContent());
                }
                value = stringValues;
            }
        }
        return value;
    }

    protected void readXPathMappingProperties(Properties xpathMappingProperties) {
        for (Map.Entry<Object, Object> entry : xpathMappingProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith("namespace.prefix.")) continue;
            String prefix = propertyName.substring(17);
            String namespace = (String)entry.getValue();
            this.namespacesByPrefix.put(prefix, namespace);
        }
        for (Map.Entry<Object, Object> entry : xpathMappingProperties.entrySet()) {
            String documentProperty = (String)entry.getKey();
            String xpathStr = (String)entry.getValue();
            if (documentProperty.startsWith("namespace.prefix.")) continue;
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(this);
            XPathExpression xpathExpression = null;
            try {
                xpathExpression = xpath.compile(xpathStr);
            }
            catch (XPathExpressionException e) {
                throw new AlfrescoRuntimeException("\nFailed to create XPath expression: \n   Document property: " + documentProperty + "\n" + "   XPath:             " + xpathStr + "\n" + "   Error: " + e.getMessage(), (Throwable)e);
            }
            this.xpathExpressionMapping.put(documentProperty, xpathExpression);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Added mapping from " + documentProperty + " to " + xpathStr));
        }
    }
}

