/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.repo.content.transform.SupportedTransformation;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public class ContentTransformerHelper
implements BeanNameAware {
    private static final Log logger = LogFactory.getLog(ContentTransformerHelper.class);
    private MimetypeService mimetypeService;
    protected TransformerConfig transformerConfig;
    List<DeprecatedSetter> deprecatedSetterMessages;
    private static boolean firstDeprecatedSetter = true;
    private String beanName;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setExplicitTransformations(List<ExplictTransformationDetails> explicitTransformations) {
        this.deprecatedSupportedTransformations(explicitTransformations, null);
    }

    public void setSupportedTransformations(List<SupportedTransformation> supportedTransformations) {
        this.deprecatedSupportedTransformations(supportedTransformations, "true");
    }

    public void setUnsupportedTransformations(List<SupportedTransformation> unsupportedTransformations) {
        this.deprecatedSupportedTransformations(unsupportedTransformations, "false");
    }

    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    protected String getMimetype(ContentAccessor content) {
        String mimetype = content.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("Mimetype is mandatory for transformation: " + content);
        }
        return mimetype;
    }

    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.transformerConfig.getPriority((ContentTransformer)((Object)this), sourceMimetype, targetMimetype) == 50;
    }

    public boolean isSupportedTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.transformerConfig.isSupportedTransformation((ContentTransformer)((Object)this), sourceMimetype, targetMimetype, options);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void register() {
        this.logDeprecatedSetter(this.deprecatedSetterMessages);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getName() {
        return this.beanName == null ? this.getClass().getSimpleName() : this.beanName;
    }

    public static String getSimpleName(ContentTransformer transformer) {
        String transformerName = transformer.getName();
        return transformerName.startsWith("transformer.") ? transformerName.substring("transformer.".length()) : transformerName;
    }

    protected void deprecatedSetter(String sourceMimetype, String targetMimetype, String suffixAndValue) {
        if (this.deprecatedSetterMessages == null) {
            this.deprecatedSetterMessages = new ArrayList<DeprecatedSetter>();
        }
        this.deprecatedSetterMessages.add(new DeprecatedSetter(sourceMimetype, targetMimetype, suffixAndValue));
    }

    void logDeprecatedSetter(List<DeprecatedSetter> deprecatedSetterMessages) {
        if (deprecatedSetterMessages != null) {
            StringBuilder sb = new StringBuilder();
            for (DeprecatedSetter deprecatedSetter : deprecatedSetterMessages) {
                String propertyNameAndValue = deprecatedSetter.getPropertyNameAndValue(this.beanName);
                String propertyName = propertyNameAndValue.replaceAll("=.*", "");
                if (this.transformerConfig.getProperty(propertyName) == null) {
                    if (firstDeprecatedSetter) {
                        firstDeprecatedSetter = false;
                        logger.error((Object)"In order to support dynamic setting of transformer options, Spring XML configuration");
                        logger.error((Object)"is no longer used to initialise these options.");
                        logger.error((Object)" ");
                        logger.error((Object)"Your system appears to contains custom Spring configuration which should be replace by");
                        logger.error((Object)"the following Alfresco global properties. In the case of the Enterprise edition these");
                        logger.error((Object)"values may then be dynamically changed via JMX.");
                        logger.error((Object)" ");
                    }
                    logger.error((Object)propertyNameAndValue);
                    sb.append(propertyNameAndValue);
                    sb.append('\n');
                    continue;
                }
                logger.warn((Object)(propertyNameAndValue + " is set, but spring config still exists"));
            }
            deprecatedSetterMessages = null;
            if (sb.length() > 0) {
                this.transformerConfig.setProperties(sb.toString());
            }
        }
    }

    private void deprecatedSupportedTransformations(List<? extends SupportedTransformation> transformations, String value) {
        if (transformations != null) {
            for (SupportedTransformation supportedTransformation : transformations) {
                String sourceMimetype = supportedTransformation.getSourceMimetype();
                String targetMimetype = supportedTransformation.getTargetMimetype();
                if (value == null) {
                    this.deprecatedSetter(sourceMimetype, targetMimetype, ".priority=50");
                    this.deprecatedSetter(sourceMimetype, targetMimetype, ".supported=true");
                    continue;
                }
                this.deprecatedSetter(sourceMimetype, targetMimetype, ".supported=" + value);
            }
        }
    }

    protected String getExtensionOrAny(String mimetype) {
        return mimetype == null || "*".equals(mimetype) ? "*" : this.mimetypeService.getExtension(mimetype);
    }

    public String toString() {
        return this.getName();
    }

    public String getComments(boolean available) {
        return this.getCommentNameAndAvailable(available);
    }

    protected String getCommentsOnlySupports(List<String> sourceMimetypes, List<String> targetMimetypes, boolean available) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCommentNameAndAvailable(available));
        sb.append("# Only supports ");
        sb.append(this.getExtensions(sourceMimetypes));
        sb.append(" to ");
        sb.append(this.getExtensions(targetMimetypes));
        sb.append("\n");
        return sb.toString();
    }

    String getCommentNameAndAvailable(boolean available) {
        String name = this instanceof ContentTransformer ? ContentTransformerHelper.getSimpleName((ContentTransformer)((Object)this)) : this.getName();
        StringBuilder sb = new StringBuilder();
        sb.append(ContentTransformerHelper.getCommentName(name));
        if (!available) {
            sb.append("# ");
            sb.append("content.");
            sb.append(this.getName());
            sb.append(".available");
            sb.append("=false\n");
        }
        return sb.toString();
    }

    static String getCommentName(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("# ");
        sb.append(name);
        sb.append('\n');
        sb.append("# ");
        for (int i = name.length(); i > 0; --i) {
            sb.append('-');
        }
        sb.append('\n');
        return sb.toString();
    }

    protected String onlySupports(String sourceMimetype, String targetMimetype, boolean available) {
        return this.getCommentsOnlySupports(Arrays.asList(sourceMimetype), Arrays.asList(targetMimetype), available);
    }

    private String getExtensions(List<String> origMimetypes) {
        ArrayList<String> mimetypes = new ArrayList<String>(origMimetypes);
        mimetypes.retainAll(this.getMimetypeService().getMimetypes());
        StringBuilder sb = new StringBuilder();
        int j = mimetypes.size();
        int i = 1;
        for (String mimetype : mimetypes) {
            sb.append(this.getMimetypeService().getExtension(mimetype));
            if (i >= j) continue;
            sb.append(++i < j ? ", " : " or ");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentTransformerHelper other = (ContentTransformerHelper)obj;
        return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
    }

    private class DeprecatedSetter {
        private final String sourceMimetype;
        private final String targetMimetype;
        private final String suffixAndValue;

        DeprecatedSetter(String sourceMimetype, String targetMimetype, String suffixAndValue) {
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.suffixAndValue = suffixAndValue;
        }

        public String getPropertyNameAndValue(String beanName) {
            return "content." + beanName + (this.sourceMimetype != null ? ".extensions." + ContentTransformerHelper.this.getExtensionOrAny(this.sourceMimetype) + '.' + ContentTransformerHelper.this.getExtensionOrAny(this.targetMimetype) : ".") + this.suffixAndValue;
        }
    }
}

