/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.UnimportantTransformException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;

public class OOXMLThumbnailContentTransformer
extends AbstractContentTransformer2 {
    public static final String NO_THUMBNAIL_PRESENT_IN_FILE = "No thumbnail present in file, unable to generate ";
    private static final Log log = LogFactory.getLog(OOXMLThumbnailContentTransformer.class);
    private static final List<String> OOXML_MIMETYPES = Arrays.asList("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.ms-powerpoint.template.macroenabled.12", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slide", "application/vnd.ms-powerpoint.slide.macroenabled.12", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-excel.addin.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
    private static final List<String> TARGET_MIMETYPES = Arrays.asList("image/jpeg");

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return TARGET_MIMETYPES.contains(targetMimetype) && OOXML_MIMETYPES.contains(sourceMimetype);
    }

    @Override
    public String getComments(boolean available) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getComments(available));
        sb.append("# Only supports extraction of embedded jpegs from OOXML formats\n");
        return sb.toString();
    }

    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        block8: {
            String sourceMimetype = reader.getMimetype();
            String sourceExtension = this.getMimetypeService().getExtension(sourceMimetype);
            String targetMimetype = writer.getMimetype();
            if (log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Transforming from ").append(sourceMimetype).append(" to ").append(targetMimetype);
                log.debug((Object)msg.toString());
            }
            try (OPCPackage pkg = null;){
                File ooxmlTempFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_ooxml"), (String)sourceExtension);
                reader.getContent(ooxmlTempFile);
                pkg = OPCPackage.open((String)ooxmlTempFile.getPath());
                PackageRelationshipCollection rels = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
                if (rels.size() > 0) {
                    PackageRelationship tRel = rels.getRelationship(0);
                    PackagePart tPart = pkg.getPart(tRel);
                    InputStream tStream = tPart.getInputStream();
                    writer.putContent(tStream);
                    tStream.close();
                    break block8;
                }
                log.debug((Object)("No thumbnail present in " + reader.toString()));
                throw new UnimportantTransformException(NO_THUMBNAIL_PRESENT_IN_FILE + targetMimetype);
            }
        }
    }
}

