/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringExtractingContentTransformer
extends AbstractContentTransformer2 {
    public static final String PREFIX_TEXT = "text/";
    private static final Log logger = LogFactory.getLog(StringExtractingContentTransformer.class);

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!targetMimetype.equals("text/plain")) {
            return false;
        }
        if (sourceMimetype.equals("text/plain") || sourceMimetype.equals("application/x-javascript")) {
            return true;
        }
        return sourceMimetype.startsWith(PREFIX_TEXT);
    }

    @Override
    public String getComments(boolean available) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getComments(available));
        sb.append("# Only supports transformation of js and mimetypes starting with \"");
        sb.append(PREFIX_TEXT);
        sb.append("\" to txt.\n");
        return sb.toString();
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        this.transformText(reader, writer, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformText(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        Reader charReader = null;
        Writer charWriter = null;
        try {
            charReader = reader.getEncoding() == null ? new InputStreamReader(reader.getContentInputStream()) : new InputStreamReader(reader.getContentInputStream(), reader.getEncoding());
            charWriter = writer.getEncoding() == null ? new OutputStreamWriter(writer.getContentOutputStream()) : new OutputStreamWriter(writer.getContentOutputStream(), writer.getEncoding());
            char[] buffer = new char[8192];
            int readCount = 0;
            while (readCount > -1) {
                charWriter.write(buffer, 0, readCount);
                readCount = charReader.read(buffer);
            }
        }
        finally {
            if (charReader != null) {
                try {
                    charReader.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
            if (charWriter != null) {
                try {
                    charWriter.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

