/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.TransformerInfoException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.xml.sax.ContentHandler;

public abstract class TikaPoweredContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(TikaPoweredContentTransformer.class);
    private static final List<String> TARGET_MIMETYPES = Arrays.asList("text/plain", "text/html", "application/xhtml+xml", "text/xml");
    protected List<String> sourceMimeTypes;
    protected static final String LINE_BREAK = "\r\n";
    public static final String WRONG_FORMAT_MESSAGE_ID = "transform.err.format_or_password";

    protected TikaPoweredContentTransformer(List<String> sourceMimeTypes) {
        this.sourceMimeTypes = sourceMimeTypes;
    }

    protected TikaPoweredContentTransformer(String[] sourceMimeTypes) {
        this(Arrays.asList(sourceMimeTypes));
    }

    protected abstract Parser getParser();

    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!this.sourceMimeTypes.contains(sourceMimetype)) {
            return false;
        }
        return TARGET_MIMETYPES.contains(targetMimetype);
    }

    @Override
    public String getComments(boolean available) {
        return this.getCommentsOnlySupports(this.sourceMimeTypes, TARGET_MIMETYPES, available);
    }

    protected ContentHandler getContentHandler(String targetMimeType, Writer output) throws TransformerConfigurationException {
        if ("text/plain".equals(targetMimeType)) {
            return new BodyContentHandler(output);
        }
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(output));
        if ("text/html".equals(targetMimeType)) {
            handler.getTransformer().setOutputProperty("method", "html");
            return new ExpandedTitleContentHandler((ContentHandler)handler);
        }
        if (!"application/xhtml+xml".equals(targetMimeType) && !"text/xml".equals(targetMimeType)) {
            throw new TransformerInfoException(WRONG_FORMAT_MESSAGE_ID, new IllegalArgumentException("Requested target type " + targetMimeType + " not supported"));
        }
        handler.getTransformer().setOutputProperty("method", "xml");
        return handler;
    }

    protected ParseContext buildParseContext(Metadata metadata, String targetMimeType, TransformationOptions options) {
        return new ParseContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        OutputStream os = writer.getContentOutputStream();
        String encoding = writer.getEncoding();
        String targetMimeType = writer.getMimetype();
        OutputStreamWriter ow = new OutputStreamWriter(os, encoding);
        Parser parser = this.getParser();
        Metadata metadata = new Metadata();
        ParseContext context = this.buildParseContext(metadata, targetMimeType, options);
        ContentHandler handler = this.getContentHandler(targetMimeType, ow);
        if (handler == null) {
            throw new TransformerConfigurationException("Unable to create Tika Handler for configured output " + targetMimeType);
        }
        InputStream is = reader instanceof FileContentReader ? TikaInputStream.get((File)((FileContentReader)reader).getFile(), (Metadata)metadata) : reader.getContentInputStream();
        try {
            parser.parse(is, handler, metadata, context);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
            if (ow != null) {
                try {
                    ((Writer)ow).close();
                }
                catch (Throwable e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

