/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.FailoverContentTransformer;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixKey;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerConfigDynamicTransformers
extends TransformerPropertyNameExtractor {
    private static final Log logger = LogFactory.getLog(TransformerConfigDynamicTransformers.class);
    int errorCount = 0;
    private final List<ContentTransformer> dynamicTransformers = new ArrayList<ContentTransformer>();

    public TransformerConfigDynamicTransformers(TransformerConfig transformerConfig, TransformerProperties transformerProperties, MimetypeService mimetypeService, ContentService contentService, ContentTransformerRegistry transformerRegistry, TransformerDebug transformerDebug) {
        this.createDynamicTransformers(transformerConfig, transformerProperties, mimetypeService, contentService, transformerRegistry, transformerDebug);
    }

    private void createDynamicTransformers(TransformerConfig transformerConfig, TransformerProperties transformerProperties, MimetypeService mimetypeService, ContentService contentService, ContentTransformerRegistry transformerRegistry, TransformerDebug transformerDebug) {
        List<String> SUFFIXES = Arrays.asList(".failover", ".pipeline", ".available");
        Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues = this.getTransformerSourceTargetValuesMap(SUFFIXES, true, true, false, transformerProperties, mimetypeService);
        Collection<TransformerSourceTargetSuffixValue> properties = transformerSourceTargetSuffixValues.values();
        ArrayList<TransformerSourceTargetSuffixValue> processed = new ArrayList<TransformerSourceTargetSuffixValue>();
        do {
            processed.clear();
            for (TransformerSourceTargetSuffixValue property : properties) {
                if (!property.suffix.equals(".pipeline") && !property.suffix.equals(".failover")) continue;
                try {
                    String availableStr = this.getProperty(property.transformerName, null, null, ".available", null, transformerSourceTargetSuffixValues);
                    boolean available = availableStr == null || "true".equalsIgnoreCase(availableStr);
                    AbstractContentTransformer2 transformer = property.suffix.equals(".pipeline") ? this.createComplexTransformer(property, transformerConfig, mimetypeService, contentService, transformerRegistry, transformerDebug, available) : this.createFailoverTransformer(property, transformerConfig, mimetypeService, contentService, transformerRegistry, transformerDebug, available);
                    transformer.register();
                    processed.add(property);
                    this.dynamicTransformers.add(transformer);
                    logger.debug((Object)(property.transformerName + " added"));
                }
                catch (IllegalArgumentException e) {
                }
                catch (AlfrescoRuntimeException e) {
                    processed.add(property);
                    this.error(e.getMessage());
                }
            }
        } while (properties.removeAll(processed) && properties.size() > 0);
        for (TransformerSourceTargetSuffixValue property : properties) {
            if (!property.suffix.equals(".pipeline") && !property.suffix.equals(".failover")) continue;
            this.error("Cannot create dynamic transformer " + property.transformerName + " as sub transformers could not be found or created (\"" + property.value + "\").");
        }
    }

    private AbstractContentTransformer2 createComplexTransformer(TransformerSourceTargetSuffixValue property, TransformerConfig transformerConfig, MimetypeService mimetypeService, ContentService contentService, ContentTransformerRegistry transformerRegistry, TransformerDebug transformerDebug, boolean available) {
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>();
        ArrayList<String> intermediateMimetypes = new ArrayList<String>();
        this.extractTransformersAndMimetypes(property, transformers, intermediateMimetypes, mimetypeService, transformerRegistry);
        ComplexContentTransformer transformer = new ComplexContentTransformer(){

            @Override
            public String getComments(boolean available) {
                return this.getCommentNameAndAvailable(true);
            }
        };
        this.setupContentTransformer2(property, transformerConfig, mimetypeService, contentService, transformerRegistry, transformerDebug, available, transformer, transformers);
        transformer.setContentService(contentService);
        transformer.setTransformers(transformers);
        transformer.setIntermediateMimetypes(intermediateMimetypes);
        return transformer;
    }

    private AbstractContentTransformer2 createFailoverTransformer(TransformerSourceTargetSuffixValue property, TransformerConfig transformerConfig, MimetypeService mimetypeService, ContentService contentService, ContentTransformerRegistry transformerRegistry, TransformerDebug transformerDebug, boolean available) {
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>();
        this.extractTransformersAndMimetypes(property, transformers, null, mimetypeService, transformerRegistry);
        FailoverContentTransformer transformer = new FailoverContentTransformer(){

            @Override
            public String getComments(boolean available) {
                return this.getCommentNameAndAvailable(true);
            }
        };
        this.setupContentTransformer2(property, transformerConfig, mimetypeService, contentService, transformerRegistry, transformerDebug, available, transformer, transformers);
        transformer.setTransformers(transformers);
        return transformer;
    }

    private void extractTransformersAndMimetypes(TransformerSourceTargetSuffixValue property, List<ContentTransformer> transformers, List<String> intermediateMimetypes, MimetypeService mimetypeService, ContentTransformerRegistry transformerRegistry) {
        boolean hasMimetypes;
        String[] subTransformersAndMimetypes = property.value.split("\\|");
        boolean bl = hasMimetypes = intermediateMimetypes != null;
        if (!hasMimetypes && subTransformersAndMimetypes.length < 2 || hasMimetypes && (subTransformersAndMimetypes.length < 3 || subTransformersAndMimetypes.length % 2 == 0)) {
            throw new AlfrescoRuntimeException("Cannot create dynamic transformer " + property.transformerName + " as the value " + property.value + " has the wrong number of components.");
        }
        boolean isTransformerName = true;
        for (String name : subTransformersAndMimetypes) {
            if (isTransformerName) {
                try {
                    ContentTransformer subTransformer = "*".equals(name) ? null : transformerRegistry.getTransformer("transformer." + name);
                    transformers.add(subTransformer);
                }
                catch (IllegalArgumentException e) {
                    logger.trace((Object)(property.transformerName + " did not find " + "transformer." + name));
                    throw e;
                }
            } else {
                String mimetype = mimetypeService.getMimetype(name);
                if (!"bin".equals(name) && "application/octet-stream".equals(mimetype)) {
                    throw new AlfrescoRuntimeException("Cannot create dynamic transformer " + property.transformerName + " as the extension " + name + " is unregistered.");
                }
                intermediateMimetypes.add(mimetype);
            }
            if (!hasMimetypes) continue;
            isTransformerName = !isTransformerName;
        }
    }

    private void setupContentTransformer2(TransformerSourceTargetSuffixValue property, TransformerConfig transformerConfig, MimetypeService mimetypeService, ContentService contentService, ContentTransformerRegistry transformerRegistry, TransformerDebug transformerDebug, boolean available, AbstractContentTransformer2 transformer, List<ContentTransformer> transformers) {
        try {
            transformerRegistry.getTransformer(property.transformerName);
            throw new AlfrescoRuntimeException("Cannot create dynamic transformer " + property.transformerName + " as a transformer with that name already exists.");
        }
        catch (IllegalArgumentException e) {
            transformer.setMimetypeService(mimetypeService);
            transformer.setTransformerDebug(transformerDebug);
            transformer.setTransformerConfig(transformerConfig);
            transformer.setRegistry(transformerRegistry);
            transformer.setRegisterTransformer(true);
            transformer.setBeanName(property.transformerName);
            transformer.setRegisterTransformer(available);
            return;
        }
    }

    private void error(String msg) {
        ++this.errorCount;
        logger.error((Object)msg);
    }

    int getErrorCount() {
        return this.errorCount;
    }

    public void removeTransformers(ContentTransformerRegistry transformerRegistry) {
        for (ContentTransformer transformer : this.dynamicTransformers) {
            transformerRegistry.removeTransformer(transformer);
        }
    }
}

