/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.DoubleMap;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixKey;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerConfigProperty
extends TransformerPropertyNameExtractor {
    private Map<String, DoubleMap<String, String, String>> values;

    public TransformerConfigProperty(TransformerProperties transformerProperties, MimetypeService mimetypeService, String propertySuffix, String defaultValue) {
        this.setValues(transformerProperties, mimetypeService, propertySuffix, defaultValue);
    }

    private void setValues(TransformerProperties transformerProperties, MimetypeService mimetypeService, String suffix, String defaultValue) {
        TransformerSourceTargetSuffixValue transformerSourceTargetValue;
        TransformerSourceTargetSuffixKey key;
        this.values = new HashMap<String, DoubleMap<String, String, String>>();
        Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> properties = this.getTransformerSourceTargetValuesMap(Collections.singletonList(suffix), true, true, false, transformerProperties, mimetypeService);
        if (!properties.containsKey(key = (transformerSourceTargetValue = new TransformerSourceTargetSuffixValue("transformer.default", "*", "*", suffix, null, defaultValue, mimetypeService)).key())) {
            properties.put(key, transformerSourceTargetValue);
        }
        for (TransformerSourceTargetSuffixValue property : properties.values()) {
            DoubleMap<String, String, String> mimetypeValues = this.values.get(property.transformerName);
            if (mimetypeValues == null) {
                mimetypeValues = new DoubleMap("*", "*");
                this.values.put(property.transformerName, mimetypeValues);
            }
            mimetypeValues.put(property.sourceMimetype, property.targetMimetype, property.value);
        }
    }

    private String getString(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
        String value;
        if (sourceMimetype == null) {
            sourceMimetype = "*";
        }
        if (targetMimetype == null) {
            targetMimetype = "*";
        }
        String name = transformer == null ? "transformer.default" : transformer.getName();
        DoubleMap<String, String, String> mimetypeLimits = this.values.get(name);
        String string = value = mimetypeLimits == null ? null : mimetypeLimits.get(sourceMimetype, targetMimetype);
        if (value == null && transformer != null) {
            value = this.getString(null, sourceMimetype, targetMimetype);
        }
        return value;
    }

    public long getLong(ContentTransformer transformer, String sourceMimetype, String targetMimetype) throws NumberFormatException {
        return Long.parseLong(this.getString(transformer, sourceMimetype, targetMimetype));
    }

    public int getInt(ContentTransformer transformer, String sourceMimetype, String targetMimetype) throws NumberFormatException {
        return Integer.parseInt(this.getString(transformer, sourceMimetype, targetMimetype));
    }
}

