/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.text.SimpleDateFormat;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.alfresco.repo.content.transform.LogEntries;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.util.LogAdapter;

abstract class TransformerLogger<T>
extends LogAdapter
implements LogEntries {
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
    private TransformerDebug transformerDebug;
    private TransformerConfig transformerConfig;
    private int maxEntries = -1;
    private Deque<T> entries = new LinkedList<T>();

    TransformerLogger() {
        super(null);
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    private int getProperty(TransformerConfig transformerConfig, String propertyName, int min, int max) {
        int i = 0;
        String value = transformerConfig.getProperty(propertyName);
        if (value != null) {
            try {
                i = Integer.parseInt(value);
                if (i < 0) {
                    i = 0;
                }
            }
            catch (NumberFormatException e) {
                i = 0;
            }
        }
        i = Math.min(Math.max(i, min), max);
        return i;
    }

    private int getMaxEntries() {
        if (this.maxEntries < 0) {
            this.maxEntries = this.getProperty(this.transformerConfig, this.getPropertyName(), 0, this.getUpperMaxEntries());
        }
        return this.maxEntries;
    }

    public boolean isDebugEnabled() {
        return this.getMaxEntries() > 0 && this.transformerDebug.getStringBuilder() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            Deque<T> deque = this.entries;
            synchronized (deque) {
                this.addOrModify(this.entries, message);
                for (int size = this.entries.size(); size > this.maxEntries; --size) {
                    this.remove(this.entries);
                }
            }
        }
    }

    protected abstract void addOrModify(Deque<T> var1, Object var2);

    protected void remove(Deque<T> entries) {
        entries.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEntries(int n) {
        if (this.getMaxEntries() > 0) {
            n = n <= 0 ? Integer.MAX_VALUE : n;
            Deque<T> deque = this.entries;
            synchronized (deque) {
                n = Math.min(Math.max(Math.min(this.maxEntries, n), 0), this.entries.size());
                String[] array = new String[n];
                Iterator<T> iterator = this.entries.descendingIterator();
                for (int i = 0; i < n; ++i) {
                    array[i] = iterator.next().toString();
                }
                return array;
            }
        }
        return new String[]{"No entries are available. " + this.getPropertyName() + " must be set to a number between 1 and " + this.getUpperMaxEntries()};
    }

    public String getPropertyAndValue(Properties defaultProperties) {
        this.getMaxEntries();
        String value = Integer.toString(this.maxEntries);
        String propertyName = this.getPropertyName();
        String defaultValue = defaultProperties == null ? null : defaultProperties.getProperty(propertyName);
        defaultValue = defaultValue == null ? "0" : defaultValue;
        StringBuilder sb = new StringBuilder();
        boolean isDefaultValue = value.equals(defaultValue);
        if (isDefaultValue) {
            sb.append("# ");
        }
        sb.append(propertyName);
        sb.append('=');
        sb.append(value);
        if (!isDefaultValue) {
            sb.append("  # default=");
            sb.append(defaultValue);
        }
        return sb.toString();
    }

    protected abstract int getUpperMaxEntries();

    protected abstract String getPropertyName();
}

