/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransformerProperties {
    private static final String TRANSFORMERS_PROPERTIES = "alfresco/subsystems/Transformers/default/transformers.properties";
    private static Log logger = LogFactory.getLog(TransformerProperties.class);
    private final ChildApplicationContextFactory subsystem;
    private final Properties globalProperties;

    TransformerProperties(ChildApplicationContextFactory subsystem, Properties globalProperties) {
        this.subsystem = subsystem;
        this.globalProperties = globalProperties;
    }

    public String getProperty(String name) {
        String value = this.subsystem.getProperty(name);
        if (value == null) {
            value = this.globalProperties.getProperty(name);
        }
        return value;
    }

    public Properties getDefaultProperties() {
        Properties defaultProperties = new Properties();
        InputStream propertiesStream = this.getClass().getClassLoader().getResourceAsStream(TRANSFORMERS_PROPERTIES);
        if (propertiesStream != null) {
            try {
                defaultProperties.load(propertiesStream);
            }
            catch (IOException e) {
                logger.error((Object)"Could not read alfresco/subsystems/Transformers/default/transformers.properties so all properties will appear to be overridden by the customer", (Throwable)e);
            }
        } else {
            logger.error((Object)"Could not find alfresco/subsystems/Transformers/default/transformers.properties so all properties will appear to be overridden by the customer");
        }
        return defaultProperties;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>(this.subsystem.getPropertyNames());
        for (String name : this.globalProperties.stringPropertyNames()) {
            if (!name.startsWith("content.transformer.") || propertyNames.contains(name)) continue;
            propertyNames.add(name);
        }
        return propertyNames;
    }

    public void setProperties(Map<String, String> map) {
        this.subsystem.setProperties(map);
    }

    public void removeProperties(Collection<String> propertyNames) {
        this.subsystem.removeProperties(propertyNames);
    }
}

