/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerDebugLog;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerPropertyNameExtractor;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixKey;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerPropertyGetter {
    private final String string;

    public TransformerPropertyGetter(boolean changesOnly, TransformerProperties transformerProperties, MimetypeService mimetypeService, ContentTransformerRegistry transformerRegistry, TransformerLog transformerLog, TransformerDebugLog transformerDebugLog) {
        List<ContentTransformer> availableTransformers = transformerRegistry.getTransformers();
        StringBuilder sb = new StringBuilder();
        this.appendLoggerSetting(sb, changesOnly, transformerLog, transformerDebugLog, transformerProperties);
        HashSet<String> alreadySpecified = new HashSet<String>();
        this.appendConfiguredTransformerSettings(sb, changesOnly, transformerProperties, mimetypeService, availableTransformers, transformerRegistry, true, alreadySpecified, "# Default transformer settings\n# ============================\n");
        this.appendConfiguredTransformerSettings(sb, changesOnly, transformerProperties, mimetypeService, availableTransformers, transformerRegistry, false, alreadySpecified, "# Transformers with configuration settings\n# ========================================\n# Commented out settings are hard coded values for information purposes\n");
        if (!changesOnly) {
            this.appendUnconfiguredTransformerSettings(sb, mimetypeService, alreadySpecified, availableTransformers, transformerRegistry);
        }
        if (sb.length() == 0) {
            sb.append(changesOnly ? "No custom transformer properties defined" : "No transformer properties defined");
        }
        this.string = sb.toString();
    }

    private void appendLoggerSetting(StringBuilder sb, boolean changesOnly, TransformerLog transformerLog, TransformerDebugLog transformerDebugLog, TransformerProperties transformerProperties) {
        boolean debugEntriesChanged;
        Properties defaultProperties = transformerProperties.getDefaultProperties();
        String logEntries = transformerLog.getPropertyAndValue(defaultProperties);
        String debugEntries = transformerDebugLog.getPropertyAndValue(defaultProperties);
        boolean logEntriesChanged = !logEntries.startsWith("#");
        boolean bl = debugEntriesChanged = !debugEntries.startsWith("#");
        if (!changesOnly || logEntriesChanged || debugEntriesChanged) {
            sb.append("# LOG and DEBUG history sizes\n");
            sb.append("# ===========================\n");
            sb.append("# Use small values as these logs are held in memory. 0 to disable.\n");
            if (!changesOnly || logEntriesChanged) {
                sb.append(logEntries);
                sb.append("\n");
            }
            if (!changesOnly || debugEntriesChanged) {
                sb.append(debugEntries);
                sb.append("\n");
            }
        }
    }

    private void appendConfiguredTransformerSettings(final StringBuilder sb, final boolean changesOnly, TransformerProperties transformerProperties, MimetypeService mimetypeService, final List<ContentTransformer> availableTransformers, final ContentTransformerRegistry transformerRegistry, final boolean defaultTransformer, final Set<String> alreadySpecified, final String header) {
        final StringBuilder prefix = new StringBuilder();
        final StringBuilder general = new StringBuilder();
        final StringBuilder mimetypes = new StringBuilder();
        final AtomicInteger start = new AtomicInteger(-1);
        final AtomicReference currentName = new AtomicReference();
        final Properties defaultProperties = transformerProperties.getDefaultProperties();
        new TransformerPropertyNameExtractor(){

            @Override
            protected void handleProperty(String name, String separator, String firstExpression, String secondExpression, String suffix, String use, String value, String propertyName, Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues, MimetypeService mimetypeService) {
                if (defaultTransformer == "transformer.default".equals(name)) {
                    String defaultValue = defaultProperties == null ? null : defaultProperties.getProperty(propertyName);
                    boolean isDefaultValue = value.equals(defaultValue);
                    if (!changesOnly || !isDefaultValue) {
                        StringBuilder tmp;
                        String prevName = currentName.getAndSet(name);
                        if (prevName != null && !prevName.equals(name)) {
                            TransformerPropertyGetter.this.appendTransformerSettings(sb, start, prevName, prefix, general, mimetypes, mimetypeService, alreadySpecified, availableTransformers, transformerRegistry, defaultTransformer, header);
                        }
                        StringBuilder stringBuilder = separator != null ? mimetypes : (tmp = ".pipeline".equals(suffix) ? prefix : general);
                        if (isDefaultValue) {
                            tmp.append("# ");
                        }
                        tmp.append(propertyName);
                        tmp.append('=');
                        tmp.append(value);
                        if (!isDefaultValue && defaultValue != null) {
                            tmp.append("  # default=");
                            tmp.append(defaultValue);
                        }
                        tmp.append("\n");
                    }
                }
            }
        }.getTransformerSourceTargetValues(TransformerConfig.ALL_SUFFIXES, true, true, transformerProperties, mimetypeService);
        String currName = (String)currentName.get();
        if (currName != null && defaultTransformer == "transformer.default".equals(currName)) {
            this.appendTransformerSettings(sb, start, currName, prefix, general, mimetypes, mimetypeService, alreadySpecified, availableTransformers, transformerRegistry, defaultTransformer, header);
        }
    }

    private void appendTransformerSettings(StringBuilder sb, AtomicInteger start, String transformerName, StringBuilder prefix, StringBuilder general, StringBuilder mimetypes, MimetypeService mimetypeService, Set<String> alreadySpecified, List<ContentTransformer> availableTransformers, ContentTransformerRegistry transformerRegistry, boolean defaultTransformer, String header) {
        if (start.get() == -1) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(header);
            start.set(sb.length());
        }
        if (!defaultTransformer) {
            alreadySpecified.add(transformerName);
            prefix.insert(0, '\n');
            try {
                ContentTransformer transformer = transformerRegistry.getTransformer(transformerName);
                boolean available = availableTransformers.contains(transformer);
                prefix.insert(1, transformer.getComments(available));
            }
            catch (IllegalArgumentException e) {
                if (transformerName.startsWith("transformer.")) {
                    transformerName = transformerName.substring("transformer.".length());
                }
                prefix.insert(1, ContentTransformerHelper.getCommentName(transformerName) + "# Unregistered transformer\n");
                Object transformer = null;
            }
            sb.append(prefix.toString());
        }
        sb.append(general.toString());
        sb.append(mimetypes.toString());
        prefix.setLength(0);
        general.setLength(0);
        mimetypes.setLength(0);
    }

    private void appendUnconfiguredTransformerSettings(StringBuilder sb, MimetypeService mimetypeService, Set<String> alreadySpecified, List<ContentTransformer> availableTransformers, ContentTransformerRegistry transformerRegistry) {
        boolean first = true;
        for (ContentTransformer transformer : transformerRegistry.getAllTransformers()) {
            String name = transformer.getName();
            if (alreadySpecified.contains(name)) continue;
            if (first) {
                sb.append("\n");
                sb.append("# Transformers without extra configuration settings\n");
                sb.append("# =================================================\n\n");
                first = false;
            } else {
                sb.append('\n');
            }
            boolean available = availableTransformers.contains(transformer);
            sb.append(transformer.getComments(available));
        }
    }

    public String toString() {
        return this.string;
    }
}

