/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.content.transform.TransformerConfig;
import org.alfresco.repo.content.transform.TransformerProperties;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixKey;
import org.alfresco.repo.content.transform.TransformerSourceTargetSuffixValue;
import org.alfresco.service.cmr.repository.MimetypeService;

public abstract class TransformerPropertyNameExtractor {
    private static Pattern EXTENSIONS_SEPARATOR = Pattern.compile("[^]\\\\]\\.");
    private static String[] NO_EXT_MATCH = new String[0];

    protected Collection<TransformerSourceTargetSuffixValue> getTransformerSourceTargetValues(Collection<String> suffixes, boolean includeSummary, boolean includeUse, TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        return new ArrayList<TransformerSourceTargetSuffixValue>(this.getTransformerSourceTargetValuesMap(suffixes, includeSummary, true, includeUse, transformerProperties, mimetypeService).values());
    }

    protected Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> getTransformerSourceTargetValuesMap(Collection<String> suffixes, boolean includeSummary, boolean includeExtensions, boolean includeUse, TransformerProperties transformerProperties, MimetypeService mimetypeService) {
        HashMap<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues = new HashMap<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue>();
        ArrayList<String> propertyNames = new ArrayList<String>(transformerProperties.getPropertyNames());
        Collections.sort(propertyNames);
        block0: for (String propertyName : propertyNames) {
            int i;
            if (!propertyName.startsWith("content.transformer.")) continue;
            String use = null;
            String propertyNameWithoutUse = propertyName;
            if (includeUse && (i = propertyName.lastIndexOf(".use.")) != -1) {
                int j = i + ".use.".length();
                if (propertyName.length() - j > 0) {
                    use = propertyName.substring(j);
                    propertyNameWithoutUse = propertyName.substring(0, i);
                }
            }
            for (String suffix : suffixes) {
                if (!propertyNameWithoutUse.endsWith(suffix)) continue;
                String value = transformerProperties.getProperty(propertyName);
                String transformerName = propertyNameWithoutUse.substring("content.".length(), propertyNameWithoutUse.length() - suffix.length());
                boolean separatorMatch = false;
                for (String separator : TransformerConfig.SEPARATORS) {
                    String extensions;
                    String[] ext;
                    int i2 = transformerName.lastIndexOf(separator);
                    if (i2 == -1) continue;
                    separatorMatch = true;
                    if (!includeExtensions || (ext = this.splitExt(extensions = transformerName.substring(i2 + separator.length()))).length != 2) continue;
                    transformerName = transformerName.substring(0, i2);
                    String firstExpression = ext[0];
                    String secondExpression = ext[1];
                    this.handleProperty(transformerName, separator, firstExpression, secondExpression, suffix, use, value, propertyName, transformerSourceTargetSuffixValues, mimetypeService);
                    continue block0;
                }
                if (separatorMatch || !includeSummary) continue;
                this.handleProperty(transformerName, null, null, null, suffix, use, value, propertyName, transformerSourceTargetSuffixValues, mimetypeService);
                continue block0;
            }
        }
        return transformerSourceTargetSuffixValues;
    }

    protected void handleProperty(String transformerName, String separator, String firstExpression, String secondExpression, String suffix, String use, String value, String propertyName, Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues, MimetypeService mimetypeService) {
        if (separator == null) {
            this.addTransformerSourceTargetValue(transformerSourceTargetSuffixValues, false, transformerName, "*", "*", suffix, use, value, mimetypeService);
        } else {
            List<String> sourceExtensions = separator == ".extensions." ? this.getMatchingExtensionsFromExtensions(firstExpression, mimetypeService) : this.getMatchingExtensionsFromMimetypes(firstExpression, mimetypeService);
            List<String> targetExtensions = separator == ".extensions." ? this.getMatchingExtensionsFromExtensions(secondExpression, mimetypeService) : this.getMatchingExtensionsFromMimetypes(secondExpression, mimetypeService);
            for (String sourceExt : sourceExtensions) {
                for (String targetExt : targetExtensions) {
                    this.addTransformerSourceTargetValue(transformerSourceTargetSuffixValues, separator == ".mimetypes.", transformerName, sourceExt, targetExt, suffix, use, value, mimetypeService);
                }
            }
        }
    }

    private void addTransformerSourceTargetValue(Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues, boolean mimetypeProperty, String transformerName, String sourceExt, String targetExt, String suffix, String use, String value, MimetypeService mimetypeService) {
        TransformerSourceTargetSuffixValue transformerSourceTargetSuffixValue = new TransformerSourceTargetSuffixValue(transformerName, sourceExt, targetExt, suffix, use, value, mimetypeService);
        TransformerSourceTargetSuffixKey key = transformerSourceTargetSuffixValue.key();
        if (mimetypeProperty || !transformerSourceTargetSuffixValues.containsKey(key)) {
            transformerSourceTargetSuffixValues.put(key, transformerSourceTargetSuffixValue);
        }
    }

    String[] splitExt(String extensions) {
        String[] ext = NO_EXT_MATCH;
        Matcher matcher = EXTENSIONS_SEPARATOR.matcher(extensions);
        if (matcher.find()) {
            int i = matcher.start();
            ext = new String[]{extensions.substring(0, i + 1).replaceAll("\\\\\\.", "."), extensions.substring(i + 2).replaceAll("\\\\\\.", ".")};
        }
        return ext;
    }

    Pattern pattern(String expression) {
        String regex = Pattern.quote(expression).replaceAll("\\*", "\\\\E.*\\\\Q");
        return Pattern.compile(regex);
    }

    List<String> getMatchingExtensionsFromMimetypes(String expression, MimetypeService mimetypeService) {
        if ("*".equals(expression)) {
            return Collections.singletonList("*");
        }
        Pattern pattern = this.pattern(expression);
        ArrayList<String> matchingMimetypes = new ArrayList<String>(1);
        for (String mimetype : mimetypeService.getMimetypes()) {
            if (!pattern.matcher(mimetype).matches()) continue;
            String ext = mimetypeService.getExtension(mimetype);
            matchingMimetypes.add(ext);
        }
        return matchingMimetypes;
    }

    List<String> getMatchingExtensionsFromExtensions(String expression, MimetypeService mimetypeService) {
        if ("*".equals(expression)) {
            return Collections.singletonList("*");
        }
        Pattern pattern = this.pattern(expression);
        ArrayList<String> matchingMimetypes = new ArrayList<String>(1);
        for (String mimetype : mimetypeService.getMimetypes()) {
            String ext = mimetypeService.getExtension(mimetype);
            if (!pattern.matcher(ext).matches()) continue;
            matchingMimetypes.add(ext);
        }
        return matchingMimetypes;
    }

    protected String getProperty(String transformerName, String sourceExt, String targetExt, String suffix, String use, Map<TransformerSourceTargetSuffixKey, TransformerSourceTargetSuffixValue> transformerSourceTargetSuffixValues) {
        TransformerSourceTargetSuffixKey key = new TransformerSourceTargetSuffixKey(transformerName, sourceExt == null ? "*" : sourceExt, targetExt == null ? "*" : targetExt, suffix, use);
        TransformerSourceTargetSuffixValue value = transformerSourceTargetSuffixValues.get(key);
        return value == null ? null : value.value;
    }
}

