/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.TransformerSelector;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class TransformerSelectorImplOriginal
implements TransformerSelector {
    private ContentTransformerRegistry contentTransformerRegistry;

    public void setContentTransformerRegistry(ContentTransformerRegistry contentTransformerRegistry) {
        this.contentTransformerRegistry = contentTransformerRegistry;
    }

    @Override
    public List<ContentTransformer> selectTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.contentTransformerRegistry.getTransformers();
        transformers = this.findTransformers(transformers, sourceMimetype, sourceSize, targetMimetype, options);
        transformers = this.discardNonExplicitTransformers(transformers, sourceMimetype, sourceSize, targetMimetype, options);
        transformers = this.sortTransformers(transformers, sourceMimetype, sourceSize, targetMimetype, options);
        return transformers;
    }

    private List<ContentTransformer> findTransformers(List<ContentTransformer> allTransformers, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(2);
        for (ContentTransformer transformer : allTransformers) {
            if (!transformer.isTransformable(sourceMimetype, sourceSize, targetMimetype, options)) continue;
            transformers.add(transformer);
        }
        return transformers;
    }

    private List<ContentTransformer> discardNonExplicitTransformers(List<ContentTransformer> allTransformers, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(2);
        boolean foundExplicit = false;
        for (ContentTransformer transformer : allTransformers) {
            if (transformer.isExplicitTransformation(sourceMimetype, targetMimetype, options)) {
                if (!foundExplicit) {
                    transformers.clear();
                    foundExplicit = true;
                }
                transformers.add(transformer);
                continue;
            }
            if (foundExplicit) continue;
            transformers.add(transformer);
        }
        return transformers;
    }

    private List<ContentTransformer> sortTransformers(List<ContentTransformer> transformers, String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        final HashMap<ContentTransformer, Long> activeTransformers = new HashMap<ContentTransformer, Long>();
        for (ContentTransformer transformer : transformers) {
            long transformationTime = transformer.getTransformationTime(sourceMimetype, targetMimetype);
            activeTransformers.put(transformer, transformationTime);
        }
        ArrayList<ContentTransformer> sorted = new ArrayList<ContentTransformer>(activeTransformers.keySet());
        Collections.sort(sorted, new Comparator<ContentTransformer>(){

            @Override
            public int compare(ContentTransformer a, ContentTransformer b) {
                return ((Long)activeTransformers.get(a)).compareTo((Long)activeTransformers.get(b));
            }
        });
        return sorted;
    }
}

