/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerStatistics;
import org.alfresco.service.cmr.repository.MimetypeService;

public class TransformerStatisticsImpl
implements TransformerStatistics {
    private final MimetypeService mimetypeService;
    private final String sourceMimetype;
    private final String targetMimetype;
    private final ContentTransformer transformer;
    private final TransformerStatistics parent;
    private final long errorTime;
    private double averageTime;
    private long count = 0L;
    private long errorCount = 0L;

    public TransformerStatisticsImpl(MimetypeService mimetypeService, String sourceMimetype, String targetMimetype, ContentTransformer transformer, TransformerStatistics parent, long errorTime, long initialAverageTime, long initialCount) {
        this.mimetypeService = mimetypeService;
        this.sourceMimetype = sourceMimetype;
        this.targetMimetype = targetMimetype;
        this.transformer = transformer;
        this.parent = parent;
        this.errorTime = errorTime;
        this.averageTime = initialAverageTime;
        this.count = initialCount;
    }

    @Override
    public String getSourceExt() {
        return "*".equals(this.sourceMimetype) ? "*" : this.mimetypeService.getExtension(this.sourceMimetype);
    }

    @Override
    public String getTargetExt() {
        return "*".equals(this.targetMimetype) ? "*" : this.mimetypeService.getExtension(this.targetMimetype);
    }

    @Override
    public String getTransformerName() {
        return this.transformer == null ? "SUMMARY" : this.transformer.getName();
    }

    @Override
    public synchronized void recordTime(long transformationTime) {
        if (this.count == Long.MAX_VALUE) {
            this.count /= 2L;
        }
        ++this.count;
        double diffTime = (double)transformationTime - this.averageTime;
        this.averageTime += diffTime / (double)this.count;
        if (this.parent != null) {
            this.parent.recordTime(transformationTime);
        }
    }

    @Override
    public synchronized void recordError(long transformationTime) {
        if (this.errorCount < Long.MAX_VALUE) {
            ++this.errorCount;
        }
        this.recordTime(this.parent == null || this.transformer == null || this.errorTime <= 0L ? transformationTime : this.errorTime);
        if (this.parent != null) {
            this.parent.recordError(transformationTime);
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public long getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    @Override
    public long getAverageTime() {
        return (long)this.averageTime;
    }

    @Override
    public void setAverageTime(long averageTime) {
        this.averageTime = averageTime;
    }

    @Override
    public boolean isSummary() {
        return "*".equals(this.sourceMimetype) && "*".equals(this.targetMimetype);
    }
}

