/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.deployment.DeploymentReceiverService;
import org.alfresco.deployment.DeploymentReceiverTransport;
import org.alfresco.deployment.DeploymentToken;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.repo.deploy.DeploymentClientOutputStream;

public class DeploymentReceiverServiceClient
implements DeploymentReceiverService {
    private DeploymentReceiverTransport fTransport;

    public void setDeploymentReceiverTransport(DeploymentReceiverTransport transport) {
        this.fTransport = transport;
    }

    public void abort(String ticket) {
        this.fTransport.abort(ticket);
    }

    public DeploymentToken begin(String target, String storeName, int version, String user, char[] password) {
        return this.fTransport.begin(target, storeName, version, user, password);
    }

    public void prepare(String ticket) {
        this.fTransport.prepare(ticket);
    }

    public void commit(String ticket) {
        this.fTransport.commit(ticket);
    }

    public void delete(String ticket, String path) {
        this.fTransport.delete(ticket, path);
    }

    public void finishSend(String ticket, OutputStream out) {
        DeploymentClientOutputStream dcOut = (DeploymentClientOutputStream)out;
        this.fTransport.finishSend(dcOut.getTicket(), dcOut.getOutputToken());
    }

    public List<FileDescriptor> getListing(String ticket, String path) {
        return this.fTransport.getListing(ticket, path);
    }

    public void createDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> properties) {
        this.fTransport.createDirectory(ticket, path, guid, aspects, properties);
    }

    public OutputStream send(String ticket, boolean create, String path, String guid, String encoding, String mimeType, Set<String> aspects, Map<String, Serializable> props) {
        String outputToken = this.fTransport.getSendToken(ticket, create, path, guid, encoding, mimeType, aspects, props);
        return new DeploymentClientOutputStream(this.fTransport, ticket, outputToken);
    }

    public void shutDown(String user, char[] password) {
        this.fTransport.shutDown(user, password);
    }

    public void updateDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> props) {
        this.fTransport.updateDirectory(ticket, path, guid, aspects, props);
    }
}

