/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.discussion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.EmptyCannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.discussion.PostInfoImpl;
import org.alfresco.repo.discussion.TopicInfoImpl;
import org.alfresco.repo.discussion.cannedqueries.GetDiscussionTopcisWithPostsCannedQuery;
import org.alfresco.repo.discussion.cannedqueries.GetDiscussionTopcisWithPostsCannedQueryFactory;
import org.alfresco.repo.discussion.cannedqueries.NodeWithChildrenEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQueryFactory;
import org.alfresco.repo.node.getchildren.GetChildrenWithTargetAssocsAuditableCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenWithTargetAssocsAuditableCannedQueryFactory;
import org.alfresco.repo.query.NodeBackedEntity;
import org.alfresco.repo.query.NodeWithTargetsEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.discussion.DiscussionService;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.PostWithReplies;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscussionServiceImpl
implements DiscussionService {
    public static final String DISCUSSION_COMPONENT = "discussions";
    protected static final String CANNED_QUERY_GET_CHILDREN = "discussionGetChildrenCannedQueryFactory";
    protected static final String CANNED_QUERY_GET_CHILDREN_TARGETS = "discussionGetChildrenWithTargetAssocsAuditableCannedQueryFactory";
    protected static final String CANNED_QUERY_GET_TOPICS_WITH_POSTS = "discussionGetDiscussionTopcisWithPostsCannedQueryFactory";
    protected static final int MAX_REPLIES_FETCH_SIZE = 1000;
    private static Log logger = LogFactory.getLog(DiscussionServiceImpl.class);
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private SiteService siteService;
    private SearchService searchService;
    private ContentService contentService;
    private TaggingService taggingService;
    private NamespaceService namespaceService;
    private TransactionService transactionService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;
    private TenantService tenantService;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    protected NodeRef getSiteDiscussionsContainer(String siteShortName, boolean create) {
        return SiteServiceImpl.getSiteContainer(siteShortName, DISCUSSION_COMPONENT, create, this.siteService, this.transactionService, this.taggingService);
    }

    private String generateName() {
        String name = "post-" + new Date().getTime() + "_" + Math.round(Math.random() * 10000.0);
        return name;
    }

    private TopicInfo buildTopic(NodeRef nodeRef, NodeRef container, String name) {
        PostInfo primaryPost;
        TopicInfoImpl topic = new TopicInfoImpl(nodeRef, container, name);
        Map props = this.nodeService.getProperties(nodeRef);
        topic.setCreator((String)props.get(ContentModel.PROP_CREATOR));
        topic.setModifier((String)props.get(ContentModel.PROP_MODIFIER));
        topic.setCreatedAt((Date)props.get(ContentModel.PROP_CREATED));
        topic.setModifiedAt((Date)props.get(ContentModel.PROP_MODIFIED));
        String title = (String)props.get(ContentModel.PROP_TITLE);
        if (title == null && (primaryPost = this.getPrimaryPost(topic)) != null) {
            title = primaryPost.getTitle();
        }
        topic.setTitle(title);
        topic.setTags(this.taggingService.getTags(nodeRef));
        return topic;
    }

    private PostInfo buildPost(NodeRef nodeRef, TopicInfo topic, String name, String preLoadedContents) {
        ContentReader reader;
        PostInfoImpl post = new PostInfoImpl(nodeRef, name, topic);
        Map props = this.nodeService.getProperties(nodeRef);
        post.setCreator((String)props.get(ContentModel.PROP_CREATOR));
        post.setModifier((String)props.get(ContentModel.PROP_MODIFIER));
        post.setCreatedAt((Date)props.get(ContentModel.PROP_CREATED));
        post.setModifiedAt((Date)props.get(ContentModel.PROP_MODIFIED));
        post.setUpdatedAt((Date)props.get(ContentModel.PROP_UPDATED));
        post.setTitle((String)props.get(ContentModel.PROP_TITLE));
        String contents = preLoadedContents;
        if (contents == null && (reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT)) != null) {
            contents = reader.getContentString();
        }
        post.setContents(contents);
        return post;
    }

    @Override
    public TopicInfo getTopic(String siteShortName, String topicName) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return null;
        }
        return this.getTopic(container, topicName);
    }

    @Override
    public TopicInfo getTopic(NodeRef parentNodeRef, String topicName) {
        NodeRef topic = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, topicName);
        if (topic != null) {
            return this.buildTopic(topic, parentNodeRef, topicName);
        }
        return null;
    }

    @Override
    public PostInfo getPost(TopicInfo topic, String postName) {
        if (topic.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't get posts for a topic that was never persisted!");
        }
        NodeRef post = this.nodeService.getChildByName(topic.getNodeRef(), ContentModel.ASSOC_CONTAINS, postName);
        if (post != null) {
            return this.buildPost(post, topic, postName, null);
        }
        return null;
    }

    @Override
    public TopicInfo createTopic(String siteShortName, String title) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, true);
        return this.createTopic(container, title);
    }

    @Override
    public TopicInfo createTopic(final NodeRef parentNodeRef, String title) {
        String name = this.generateName();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_TITLE, title);
        NodeRef nodeRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ForumModel.TYPE_TOPIC, props).getChildRef();
        if (!this.taggingService.isTagScope(parentNodeRef)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    DiscussionServiceImpl.this.taggingService.addTagScope(parentNodeRef);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        return this.buildTopic(nodeRef, parentNodeRef, name);
    }

    @Override
    public PostInfo createPost(TopicInfo topic, String contents) {
        if (topic.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't create posts for a topic that was never persisted!");
        }
        boolean isPrimary = false;
        if (this.getPrimaryPost(topic) == null) {
            isPrimary = true;
        }
        String name = this.generateName();
        if (isPrimary) {
            name = topic.getSystemName();
        }
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_NAME, name);
        props.put(ContentModel.PROP_PUBLISHED, new Date());
        if (isPrimary) {
            props.put(ContentModel.PROP_TITLE, topic.getTitle());
        }
        NodeRef nodeRef = this.nodeService.createNode(topic.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), ForumModel.TYPE_POST, props).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/html");
        writer.putContent(contents);
        return this.buildPost(nodeRef, topic, name, contents);
    }

    @Override
    public PostInfo createReply(PostInfo parentPost, String contents) {
        if (parentPost.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't reply to a post that was never persisted");
        }
        if (parentPost.getTopic() == null) {
            throw new IllegalArgumentException("Can't reply to a post with no attached topic");
        }
        PostInfo reply = this.createPost(parentPost.getTopic(), contents);
        this.nodeService.createAssociation(reply.getNodeRef(), parentPost.getNodeRef(), ContentModel.ASSOC_REFERENCES);
        return reply;
    }

    @Override
    public TopicInfo updateTopic(TopicInfo topic) {
        if (topic.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a topic that was never persisted, call create instead");
        }
        NodeRef nodeRef = topic.getNodeRef();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)topic.getTitle()));
        this.taggingService.setTags(nodeRef, topic.getTags());
        return topic;
    }

    @Override
    public PostInfo updatePost(PostInfo post) {
        if (post.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a post that was never persisted, call create instead");
        }
        NodeRef nodeRef = post.getNodeRef();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)post.getTitle()));
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent(post.getContents());
        Date updatedAt = new Date();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_UPDATED, (Serializable)updatedAt);
        if (post instanceof PostInfoImpl) {
            ((PostInfoImpl)post).setUpdatedAt(updatedAt);
            ((PostInfoImpl)post).setModifiedAt(updatedAt);
        } else {
            post = this.buildPost(nodeRef, post.getTopic(), post.getSystemName(), post.getContents());
        }
        return post;
    }

    @Override
    public void deleteTopic(TopicInfo topic) {
        if (topic.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a topic that was never persisted");
        }
        this.nodeService.deleteNode(topic.getNodeRef());
    }

    @Override
    public void deletePost(PostInfo post) {
        if (post.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a post that was never persisted");
        }
        this.nodeService.deleteNode(post.getNodeRef());
    }

    @Override
    public Pair<TopicInfo, PostInfo> getForNodeRef(NodeRef nodeRef) {
        QName type = this.nodeService.getType(nodeRef);
        TopicInfo topic = null;
        PostInfo post = null;
        if (type.equals((Object)ForumModel.TYPE_TOPIC)) {
            ChildAssociationRef ref = this.nodeService.getPrimaryParent(nodeRef);
            String topicName = ref.getQName().getLocalName();
            topic = this.getTopic(ref.getParentRef(), topicName);
        } else if (type.equals((Object)ForumModel.TYPE_POST)) {
            ChildAssociationRef toTopic = this.nodeService.getPrimaryParent(nodeRef);
            String postName = toTopic.getQName().getLocalName();
            NodeRef topicNodeRef = toTopic.getParentRef();
            ChildAssociationRef toParent = this.nodeService.getPrimaryParent(topicNodeRef);
            String topicName = toParent.getQName().getLocalName();
            topic = this.getTopic(toParent.getParentRef(), topicName);
            post = this.getPost(topic, postName);
        } else {
            logger.debug((Object)("Invalid type " + type + " found"));
            return null;
        }
        return new Pair((Object)topic, post);
    }

    @Override
    public PostInfo getPrimaryPost(TopicInfo topic) {
        PostInfo post = this.getPost(topic, topic.getSystemName());
        if (post != null) {
            return post;
        }
        List children = this.nodeService.getChildAssocs(topic.getNodeRef());
        if (children.size() == 0) {
            return null;
        }
        NodeRef postNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
        String postName = ((ChildAssociationRef)children.get(0)).getQName().getLocalName();
        return this.buildPost(postNodeRef, topic, postName, null);
    }

    @Override
    public PostInfo getMostRecentPost(TopicInfo topic) {
        PagingRequest paging = new PagingRequest(0, 1);
        CannedQueryResults<NodeBackedEntity> results = this.listEntries(topic.getNodeRef(), ForumModel.TYPE_POST, null, null, null, false, paging);
        if (results.getPage().size() == 0) {
            return null;
        }
        NodeBackedEntity node = (NodeBackedEntity)results.getPage().get(0);
        return this.buildPost(this.tenantService.getBaseName(node.getNodeRef()), topic, node.getName(), null);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(String siteShortName, boolean sortAscending, PagingRequest paging) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listTopics(container, sortAscending, paging);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(NodeRef nodeRef, boolean sortAscending, PagingRequest paging) {
        CannedQueryResults<NodeBackedEntity> nodes = this.listEntries(nodeRef, ForumModel.TYPE_TOPIC, null, null, null, sortAscending, paging);
        return this.wrap((PagingResults<NodeBackedEntity>)nodes, nodeRef);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(String siteShortName, String username, boolean sortAscending, PagingRequest paging) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listTopics(container, username, sortAscending, paging);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(NodeRef nodeRef, String username, boolean sortAscending, PagingRequest paging) {
        CannedQueryResults<NodeBackedEntity> nodes = this.listEntries(nodeRef, ForumModel.TYPE_TOPIC, username, null, null, sortAscending, paging);
        return this.wrap((PagingResults<NodeBackedEntity>)nodes, nodeRef);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(String siteShortName, Date from, Date to, boolean sortAscending, PagingRequest paging) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listTopics(container, from, to, sortAscending, paging);
    }

    @Override
    public PagingResults<TopicInfo> listTopics(NodeRef nodeRef, Date from, Date to, boolean sortAscending, PagingRequest paging) {
        CannedQueryResults<NodeBackedEntity> nodes = this.listEntries(nodeRef, ForumModel.TYPE_TOPIC, null, from, to, sortAscending, paging);
        return this.wrap((PagingResults<NodeBackedEntity>)nodes, nodeRef);
    }

    @Override
    public PagingResults<Pair<TopicInfo, Integer>> listHotTopics(String siteShortName, Date since, PagingRequest paging) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listHotTopics(container, since, paging);
    }

    @Override
    public PagingResults<Pair<TopicInfo, Integer>> listHotTopics(NodeRef nodeRef, Date since, PagingRequest paging) {
        GetDiscussionTopcisWithPostsCannedQueryFactory getCQFactory = (GetDiscussionTopcisWithPostsCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_TOPICS_WITH_POSTS));
        GetDiscussionTopcisWithPostsCannedQuery cq = (GetDiscussionTopcisWithPostsCannedQuery)getCQFactory.getCannedQuery(nodeRef, null, since, true, null, paging);
        CannedQueryResults results = cq.execute();
        return this.wrapWithCount((PagingResults<NodeWithChildrenEntity>)results, nodeRef);
    }

    @Override
    public PagingResults<TopicInfo> findTopics(String siteShortName, String username, String tag, boolean sortAscending, PagingRequest paging) {
        NodeRef container = this.getSiteDiscussionsContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.findTopics(container, username, tag, sortAscending, paging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagingResults<TopicInfo> findTopics(NodeRef nodeRef, String username, String tag, boolean sortAscending, PagingRequest paging) {
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append(" +TYPE:\"" + ForumModel.TYPE_TOPIC + "\"");
        luceneQuery.append(" +PATH:\"" + this.nodeService.getPath(nodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService) + "/*\"");
        if (username != null) {
            luceneQuery.append(" +@cm\\:creator:\"" + username + "\"");
        }
        if (tag != null) {
            luceneQuery.append(" +PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
        }
        String sortOn = "@{http://www.alfresco.org/model/content/1.0}created";
        SearchParameters sp = new SearchParameters();
        sp.addStore(nodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(luceneQuery.toString());
        sp.addSort(sortOn, sortAscending);
        if (paging.getMaxItems() > 0) {
            sp.setLimit(paging.getMaxItems());
            sp.setLimitBy(LimitBy.FINAL_SIZE);
        }
        if (paging.getSkipCount() > 0) {
            sp.setSkipCount(paging.getSkipCount());
        }
        PagingResults<TopicInfo> pagedResults = new PagingResults<TopicInfo>();
        try (ResultSet results = null;){
            results = this.searchService.query(sp);
            pagedResults = this.wrap(results, nodeRef);
        }
        return pagedResults;
    }

    @Override
    public PagingResults<PostInfo> listPosts(TopicInfo topic, PagingRequest paging) {
        CannedQueryResults<NodeBackedEntity> nodes = this.listEntries(topic.getNodeRef(), ForumModel.TYPE_POST, null, null, null, true, paging);
        return this.wrap((PagingResults<NodeBackedEntity>)nodes, topic);
    }

    @Override
    public PostWithReplies listPostReplies(TopicInfo topic, int levels) {
        PostInfo primaryPost = this.getPrimaryPost(topic);
        if (primaryPost == null) {
            return null;
        }
        return this.listPostReplies(primaryPost, levels);
    }

    @Override
    public PostWithReplies listPostReplies(PostInfo primaryPost, int levels) {
        GetChildrenWithTargetAssocsAuditableCannedQueryFactory cqFactory = (GetChildrenWithTargetAssocsAuditableCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN_TARGETS));
        CannedQuerySortDetails sorting = cqFactory.createDateAscendingCQSortDetails();
        GetChildrenWithTargetAssocsAuditableCannedQuery cq = (GetChildrenWithTargetAssocsAuditableCannedQuery)cqFactory.getCannedQuery(primaryPost.getTopic().getNodeRef(), ForumModel.TYPE_POST, ContentModel.ASSOC_REFERENCES, sorting, new PagingRequest(1000));
        CannedQueryResults results = cq.execute();
        HashMap<Long, NodeRef> idToNodeRef = new HashMap<Long, NodeRef>();
        for (NodeWithTargetsEntity e : results.getPage()) {
            idToNodeRef.put(e.getId(), this.tenantService.getBaseName(e.getNodeRef()));
        }
        HashMap<NodeRef, List<NodeWithTargetsEntity>> idToReplies = new HashMap<NodeRef, List<NodeWithTargetsEntity>>();
        for (NodeWithTargetsEntity e : results.getPage()) {
            for (NodeWithTargetsEntity.TargetAndTypeId idP : e.getTargetIds()) {
                Long id = idP.getTargetId();
                NodeRef nodeRef = (NodeRef)idToNodeRef.get(id);
                if (nodeRef == null) continue;
                nodeRef = this.tenantService.getBaseName(nodeRef);
                if (id.equals(e.getId())) continue;
                if (!idToReplies.containsKey(nodeRef)) {
                    idToReplies.put(nodeRef, new ArrayList());
                }
                ((List)idToReplies.get(nodeRef)).add(e);
            }
        }
        ArrayList<NodeRef> preLoad = new ArrayList<NodeRef>();
        this.calculateRepliesPreLoad(primaryPost.getNodeRef(), preLoad, idToReplies, levels);
        this.nodeDAO.cacheNodes(preLoad);
        return this.wrap(primaryPost, idToReplies, levels);
    }

    private void calculateRepliesPreLoad(NodeRef nodeRef, List<NodeRef> preLoad, Map<NodeRef, List<NodeWithTargetsEntity>> idToReplies, int levels) {
        List<NodeWithTargetsEntity> replies;
        preLoad.add(nodeRef);
        if (levels > 0 && (replies = idToReplies.get(nodeRef)) != null && replies.size() > 0) {
            for (NodeWithTargetsEntity entity : replies) {
                this.calculateRepliesPreLoad(this.tenantService.getBaseName(entity.getNodeRef()), preLoad, idToReplies, levels - 1);
            }
        }
    }

    private PostWithReplies wrap(PostInfo post, Map<NodeRef, List<NodeWithTargetsEntity>> idToReplies, int levels) {
        List<NodeWithTargetsEntity> replyEntities;
        ArrayList<PostWithReplies> replies = new ArrayList<PostWithReplies>();
        if (levels > 0 && (replyEntities = idToReplies.get(post.getNodeRef())) != null && replyEntities.size() > 0) {
            for (NodeWithTargetsEntity entity : replyEntities) {
                PostInfo replyPost = this.buildPost(this.tenantService.getBaseName(entity.getNodeRef()), post.getTopic(), entity.getName(), null);
                replies.add(this.wrap(replyPost, idToReplies, levels - 1));
            }
        }
        return new PostWithReplies(post, replies);
    }

    private CannedQueryResults<NodeBackedEntity> listEntries(NodeRef parent, QName nodeType, String creatorUsername, Date from, Date to, boolean oldestFirst, PagingRequest paging) {
        if (paging != null && paging.getMaxItems() == 0) {
            return new EmptyCannedQueryResults(null);
        }
        GetChildrenAuditableCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenAuditableCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
        CannedQuerySortDetails sorting = null;
        sorting = oldestFirst ? getChildrenCannedQueryFactory.createDateAscendingCQSortDetails() : getChildrenCannedQueryFactory.createDateDescendingCQSortDetails();
        GetChildrenAuditableCannedQuery cq = (GetChildrenAuditableCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(parent, nodeType, creatorUsername, from, to, null, null, null, sorting, paging);
        CannedQueryResults results = cq.execute();
        return results;
    }

    private PagingResults<TopicInfo> wrap(final ResultSet finalLuceneResults, NodeRef container) {
        final ArrayList<TopicInfo> topics = new ArrayList<TopicInfo>();
        for (ResultSetRow row : finalLuceneResults) {
            TopicInfo topic = this.buildTopic(row.getNodeRef(), container, row.getQName().getLocalName());
            topics.add(topic);
        }
        return new PagingResults<TopicInfo>(){

            public boolean hasMoreItems() {
                try {
                    return finalLuceneResults.hasMore();
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                int skipCount = 0;
                int itemsRemainingAfterThisPage = 0;
                try {
                    skipCount = finalLuceneResults.getStart();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                try {
                    itemsRemainingAfterThisPage = finalLuceneResults.length();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                int totalItemsInUnpagedResultSet = skipCount + itemsRemainingAfterThisPage;
                return new Pair((Object)totalItemsInUnpagedResultSet, (Object)totalItemsInUnpagedResultSet);
            }

            public List<TopicInfo> getPage() {
                return topics;
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    private PagingResults<TopicInfo> wrap(final PagingResults<NodeBackedEntity> results, final NodeRef container) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NodeBackedEntity node : results.getPage()) {
            ids.add(node.getId());
        }
        this.nodeDAO.cacheNodesById(ids);
        return new PagingResults<TopicInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<TopicInfo> getPage() {
                ArrayList<TopicInfo> topics = new ArrayList<TopicInfo>();
                for (NodeBackedEntity node : results.getPage()) {
                    NodeRef nodeRef = node.getNodeRef();
                    String name = node.getName();
                    topics.add(DiscussionServiceImpl.this.buildTopic(nodeRef, container, name));
                }
                return topics;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }

    private PagingResults<PostInfo> wrap(final PagingResults<NodeBackedEntity> results, final TopicInfo topic) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NodeBackedEntity node : results.getPage()) {
            ids.add(node.getId());
        }
        this.nodeDAO.cacheNodesById(ids);
        return new PagingResults<PostInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<PostInfo> getPage() {
                ArrayList<PostInfo> posts = new ArrayList<PostInfo>();
                for (NodeBackedEntity node : results.getPage()) {
                    NodeRef nodeRef = node.getNodeRef();
                    String name = node.getName();
                    posts.add(DiscussionServiceImpl.this.buildPost(nodeRef, topic, name, null));
                }
                return posts;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }

    private PagingResults<Pair<TopicInfo, Integer>> wrapWithCount(final PagingResults<NodeWithChildrenEntity> results, final NodeRef container) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NodeBackedEntity node : results.getPage()) {
            ids.add(node.getId());
        }
        this.nodeDAO.cacheNodesById(ids);
        return new PagingResults<Pair<TopicInfo, Integer>>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<Pair<TopicInfo, Integer>> getPage() {
                ArrayList<Pair<TopicInfo, Integer>> topics = new ArrayList<Pair<TopicInfo, Integer>>();
                for (NodeWithChildrenEntity node : results.getPage()) {
                    NodeRef nodeRef = node.getNodeRef();
                    String name = node.getName();
                    int count = node.getChildren().size();
                    TopicInfo topic = DiscussionServiceImpl.this.buildTopic(nodeRef, container, name);
                    topics.add((Pair<TopicInfo, Integer>)new Pair((Object)topic, (Object)count));
                }
                return topics;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }
}

