/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.EqualsHelper;

public class AVMNodeEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long version;
    private Integer type;
    private String classType;
    private Long storeNewId;
    private Long aclId;
    private Long layerId;
    private String guid;
    private boolean isRoot;
    private Integer deletedType;
    private String indirection;
    private Integer indirectionVersion;
    private boolean primaryIndirection;
    private boolean opacity;
    private String contentUrl;
    private String mimetype;
    private String encoding;
    private Long length;
    private String owner;
    private String creator;
    private Long createdDate;
    private String modifier;
    private Long modifiedDate;
    private Long accessDate;
    private Long vers;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
        this.type = null;
        if (classType != null) {
            if (classType.equals("plainfile")) {
                this.type = 0;
            } else if (classType.equals("plaindirectory")) {
                this.type = 2;
            } else if (classType.equals("layeredfile")) {
                this.type = 1;
            } else if (classType.equals("layereddirectory")) {
                this.type = 3;
            } else if (classType.equals("deletednode")) {
                this.type = 4;
            } else {
                throw new AlfrescoRuntimeException("Unexpected node class_type: " + classType);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.classType = null;
        if (type != null) {
            switch (type) {
                case 0: {
                    this.classType = "plainfile";
                    break;
                }
                case 2: {
                    this.classType = "plaindirectory";
                    break;
                }
                case 1: {
                    this.classType = "layeredfile";
                    break;
                }
                case 3: {
                    this.classType = "layereddirectory";
                    break;
                }
                case 4: {
                    this.classType = "deletednode";
                    break;
                }
                default: {
                    throw new AlfrescoRuntimeException("Unexpected node type: " + type);
                }
            }
        }
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getStoreNewId() {
        return this.storeNewId;
    }

    public void setStoreNewId(Long storeNewId) {
        this.storeNewId = storeNewId;
    }

    public Long getAclId() {
        return this.aclId;
    }

    public void setAclId(Long aclId) {
        this.aclId = aclId;
    }

    public Long getLayerId() {
        return this.layerId;
    }

    public void setLayerId(Long layerId) {
        this.layerId = layerId;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(Boolean isRoot) {
        this.isRoot = isRoot == null ? false : isRoot;
    }

    public Integer getDeletedType() {
        return this.deletedType;
    }

    public void setDeletedType(Integer deletedType) {
        this.deletedType = deletedType;
    }

    public String getIndirection() {
        return this.indirection;
    }

    public void setIndirection(String indirection) {
        this.indirection = indirection;
    }

    public Integer getIndirectionVersion() {
        return this.indirectionVersion;
    }

    public void setIndirectionVersion(Integer indirectionVersion) {
        this.indirectionVersion = indirectionVersion;
    }

    public boolean isPrimaryIndirection() {
        return this.primaryIndirection;
    }

    public void setPrimaryIndirection(Boolean primaryIndirection) {
        this.primaryIndirection = primaryIndirection == null ? false : primaryIndirection;
    }

    public boolean getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Boolean opacity) {
        this.opacity = opacity == null ? false : opacity;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Long getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Long getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Long accessDate) {
        this.accessDate = accessDate;
    }

    public Long getVers() {
        return this.vers;
    }

    public void setVers(Long vers) {
        this.vers = vers;
    }

    public void incrementVers() {
        if (this.vers >= Long.MAX_VALUE) {
            this.vers = 0L;
        } else {
            AVMNodeEntity aVMNodeEntity = this;
            Long l = aVMNodeEntity.vers;
            Long l2 = aVMNodeEntity.vers = Long.valueOf(aVMNodeEntity.vers + 1L);
        }
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AVMNodeEntity) {
            AVMNodeEntity that = (AVMNodeEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.id, (Object)that.id);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AVMNodeEntity").append("[ ID=").append(this.id).append(", nextVersion=").append(this.version).append("]");
        return sb.toString();
    }
}

