/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.io.Serializable;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.util.EqualsHelper;

public class AclEntity
implements Acl,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long version;
    private String aclId;
    private boolean latest;
    private Long aclVersion;
    private boolean inherits;
    private Long inheritsFrom;
    private Integer type;
    private Long inheritedAcl;
    private boolean isVersioned;
    private boolean requiresVersion;
    private Long aclChangeSet;

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void incrementVersion() {
        if (this.version >= Long.MAX_VALUE) {
            this.version = 0L;
        } else {
            AclEntity aclEntity = this;
            Long l = aclEntity.version;
            Long l2 = aclEntity.version = Long.valueOf(aclEntity.version + 1L);
        }
    }

    @Override
    public String getAclId() {
        return this.aclId;
    }

    public void setAclId(String aclId) {
        this.aclId = aclId;
    }

    @Override
    public Boolean isLatest() {
        return this.latest;
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    @Override
    public Long getAclVersion() {
        return this.aclVersion;
    }

    public void setAclVersion(Long aclVersion) {
        this.aclVersion = aclVersion;
    }

    @Override
    public Boolean getInherits() {
        return this.inherits;
    }

    public void setInherits(boolean inherits) {
        this.inherits = inherits;
    }

    @Override
    public Long getInheritsFrom() {
        return this.inheritsFrom;
    }

    public void setInheritsFrom(Long inheritsFrom) {
        this.inheritsFrom = inheritsFrom;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public Long getInheritedAcl() {
        return this.inheritedAcl;
    }

    public void setInheritedAcl(Long inheritedAcl) {
        this.inheritedAcl = inheritedAcl;
    }

    @Override
    public Boolean isVersioned() {
        return this.isVersioned;
    }

    public void setVersioned(boolean isVersioned) {
        this.isVersioned = isVersioned;
    }

    @Override
    public Boolean getRequiresVersion() {
        return this.requiresVersion;
    }

    public void setRequiresVersion(boolean requiresVersion) {
        this.requiresVersion = requiresVersion;
    }

    @Override
    public Long getAclChangeSetId() {
        return this.aclChangeSet;
    }

    public void setAclChangeSetId(Long aclChangeSet) {
        this.aclChangeSet = aclChangeSet;
    }

    @Override
    public ACLType getAclType() {
        return ACLType.getACLTypeFromId(this.type);
    }

    public void setAclType(ACLType type) {
        this.type = type.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AclEntity) {
            AclEntity that = (AclEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.id, (Object)that.id) && EqualsHelper.nullSafeEquals((Object)this.version, (Object)that.version);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AclEntity").append("[ ID=").append(this.id).append(", version=").append(this.version).append(", aclId=").append(this.aclId).append(", isLatest=").append(this.latest).append(", aclVersion=").append(this.aclVersion).append(", inherits=").append(this.inherits).append(", inheritsFrom=").append(this.inheritsFrom).append(", type=").append(this.type).append(", inheritedAcl=").append(this.inheritedAcl).append(", isVersioned=").append(this.isVersioned).append(", requiresVersion=").append(this.requiresVersion).append(", aclChangeSet=").append(this.aclChangeSet).append("]");
        return sb.toString();
    }
}

