/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.favourites;

import java.util.Date;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.repository.NodeRef;

public class PersonFavourite {
    private String userName;
    private String title;
    private FavouritesService.Type type;
    private Date createdAt;
    private NodeRef nodeRef;

    PersonFavourite(String userName, NodeRef nodeRef, FavouritesService.Type type) {
        if (userName == null) {
            throw new IllegalArgumentException("Must provide a userName");
        }
        if (nodeRef == null) {
            throw new IllegalArgumentException("Must provide a nodeRef");
        }
        if (type == null) {
            throw new IllegalArgumentException("Must provide a type");
        }
        this.userName = userName;
        this.nodeRef = nodeRef;
        this.type = type;
    }

    public PersonFavourite(String userName, NodeRef nodeRef, FavouritesService.Type type, String title, Date createdAt) {
        if (userName == null) {
            throw new IllegalArgumentException("Must provide a userName");
        }
        if (nodeRef == null) {
            throw new IllegalArgumentException("Must provide a nodeRef");
        }
        if (type == null) {
            throw new IllegalArgumentException("Must provide a type");
        }
        if (title == null) {
            throw new IllegalArgumentException("Must provide a title");
        }
        this.userName = userName;
        this.nodeRef = nodeRef;
        this.type = type;
        this.title = title;
        this.createdAt = createdAt;
    }

    public PersonFavouriteKey getKey() {
        PersonFavouriteKey key = new PersonFavouriteKey(this.getUserName(), this.getTitle(), this.getType(), this.getNodeRef(), this.getCreatedAt());
        return key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserName() {
        return this.userName;
    }

    public FavouritesService.Type getType() {
        return this.type;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeRef == null ? 0 : this.nodeRef.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersonFavourite other = (PersonFavourite)obj;
        if (this.nodeRef == null ? other.nodeRef != null : !this.nodeRef.equals((Object)other.nodeRef)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String toString() {
        return "PersonFavourite [userName=" + this.userName + ", name=" + this.title + ", type=" + (Object)((Object)this.type) + ", createdAt=" + this.createdAt + ", nodeRef=" + this.nodeRef + "]";
    }

    public static class PersonFavouriteKey {
        private String userName;
        private FavouritesService.Type type;
        private String title;
        private NodeRef nodeRef;
        private Date createdAt;

        public PersonFavouriteKey(String userName, String title, FavouritesService.Type type, NodeRef nodeRef) {
            this.userName = userName;
            this.type = type;
            this.nodeRef = nodeRef;
        }

        public PersonFavouriteKey(String userName, String title, FavouritesService.Type type, NodeRef nodeRef, Date createdAt) {
            this.userName = userName;
            this.type = type;
            this.nodeRef = nodeRef;
            this.createdAt = createdAt;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUserName() {
            return this.userName;
        }

        public FavouritesService.Type getType() {
            return this.type;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodeRef == null ? 0 : this.nodeRef.hashCode());
            result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PersonFavouriteKey other = (PersonFavouriteKey)obj;
            if (this.nodeRef == null ? other.nodeRef != null : !this.nodeRef.equals((Object)other.nodeRef)) {
                return false;
            }
            return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
        }

        public String toString() {
            return "PersonFavouriteKey [userName=" + this.userName + ", nodeRef=" + this.nodeRef + "]";
        }
    }
}

