/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.DefaultFieldBuilder;
import org.alfresco.repo.forms.processor.workflow.ExtendedPropertyFieldProcessor;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class ExtendedFieldBuilder
extends DefaultFieldBuilder {
    private ContentModelItemData<?> data;
    private ExtendedPropertyFieldProcessor extendedPropertyFieldProcessor;

    public ExtendedFieldBuilder(FormCreationData data, FieldProcessorRegistry registry, NamespaceService namespaceService, List<String> ignoredFields, ExtendedPropertyFieldProcessor extendedPropertyFieldProcessor) {
        super(data, registry, namespaceService, ignoredFields);
        this.data = (ContentModelItemData)data.getItemData();
        this.extendedPropertyFieldProcessor = extendedPropertyFieldProcessor;
    }

    @Override
    public List<Field> buildDefaultPropertyFields() {
        return super.buildDefaultPropertyFields();
    }

    @Override
    public Field buildPropertyField(QName name) {
        if (this.extendedPropertyFieldProcessor.isApplicableForProperty(name)) {
            return this.extendedPropertyFieldProcessor.generateField(name, this.data, false);
        }
        return super.buildPropertyField(name);
    }

    public static List<String> getUnescapedValues(String escapedString) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuffer currentElement = new StringBuffer();
        boolean isEscaped = false;
        for (int i = 0; i < escapedString.length(); ++i) {
            char currentChar = escapedString.charAt(i);
            if (isEscaped) {
                isEscaped = false;
                currentElement.append(currentChar);
                continue;
            }
            if (currentChar == '\\') {
                isEscaped = true;
                continue;
            }
            if (currentChar == ',') {
                elements.add(currentElement.toString());
                currentElement.delete(0, currentElement.length());
                continue;
            }
            currentElement.append(currentChar);
        }
        if (currentElement.length() > 0) {
            elements.add(currentElement.toString());
        }
        return elements;
    }
}

