/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.importer.ExportSource;
import org.alfresco.repo.importer.ExportSourceImporterException;
import org.alfresco.repo.importer.ImporterJobSPI;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ExportSourceImporter
implements ImporterJobSPI {
    private static Log logger = LogFactory.getLog(ExportSourceImporter.class);
    private ImporterService importerService;
    private ExportSource exportSource;
    private StoreRef storeRef;
    private String path;
    private boolean clearAllChildren;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private TransactionService transactionService;
    private Set<SimpleCache> caches;
    private static ImporterBinding REPLACE_BINDING = new ImporterBinding(){

        @Override
        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return ImporterBinding.UUID_BINDING.UPDATE_EXISTING;
        }

        @Override
        public String getValue(String key) {
            return null;
        }

        @Override
        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        @Override
        public QName[] getExcludedClasses() {
            return null;
        }

        @Override
        public ImporterContentCache getImportConentCache() {
            return null;
        }
    };

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setExportSource(ExportSource exportSource) {
        this.exportSource = exportSource;
    }

    public void setClearAllChildren(boolean clearAllChildren) {
        this.clearAllChildren = clearAllChildren;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStoreRef(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCaches(Set<SimpleCache> caches) {
        this.caches = caches;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void doImport() {
        UserTransaction userTransaction = null;
        try {
            AuthenticationUtil.pushAuthentication();
            userTransaction = this.transactionService.getUserTransaction();
            userTransaction.begin();
            AuthenticationUtil.setRunAsUserSystem();
            if (this.clearAllChildren) {
                logger.debug((Object)"clear all children");
                List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), this.path, null, this.namespacePrefixResolver, false);
                for (NodeRef ref : refs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("clear node ref" + ref));
                    }
                    for (ChildAssociationRef car : this.nodeService.getChildAssocs(ref)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("delete child" + car.getChildRef()));
                        }
                        this.nodeService.deleteNode(car.getChildRef());
                    }
                }
            }
            if (this.caches != null) {
                logger.debug((Object)"clearing caches");
                for (SimpleCache cache : this.caches) {
                    cache.clear();
                }
            }
            File tempFile = TempFileProvider.createTempFile((String)"ExportSourceImporter-", (String)".xml");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
            XMLWriter xmlWriter = this.createXMLExporter(writer);
            this.exportSource.generateExport(xmlWriter);
            xmlWriter.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "UTF-8"));
            Location location = new Location(this.storeRef);
            location.setPath(this.path);
            this.importerService.importView(reader, location, REPLACE_BINDING, null);
            ((Reader)reader).close();
            if (this.caches != null) {
                for (SimpleCache cache : this.caches) {
                    cache.clear();
                }
            }
            logger.debug((Object)"about to commit");
            userTransaction.commit();
        }
        catch (Throwable t) {
            try {
                if (userTransaction != null) {
                    logger.debug((Object)"rolling back due to exception", t);
                    userTransaction.rollback();
                }
            }
            catch (Exception ex) {
                logger.debug((Object)"exception during rollback", (Throwable)ex);
            }
            throw new ExportSourceImporterException("Failed to import", t);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    private XMLWriter createXMLExporter(Writer writer) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        return xmlWriter;
    }
}

