/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.importer.FileImporter;
import org.alfresco.repo.importer.FileImporterException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileImporterImpl
implements FileImporter {
    private static Log logger = LogFactory.getLog(FileImporterImpl.class);
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private TransactionService transactionService;
    private boolean txnPerFile = false;

    @Override
    public int loadFile(NodeRef container, File file, boolean recurse) throws FileImporterException {
        try {
            Counter counter = new Counter();
            this.create(counter, container, file, null, recurse, null);
            return counter.getCount();
        }
        catch (Throwable e) {
            throw new FileImporterException("Failed to load file: \n   container: " + container + "\n" + "   file: " + file + "\n" + "   recurse: " + recurse, e);
        }
    }

    @Override
    public int loadNamedFile(NodeRef container, File file, boolean recurse, String name) throws FileImporterException {
        try {
            Counter counter = new Counter();
            this.create(counter, container, file, null, recurse, name);
            return counter.getCount();
        }
        catch (Throwable e) {
            throw new FileImporterException("Failed to load file: \n   container: " + container + "\n" + "   file: " + file + "\n" + "   name: " + name + "\n" + "   recurse: " + recurse, e);
        }
    }

    @Override
    public int loadFile(NodeRef container, File file, FileFilter filter, boolean recurse) throws FileImporterException {
        try {
            Counter counter = new Counter();
            this.create(counter, container, file, filter, recurse, null);
            return counter.getCount();
        }
        catch (Throwable e) {
            throw new FileImporterException("Failed to load file: \n   container: " + container + "\n" + "   file: " + file + "\n" + "   filter: " + filter + "\n" + "   recurse: " + recurse, e);
        }
    }

    @Override
    public int loadFile(NodeRef container, File file) throws FileImporterException {
        try {
            Counter counter = new Counter();
            this.create(counter, container, file, null, false, null);
            return counter.getCount();
        }
        catch (Throwable e) {
            throw new FileImporterException("Failed to load file: \n   container: " + container + "\n" + "   file: " + file, e);
        }
    }

    private NodeRef create(Counter counter, final NodeRef container, final File file, FileFilter filter, boolean recurse, final String containerName) throws Throwable {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        if (containerName != null) {
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createDirectoryWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    return FileImporterImpl.this.createDirectory(container, containerName, containerName);
                }
            };
            NodeRef newContainer = txnHelper.doInTransaction(createDirectoryWork);
            return this.create(counter, newContainer, file, filter, recurse, null);
        }
        if (file.isDirectory()) {
            counter.increment();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createDirectoryWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    return FileImporterImpl.this.createDirectory(container, file);
                }
            };
            NodeRef directoryNodeRef = null;
            directoryNodeRef = this.txnPerFile ? txnHelper.doInTransaction(createDirectoryWork) : (NodeRef)createDirectoryWork.execute();
            if (recurse) {
                File[] files = filter == null ? file.listFiles() : file.listFiles(filter);
                for (int i = 0; i < files.length; ++i) {
                    this.create(counter, directoryNodeRef, files[i], filter, recurse, null);
                }
            }
            return directoryNodeRef;
        }
        counter.increment();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createFileWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return FileImporterImpl.this.createFile(container, file);
            }
        };
        NodeRef fileNodeRef = null;
        fileNodeRef = this.txnPerFile ? txnHelper.doInTransaction(createFileWork) : (NodeRef)createFileWork.execute();
        return fileNodeRef;
    }

    private QName getAssocTypeQName(NodeRef parentNodeRef) {
        QName parentNodeTypeQName = this.nodeService.getType(parentNodeRef);
        QName assocTypeQName = null;
        if (this.dictionaryService.isSubClass(parentNodeTypeQName, ContentModel.TYPE_CONTAINER)) {
            assocTypeQName = ContentModel.ASSOC_CHILDREN;
        } else if (this.dictionaryService.isSubClass(parentNodeTypeQName, ContentModel.TYPE_FOLDER)) {
            assocTypeQName = ContentModel.ASSOC_CONTAINS;
        }
        return assocTypeQName;
    }

    private NodeRef createFile(NodeRef parentNodeRef, File file) {
        QName assocTypeQName = this.getAssocTypeQName(parentNodeRef);
        if (assocTypeQName == null) {
            throw new IllegalArgumentException("Unable to create file.  Parent type is inappropriate: " + this.nodeService.getType(parentNodeRef));
        }
        FileContentReader reader = new FileContentReader(file);
        String mimetype = this.mimetypeService.guessMimetype(file.getName(), (ContentReader)reader);
        HashMap<QName, String> contentProps = new HashMap<QName, String>(3, 1.0f);
        contentProps.put(ContentModel.PROP_NAME, file.getName());
        contentProps.put(ContentModel.PROP_CONTENT, (String)new ContentData(null, mimetype, 0L, "UTF-8"));
        String currentUser = this.authenticationService.getCurrentUserName();
        contentProps.put(ContentModel.PROP_CREATOR, currentUser == null ? "unknown" : currentUser);
        String assocName = QName.createValidLocalName((String)file.getName());
        ChildAssociationRef assocRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)assocName), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef fileNodeRef = assocRef.getChildRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created file node for file: " + file.getName()));
        }
        HashMap<QName, String> titledProps = new HashMap<QName, String>(5);
        titledProps.put(ContentModel.PROP_TITLE, file.getName());
        titledProps.put(ContentModel.PROP_DESCRIPTION, file.getPath());
        this.nodeService.addAspect(fileNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added titled aspect with properties: " + titledProps));
        }
        ContentWriter writer = this.contentService.getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
        try {
            writer.putContent((InputStream)new BufferedInputStream(new FileInputStream(file)));
        }
        catch (ContentIOException e) {
            throw new FileImporterException("Failed to load content from " + file.getPath(), e);
        }
        catch (FileNotFoundException e) {
            throw new FileImporterException("Failed to load content (file not found) " + file.getPath(), e);
        }
        return fileNodeRef;
    }

    private NodeRef createDirectory(NodeRef parentNodeRef, File file) {
        return this.createDirectory(parentNodeRef, file.getName(), file.getPath());
    }

    private NodeRef createDirectory(NodeRef parentNodeRef, String name, String path) {
        QName assocTypeQName = this.getAssocTypeQName(parentNodeRef);
        if (assocTypeQName == null) {
            throw new IllegalArgumentException("Unable to create directory.  Parent type is inappropriate: " + this.nodeService.getType(parentNodeRef));
        }
        String qname = QName.createValidLocalName((String)name);
        ChildAssociationRef assocRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), ContentModel.TYPE_FOLDER);
        NodeRef nodeRef = assocRef.getChildRef();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created folder node with name: " + name));
        }
        HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(5);
        uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-default");
        uiFacetsProps.put(ContentModel.PROP_TITLE, name);
        uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, path);
        this.nodeService.addAspect(nodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added uifacets aspect with properties: " + uiFacetsProps));
        }
        return nodeRef;
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTxnPerFile(boolean txnPerFile) {
        this.txnPerFile = txnPerFile;
    }

    private static class Counter {
        private int count = 0;

        private Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

