/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.service.cmr.invitation.Invitation;

abstract class InvitationImpl {
    public static final String ID_KEY = "id";
    public static final String INVITEE_KEY = "invitee";
    public static final String RESOURCE_NAME_KEY = "resourceName";
    public static final String RESOURCE_TYPE_KEY = "resourceType";
    public static final String ROLE_KEY = "role";
    public static final String CREATED_AT = "createdAt";
    public static final String MODIFIED_AT = "modifiedAt";
    private final String inviteId;
    private final String resourceName;
    private final Invitation.ResourceType resourceType;
    private final String roleName;
    private final String inviteeUserName;
    private final Date createdAt;
    private final Date modifiedAt;

    public InvitationImpl(Map<String, Serializable> props) {
        this.inviteId = (String)((Object)props.get(ID_KEY));
        this.inviteeUserName = (String)((Object)props.get(INVITEE_KEY));
        this.resourceName = (String)((Object)props.get(RESOURCE_NAME_KEY));
        this.roleName = (String)((Object)props.get(ROLE_KEY));
        String type = (String)((Object)props.get(RESOURCE_TYPE_KEY));
        this.resourceType = type == null ? Invitation.ResourceType.WEB_SITE : Invitation.ResourceType.valueOf(type);
        this.createdAt = (Date)props.get(CREATED_AT);
        this.modifiedAt = (Date)props.get(MODIFIED_AT);
    }

    public Invitation.ResourceType getResourceType() {
        return this.resourceType;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public String getInviteId() {
        return this.inviteId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getInviteeUserName() {
        return this.inviteeUserName;
    }

    public abstract Invitation.InvitationType getInvitationType();
}

