/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.script;

import java.util.List;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.script.ScriptInvitation;
import org.alfresco.repo.invitation.script.ScriptInvitationFactory;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ParameterCheck;
import org.mozilla.javascript.Scriptable;
import org.springframework.beans.factory.InitializingBean;

public class ScriptInvitationService
extends BaseScopableProcessorExtension
implements InitializingBean {
    private InvitationService invitationService;
    private NodeService nodeService;
    private PersonService personService;
    private ScriptInvitationFactory scriptInvitationFactory;

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ScriptInvitation<?>[] listInvitations(Scriptable props) {
        InvitationSearchCriteriaImpl crit = new InvitationSearchCriteriaImpl();
        if (props.has("resourceName", props)) {
            crit.setResourceName((String)props.get("resourceName", props));
        }
        if (props.has("resourceType", props)) {
            crit.setResourceType(Invitation.ResourceType.valueOf((String)props.get("resourceType", props)));
        }
        if (props.has("inviteeUserName", props)) {
            crit.setInvitee((String)props.get("inviteeUserName", props));
        }
        if (props.has("invitationType", props)) {
            String invitationType = (String)props.get("invitationType", props);
            crit.setInvitationType(InvitationSearchCriteria.InvitationType.valueOf(invitationType));
        }
        List<Invitation> invitations = this.invitationService.searchInvitation(crit);
        ScriptInvitation[] ret = new ScriptInvitation[invitations.size()];
        int i = 0;
        for (Invitation item : invitations) {
            ret[i++] = this.scriptInvitationFactory.toScriptInvitation(item);
        }
        return ret;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodeService", (Object)this.nodeService);
        ParameterCheck.mandatory((String)"personService", (Object)this.personService);
        ParameterCheck.mandatory((String)"invitationService", (Object)this.invitationService);
        this.scriptInvitationFactory = new ScriptInvitationFactory(this.invitationService, this.nodeService, this.personService);
    }
}

