/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;

public class ScriptTestUtils
extends BaseScopableProcessorExtension {
    public void assertEquals(Object expected, Object value) {
        this.assertEquals(expected, value, null);
    }

    public void assertEquals(Object expected, Object value, String message) {
        if (expected == null && value == null) {
            return;
        }
        if (expected == null && value != null || !expected.equals(value)) {
            if (message == null) {
                message = "Expected value '" + expected + "' was '" + value + "'";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertNotEquals(Object expected, Object value) {
        this.assertNotEquals(expected, value, null);
    }

    public void assertNotEquals(Object expected, Object value, String message) {
        if (expected.equals(value)) {
            if (message == null) {
                message = "Expected value '" + expected + "' should not match recieved value '" + value + "'";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertNotNull(Object value) {
        this.assertNotNull(value, null);
    }

    public void assertNotNull(Object value, String message) {
        if (value == null) {
            if (message == null) {
                message = "Unexpected null value encountered.";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertNull(Object value) {
        this.assertNull(value, null);
    }

    public void assertNull(Object value, String message) {
        if (value != null) {
            if (message == null) {
                message = "Unexpected non-null value encountered.";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertTrue(boolean value) {
        this.assertTrue(value, null);
    }

    public void assertTrue(boolean value, String message) {
        if (!value) {
            if (message == null) {
                message = "Value is not True";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertFalse(boolean value) {
        this.assertFalse(value, null);
    }

    public void assertFalse(boolean value, String message) {
        if (value) {
            if (message == null) {
                message = "Value is not False";
            }
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void assertContains(String value, String subString) {
        this.assertContains(value, subString, null);
    }

    public void assertContains(String value, String subString, String message) {
        if (!value.contains(subString)) {
            throw new AlfrescoRuntimeException(message);
        }
    }

    public void fail(String message) {
        throw new AlfrescoRuntimeException(message);
    }
}

