/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.PropertyDecorator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.util.URLEncoder;

public class JSONConversionComponent {
    private static final String CONTENT_DOWNLOAD_API_URL = "/api/node/content/{0}/{1}/{2}/{3}";
    private static Log logger = LogFactory.getLog(JSONConversionComponent.class);
    protected Map<QName, PropertyDecorator> propertyDecorators = new HashMap<QName, PropertyDecorator>(8);
    protected String[] userPermissions;
    protected static ThreadLocal<Map<String, String>> namespacePrefixCache = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>(8);
        }
    };
    protected NodeService nodeService;
    protected PublicServiceAccessService publicServiceAccessService;
    protected NamespaceService namespaceService;
    protected FileFolderService fileFolderService;
    protected LockService lockService;
    protected ContentService contentService;
    protected PermissionService permissionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublicServiceAccessService(PublicServiceAccessService publicServiceAccessService) {
        this.publicServiceAccessService = publicServiceAccessService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setUserPermissions(String[] userPermissions) {
        this.userPermissions = userPermissions;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void registerPropertyDecorator(PropertyDecorator propertyDecorator) {
        for (QName propertyName : propertyDecorator.getPropertyNames()) {
            this.propertyDecorators.put(propertyName, propertyDecorator);
        }
    }

    public String toJSON(NodeRef nodeRef, boolean useShortQNames) {
        JSONObject json = new JSONObject();
        if (this.nodeService.exists(nodeRef) && this.publicServiceAccessService.hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "getProperties", nodeRef) == AccessStatus.ALLOWED) {
            namespacePrefixCache.get().clear();
            FileInfo nodeInfo = this.fileFolderService.getFileInfo(nodeRef);
            this.setRootValues(nodeInfo, json, useShortQNames);
            json.put((Object)"permissions", (Object)this.permissionsToJSON(nodeRef));
            json.put((Object)"properties", (Object)this.propertiesToJSON(nodeRef, nodeInfo.getProperties(), useShortQNames));
            json.put((Object)"aspects", (Object)this.apsectsToJSON(nodeRef, useShortQNames));
        }
        return json.toJSONString();
    }

    protected void setRootValues(FileInfo nodeInfo, JSONObject rootJSONObject, boolean useShortQNames) {
        ContentData cdata;
        NodeRef targetNodeRef;
        NodeRef nodeRef = nodeInfo.getNodeRef();
        rootJSONObject.put((Object)"nodeRef", (Object)nodeInfo.getNodeRef().toString());
        rootJSONObject.put((Object)"type", (Object)this.nameToString(nodeInfo.getType(), useShortQNames));
        rootJSONObject.put((Object)"isContainer", (Object)nodeInfo.isFolder());
        rootJSONObject.put((Object)"isLocked", (Object)this.isLocked(nodeInfo.getNodeRef()));
        rootJSONObject.put((Object)"isLink", (Object)nodeInfo.isLink());
        if (nodeInfo.isLink() && (targetNodeRef = nodeInfo.getLinkNodeRef()) != null) {
            rootJSONObject.put((Object)"linkedNode", (Object)this.toJSON(targetNodeRef, useShortQNames));
        }
        if (!nodeInfo.isFolder() && (cdata = nodeInfo.getContentData()) != null) {
            String contentURL = MessageFormat.format(CONTENT_DOWNLOAD_API_URL, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), URLEncoder.encode((String)nodeInfo.getName()));
            rootJSONObject.put((Object)"contentURL", (Object)contentURL);
            rootJSONObject.put((Object)"mimetype", (Object)cdata.getMimetype());
            rootJSONObject.put((Object)"encoding", (Object)cdata.getEncoding());
            rootJSONObject.put((Object)"size", (Object)cdata.getSize());
        }
    }

    protected JSONObject permissionsToJSON(NodeRef nodeRef) {
        JSONObject permissionsJSON = new JSONObject();
        if (AccessStatus.ALLOWED.equals((Object)this.permissionService.hasPermission(nodeRef, "ReadPermissions"))) {
            permissionsJSON.put((Object)"inherited", (Object)this.permissionService.getInheritParentPermissions(nodeRef));
            permissionsJSON.put((Object)"roles", (Object)this.allSetPermissionsToJSON(nodeRef));
            permissionsJSON.put((Object)"user", (Object)this.userPermissionsToJSON(nodeRef));
        }
        return permissionsJSON;
    }

    protected JSONObject userPermissionsToJSON(NodeRef nodeRef) {
        JSONObject userPermissionJSON = new JSONObject();
        for (String userPermission : this.userPermissions) {
            boolean hasPermission = AccessStatus.ALLOWED.equals((Object)this.permissionService.hasPermission(nodeRef, userPermission));
            userPermissionJSON.put((Object)userPermission, (Object)hasPermission);
        }
        return userPermissionJSON;
    }

    protected Object propertyToJSON(NodeRef nodeRef, QName propertyName, String key, Serializable value) {
        if (value != null) {
            if (this.propertyDecorators.containsKey(propertyName)) {
                JSONAware jsonAware = this.propertyDecorators.get(propertyName).decorate(propertyName, nodeRef, value);
                if (jsonAware != null) {
                    return jsonAware;
                }
            } else {
                if (value instanceof Date) {
                    JSONObject dateObj = new JSONObject();
                    dateObj.put((Object)"value", (Object)JSONObject.escape((String)value.toString()));
                    dateObj.put((Object)"iso8601", (Object)JSONObject.escape((String)ISO8601DateFormat.format((Date)((Date)value))));
                    return dateObj;
                }
                if (value instanceof List) {
                    ArrayList<Object> jsonList = new ArrayList<Object>(((List)((Object)value)).size());
                    for (Serializable listItem : (List)((Object)value)) {
                        jsonList.add(this.propertyToJSON(nodeRef, propertyName, key, listItem));
                    }
                    return jsonList;
                }
                if (value instanceof Double) {
                    return Double.isInfinite((Double)value) || Double.isNaN((Double)value) ? null : value.toString();
                }
                if (value instanceof Float) {
                    return Float.isInfinite(((Float)value).floatValue()) || Float.isNaN(((Float)value).floatValue()) ? null : value.toString();
                }
                return value.toString();
            }
        }
        return null;
    }

    protected JSONObject propertiesToJSON(NodeRef nodeRef, Map<QName, Serializable> properties, boolean useShortQNames) {
        JSONObject propertiesJSON = new JSONObject();
        for (QName propertyName : properties.keySet()) {
            try {
                String key = this.nameToString(propertyName, useShortQNames);
                Serializable value = properties.get(propertyName);
                propertiesJSON.put((Object)key, this.propertyToJSON(nodeRef, propertyName, key, value));
            }
            catch (NamespaceException ne) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring property '" + propertyName + "' as its namespace is not registered"));
            }
        }
        return propertiesJSON;
    }

    protected JSONArray apsectsToJSON(NodeRef nodeRef, boolean useShortQNames) {
        JSONArray aspectsJSON = new JSONArray();
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            aspectsJSON.add((Object)this.nameToString(aspect, useShortQNames));
        }
        return aspectsJSON;
    }

    protected JSONArray allSetPermissionsToJSON(NodeRef nodeRef) {
        Set acls = this.permissionService.getAllSetPermissions(nodeRef);
        JSONArray permissions = new JSONArray();
        for (AccessPermission permission : acls) {
            StringBuilder buf = new StringBuilder(64);
            buf.append(permission.getAccessStatus()).append(';').append(permission.getAuthority()).append(';').append(permission.getPermission()).append(';').append(permission.isSetDirectly() ? "DIRECT" : "INHERITED");
            permissions.add((Object)buf.toString());
        }
        return permissions;
    }

    private String nameToString(QName qname, boolean isShortName) {
        String result;
        if (isShortName) {
            Map<String, String> cache = namespacePrefixCache.get();
            String prefix = cache.get(qname.getNamespaceURI());
            if (prefix == null) {
                Collection prefixes = this.namespaceService.getPrefixes(qname.getNamespaceURI());
                prefix = prefixes.size() != 0 ? (String)prefixes.iterator().next() : "";
                cache.put(qname.getNamespaceURI(), prefix);
            }
            result = prefix + ':' + qname.getLocalName();
        } else {
            result = qname.toString();
        }
        return result;
    }

    private boolean isLocked(NodeRef nodeRef) {
        LockStatus lockStatus;
        boolean locked = false;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.lockService.getLockStatus(nodeRef)) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            locked = true;
        }
        return locked;
    }
}

