/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.util.Date;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;

public class LockUtils {
    public static boolean isLockedAndNotLockOwner(NodeRef nodeRef, LockService lockService) {
        LockStatus lockStatus = lockService.getLockStatus(nodeRef);
        switch (lockStatus) {
            case NO_LOCK: 
            case LOCK_EXPIRED: 
            case LOCK_OWNER: {
                return false;
            }
        }
        return true;
    }

    public static boolean isLockedAndReadOnly(NodeRef nodeRef, LockService lockService) {
        LockStatus lockStatus = lockService.getLockStatus(nodeRef);
        switch (lockStatus) {
            case NO_LOCK: 
            case LOCK_EXPIRED: {
                return false;
            }
            case LOCK_OWNER: {
                return !lockService.getLockType(nodeRef).equals((Object)LockType.WRITE_LOCK);
            }
        }
        return true;
    }

    public static LockStatus lockStatus(String userName, String lockOwner, Date expiryDate) {
        LockStatus result = LockStatus.NO_LOCK;
        if (lockOwner != null) {
            result = expiryDate != null && expiryDate.before(new Date()) ? LockStatus.LOCK_EXPIRED : (lockOwner.equals(userName) ? LockStatus.LOCK_OWNER : LockStatus.LOCKED);
        }
        return result;
    }
}

