/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock.mem;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.lock.mem.LockStore;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class LockableAspectInterceptor
implements MethodInterceptor {
    private LockStore lockStore;
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private final ThreadLocal<Boolean> threadEnabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.threadEnabled.get().booleanValue()) {
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        if (methodName.equals("hasAspect")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName aspectTypeQName = (QName)args[1];
            LockState lockState = this.lockStore.get(nodeRef);
            if (ContentModel.ASPECT_LOCKABLE.equals((Object)aspectTypeQName) && this.isEphemeralLock(lockState)) {
                return true;
            }
            return invocation.proceed();
        }
        if (methodName.equals("getAspects")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Set aspects = (Set)invocation.proceed();
            LockState lockState = this.lockStore.get(nodeRef);
            if (this.isEphemeralLock(lockState) && !aspects.contains(ContentModel.ASPECT_LOCKABLE)) {
                aspects.add(ContentModel.ASPECT_LOCKABLE);
            }
            return aspects;
        }
        if (methodName.equals("getProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map properties = (Map)invocation.proceed();
            LockState lockState = this.lockStore.get(nodeRef);
            if (this.isEphemeralLock(lockState)) {
                String userName = lockState.getOwner();
                properties.put(ContentModel.PROP_LOCK_OWNER, userName);
                properties.put(ContentModel.PROP_LOCK_TYPE, lockState.getLockType().toString());
                properties.put(ContentModel.PROP_EXPIRY_DATE, lockState.getExpires());
                properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.EPHEMERAL);
            } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && !properties.containsKey(ContentModel.PROP_LOCK_LIFETIME)) {
                properties.put(ContentModel.PROP_LOCK_LIFETIME, Lifetime.PERSISTENT);
            }
            return properties;
        }
        if (methodName.equals("getProperty")) {
            NodeRef nodeRef = (NodeRef)args[0];
            QName propQName = (QName)args[1];
            if (this.isLockProperty(propQName)) {
                LockState lockState = this.lockStore.get(nodeRef);
                if (this.isEphemeralLock(lockState)) {
                    if (ContentModel.PROP_LOCK_OWNER.equals((Object)propQName)) {
                        return lockState.getOwner();
                    }
                    if (ContentModel.PROP_LOCK_TYPE.equals((Object)propQName)) {
                        return lockState.getLockType().toString();
                    }
                    if (ContentModel.PROP_EXPIRY_DATE.equals((Object)propQName)) {
                        return lockState.getExpires();
                    }
                    if (ContentModel.PROP_LOCK_LIFETIME.equals((Object)propQName)) {
                        return lockState.getLifetime().toString();
                    }
                } else if (ContentModel.PROP_LOCK_LIFETIME.equals((Object)propQName) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
                    return Lifetime.PERSISTENT.toString();
                }
            }
            return invocation.proceed();
        }
        if (methodName.equals("setProperties")) {
            NodeRef nodeRef = (NodeRef)args[0];
            Map newProperties = (Map)args[1];
            if (newProperties.get(ContentModel.PROP_LOCK_LIFETIME) == Lifetime.EPHEMERAL) {
                Map<QName, Serializable> convertedProperties = this.filterLockProperties(newProperties);
                this.nodeService.setProperties(nodeRef, convertedProperties);
                return null;
            }
            if (newProperties.containsKey(ContentModel.PROP_LOCK_LIFETIME)) {
                newProperties.remove(ContentModel.PROP_LOCK_LIFETIME);
                this.nodeService.setProperties(nodeRef, newProperties);
                return null;
            }
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    public void enableForThread() {
        this.threadEnabled.set(Boolean.TRUE);
    }

    public void disableForThread() {
        this.threadEnabled.set(Boolean.FALSE);
    }

    private Map<QName, Serializable> filterLockProperties(Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> filteredProps = new HashMap<QName, Serializable>(properties.size() * 2);
        for (QName propQName : properties.keySet()) {
            if (this.isLockProperty(propQName)) continue;
            filteredProps.put(propQName, properties.get(propQName));
        }
        return filteredProps;
    }

    private boolean isLockProperty(QName propQName) {
        boolean isLockProp = propQName.equals((Object)ContentModel.PROP_LOCK_OWNER) || propQName.equals((Object)ContentModel.PROP_LOCK_TYPE) || propQName.equals((Object)ContentModel.PROP_LOCK_LIFETIME) || propQName.equals((Object)ContentModel.PROP_EXPIRY_DATE);
        return isLockProp;
    }

    private boolean isEphemeralLock(LockState lockState) {
        boolean ephemeral = lockState != null && lockState.isLockInfo() && lockState.getLifetime() == Lifetime.EPHEMERAL;
        return ephemeral;
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

