/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.mail;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class AlfrescoJavaMailSender
extends JavaMailSenderImpl {
    private static final long DEAFULT_TIME_BETWEEN_EVICTION_RUNS = 30000L;
    private static final Logger log = LoggerFactory.getLogger(AlfrescoJavaMailSender.class);
    private GenericKeyedObjectPool transportPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new TransportFactory());

    public AlfrescoJavaMailSender() {
        this.transportPool.setMaxActive(-1);
        this.transportPool.setTestOnBorrow(true);
        this.transportPool.setTestOnReturn(true);
        this.transportPool.setTimeBetweenEvictionRunsMillis(30000L);
        this.transportPool.setMinEvictableIdleTimeMillis(30000L);
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return new PooledTransportWrapper(this.transportPool, session, this.getProtocol());
    }

    public void setMaxActive(int maxActive) {
        this.transportPool.setMaxActive(maxActive);
    }

    public void setMaxIdle(int maxIdle) {
        this.transportPool.setMaxIdle(maxIdle);
    }

    public void setMaxWait(long maxWait) {
        this.transportPool.setMaxWait(maxWait);
    }

    public void setTimeBetweenEvictionRuns(long time) {
        this.transportPool.setTimeBetweenEvictionRunsMillis(time);
    }

    public void setMinEvictableIdleTime(long time) {
        this.transportPool.setMinEvictableIdleTimeMillis(time);
    }

    private static class PooledTransportWrapper
    extends Transport {
        private Transport wrapped = null;
        private String protocol;
        private GenericKeyedObjectPool pool;

        private PooledTransportWrapper(GenericKeyedObjectPool transportPool, Session session, String protocol) {
            super(session, new URLName(protocol, null, 0, null, null, null));
            this.pool = transportPool;
            this.protocol = protocol;
        }

        public void sendMessage(Message message, Address[] addresses) throws MessagingException {
            if (this.wrapped == null) {
                throw new IllegalStateException("Not connected!");
            }
            this.wrapped.sendMessage(message, addresses);
        }

        public synchronized void close() throws MessagingException {
            if (this.wrapped == null || !this.isConnected()) {
                throw new IllegalStateException("Already closed");
            }
            try {
                log.debug("Returning transport to pool");
                this.pool.returnObject((Object)this.getURLName(), (Object)this.wrapped);
                this.wrapped = null;
            }
            catch (Exception error) {
                throw new MessagingException("Unexpected exception returning transport to pool", error);
            }
            finally {
                super.close();
            }
        }

        protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
            URLName name = new URLName(this.protocol, host, port, null, username, password);
            try {
                log.debug("Borrowing object from pool");
                this.wrapped = (Transport)this.pool.borrowObject((Object)name);
                return true;
            }
            catch (MessagingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new MessagingException("Unexpected exception borrwoing connection from pool", ex);
            }
        }
    }

    private final class TransportFactory
    implements KeyedPoolableObjectFactory {
        private TransportFactory() {
        }

        public Object makeObject(Object key) throws Exception {
            if (!(key instanceof URLName)) {
                throw new IllegalArgumentException("Invlid key type");
            }
            log.debug("Creating new Transport");
            URLName urlName = (URLName)key;
            Transport transport = AlfrescoJavaMailSender.this.getSession().getTransport(urlName.getProtocol());
            transport.connect(urlName.getHost(), urlName.getPort(), urlName.getUsername(), urlName.getPassword());
            return transport;
        }

        public void destroyObject(Object key, Object object) throws Exception {
            if (!(object instanceof Transport)) {
                throw new IllegalArgumentException("Unexpected object type");
            }
            log.debug("Destroying Transpaort");
            Transport transport = (Transport)object;
            transport.close();
        }

        public boolean validateObject(Object key, Object object) {
            if (!(object instanceof Transport)) {
                throw new IllegalArgumentException("Unexpected object type");
            }
            log.debug("Validating transport");
            Transport transport = (Transport)object;
            return transport.isConnected();
        }

        public void activateObject(Object key, Object obj) throws Exception {
        }

        public void passivateObject(Object key, Object obj) throws Exception {
        }
    }
}

